/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.http.session.SessionManager;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RequestAdapter
extends AbstractRequest {
    static L10N L = new L10N("com/caucho/server/http/messages");
    static final int MAX_DEPTH = 64;
    private static final FreeList _freeList = new FreeList(32);
    HttpServletRequest request;
    private CharBuffer pageUri = new CharBuffer();
    private CharBuffer pageQuery = new CharBuffer();
    private Application application;
    private CauchoResponse response;

    protected RequestAdapter() {
        this.request = null;
    }

    protected RequestAdapter(HttpServletRequest request, Application app) {
        this.request = request;
        this.application = app;
    }

    public static RequestAdapter create(HttpServletRequest request, Application app) {
        RequestAdapter reqAdapt = (RequestAdapter)_freeList.allocate();
        if (reqAdapt == null) {
            return new RequestAdapter(request, app);
        }
        reqAdapt.request = request;
        reqAdapt.application = app;
        return reqAdapt;
    }

    public static RequestAdapter create() {
        RequestAdapter reqAdapt = (RequestAdapter)_freeList.allocate();
        if (reqAdapt != null) {
            return reqAdapt;
        }
        return new RequestAdapter();
    }

    public void init(HttpServletRequest request, CauchoResponse response, Application app) throws ServletException {
        super.start();
        this.request = request;
        this.response = response;
        this.pageUri.clear();
        this.pageQuery.clear();
        this.application = app;
        if (request == this || request instanceof CauchoRequest && ((CauchoRequest)request).getRequestDepth(0) > 64) {
            throw new ServletException(L.l("too many servlet includes `{0}'", request.getRequestURI()));
        }
    }

    public void setApplication(Application app) {
        this.application = app;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    protected CauchoResponse getResponse() {
        return this.response;
    }

    public ReadStream getStream() throws IOException {
        if (this.request instanceof CauchoRequest) {
            return ((CauchoRequest)this.request).getStream();
        }
        return null;
    }

    public int getRequestDepth(int depth) {
        if (depth > 64) {
            throw new RuntimeException(L.l("too many request dispatchers"));
        }
        if (this.request instanceof CauchoRequest) {
            return ((CauchoRequest)this.request).getRequestDepth(depth + 1);
        }
        return depth + 2;
    }

    public long getDate() {
        if (this.request instanceof CauchoRequest) {
            return ((CauchoRequest)this.request).getDate();
        }
        return Alarm.getCurrentTime();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public CharSegment getMethodBuffer() {
        if (this.request instanceof AbstractRequest) {
            return ((AbstractRequest)this.request).getMethodBuffer();
        }
        CharBuffer cb = new CharBuffer();
        cb.append(this.getMethod());
        return cb;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public CharBuffer getPageUriBuffer() {
        if (this.pageUri.length() == 0) {
            this.pageUri.append(this.getPageURI());
        }
        return this.pageUri;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public CharBuffer getPageQueryBuffer() {
        if (this.pageQuery.length() == 0) {
            this.pageQuery.append(this.getPageQueryString());
        }
        return this.pageQuery;
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(encoding);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getHeader(String key) {
        return this.request.getHeader(key);
    }

    public void setHeader(String key, String value) {
    }

    public Application getApplication() {
        return this.application;
    }

    public CauchoApplication getCauchoApplication() {
        return this.application;
    }

    protected void setVaryCookie(String cookie) {
        super.setVaryCookie(cookie);
        if (this.request instanceof AbstractRequest) {
            ((AbstractRequest)this.request).setVaryCookie(cookie);
        }
    }

    protected void setHasCookie() {
        super.setHasCookie();
        if (this.request instanceof AbstractRequest) {
            ((AbstractRequest)this.request).setHasCookie();
        }
    }

    public HttpSession getSession(boolean create) {
        SessionManager manager = this.application.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        HttpSession session = this.request.getSession(create);
        if (session != null) {
            this.setHasCookie();
        }
        return session;
    }

    public String getRequestedSessionId() {
        SessionManager manager = this.application.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        String id = this.request.getRequestedSessionId();
        if (id != null) {
            this.setHasCookie();
        }
        return id;
    }

    public boolean isRequestedSessionIdValid() {
        SessionManager manager = this.application.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        boolean isValid = this.request.isRequestedSessionIdValid();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    public boolean isRequestedSessionIdFromCookie() {
        SessionManager manager = this.application.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        boolean isValid = this.request.isRequestedSessionIdFromCookie();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    public boolean isRequestedSessionIdFromURL() {
        SessionManager manager = this.application.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        boolean isValid = this.request.isRequestedSessionIdFromURL();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    public int getSessionGroup() {
        if (this.request instanceof AbstractRequest) {
            return ((AbstractRequest)this.request).getSessionGroup();
        }
        return 0;
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public Map getParameterMap() {
        return this.request.getParameterMap();
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Cookie[] getCookies() {
        this.setVaryCookie(null);
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null && cookies.length > 0) {
            this.setHasCookie();
        }
        return cookies;
    }

    public Cookie getCookie(String name) {
        this.setVaryCookie(name);
        if (this.request instanceof CauchoRequest) {
            return ((CauchoRequest)this.request).getCookie(name);
        }
        Cookie[] cookies = this.request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            this.setHasCookie();
            return cookies[i];
        }
        return null;
    }

    public String getRealPath(String path) {
        return this.request.getRealPath(path);
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public static void free(RequestAdapter reqAdapt) {
        reqAdapt.free();
        _freeList.free(reqAdapt);
    }

    protected void free() {
        super.free();
        this.request = null;
        this.response = null;
        this.application = null;
        this.invocation = null;
        this.cache = null;
    }
}

