/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.util.L10N;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLFactory {
    static L10N L = new L10N(class$com$caucho$server$http$SSLFactory == null ? (class$com$caucho$server$http$SSLFactory = SSLFactory.class$("com.caucho.server.http.SSLFactory")) : class$com$caucho$server$http$SSLFactory);
    static /* synthetic */ Class class$com$caucho$server$http$SSLFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerSocket getServerSocket(String name, RegistryNode node, String host, int port, int listen) throws Exception {
        name = "ssl " + name;
        String keyStoreType = node.getString("key-store-type", "jks");
        String keyStoreFile = node.getString("key-store-file", null);
        if (keyStoreFile == null) {
            throw Application.error(node, L.l("ssl expects key-store-file"));
        }
        String keyStorePassword = node.getString("key-store-password", null);
        if (keyStorePassword == null) {
            throw Application.error(node, L.l("ssl expects key-store-password"));
        }
        boolean authenticateClient = node.getBoolean("authenticate-client", false);
        String verifyClient = node.getString("verify-client", null);
        if (verifyClient != null && !verifyClient.equals("none")) {
            authenticateClient = true;
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        ReadStream is = Vfs.openRead(keyStoreFile);
        try {
            keyStore.load(is, keyStorePassword.toCharArray());
        }
        finally {
            ((InputStream)is).close();
        }
        String keyManagerFactory = node.getString("key-manager-factory", "SunX509");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactory);
        kmf.init(keyStore, keyStorePassword.toCharArray());
        String sslContextName = node.getString("ssl-context", "TLS");
        SSLContext sslContext = SSLContext.getInstance(sslContextName);
        sslContext.init(kmf.getKeyManagers(), null, null);
        SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
        ServerSocket serverSocket = null;
        try {
            if (host == null || host.equals("*")) {
                serverSocket = factory.createServerSocket(port, listen);
                System.out.println(name + " listening to *:" + port);
            } else {
                InetAddress hostAddr = InetAddress.getByName(host);
                serverSocket = factory.createServerSocket(port, listen, hostAddr);
                System.out.println(name + " listening to " + host + ":" + port);
            }
        }
        catch (BindException e) {
            if (host == null) {
                System.out.println(name + " can't bind to port *:" + port + ". Check for conflicting servers.");
            } else {
                InetAddress hostAddr = InetAddress.getByName(host);
                System.out.println(name + " can't bind to port " + host + ":" + port + ".");
                System.out.println("1) Check for conflicting servers.");
                System.out.println("2) Check that " + hostAddr + " is a valid interface for this machine.");
            }
            throw e;
        }
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket;
        if (authenticateClient) {
            sslServerSocket.setNeedClientAuth(true);
        }
        boolean hasRestriction = false;
        ArrayList<String> protocols = new ArrayList<String>();
        if (node.getBoolean("tls1", true)) {
            protocols.add("TLSv1");
            protocols.add("TLS");
        } else {
            hasRestriction = true;
        }
        if (node.getBoolean("ssl2", true)) {
            protocols.add("SSLv2");
        } else {
            hasRestriction = true;
        }
        if (node.getBoolean("ssl3", true)) {
            protocols.add("SSLv3");
        } else {
            hasRestriction = true;
        }
        if (hasRestriction) {
            sslServerSocket.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        }
        return serverSocket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

