/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.QServletOutputStream;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;

class StreamResponse
implements CauchoResponse {
    private CauchoResponse response;
    private WriteStream stream;
    private QServletOutputStream os;
    private HashMap headers;
    private String charEncoding;
    private boolean forbidForward;
    private boolean hasError;

    StreamResponse(ServletResponse response, WriteStream stream) {
        this.response = (CauchoResponse)response;
        this.stream = stream;
        this.os = new QServletOutputStream();
        this.os.init(stream);
        this.headers = new HashMap();
    }

    public WriteStream getStream() {
        return this.stream;
    }

    public void setStream(WriteStream stream) {
        this.stream = stream;
    }

    public void close() throws IOException {
        this.stream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void setContentLength(int i) {
        this.response.setContentLength(i);
    }

    public String encodeRedirectURL(String string) {
        return this.response.encodeRedirectURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.response.encodeRedirectURL(string);
    }

    public String encodeURL(String string) {
        return this.response.encodeURL(string);
    }

    public String encodeUrl(String string) {
        return this.response.encodeUrl(string);
    }

    public void sendRedirect(String string) throws IOException {
        this.response.sendRedirect(string);
    }

    public PrintWriter getWriter() throws IOException {
        return this.stream.getPrintWriter();
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public void setContentType(String value) {
        int i = value.indexOf(59);
        if (i > 0) {
            ++i;
            while (i < value.length() && Character.isWhitespace(value.charAt(i))) {
                ++i;
            }
            int j = value.indexOf(61, i);
            if (j > 0 && value.substring(i, j).equals("charset")) {
                String encoding = value.substring(j + 1);
                this.charEncoding = Encoding.getMimeName(encoding);
                try {
                    this.stream.setEncoding(this.charEncoding);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        this.setHeader("Content-Type", value);
    }

    public boolean containsHeader(String name) {
        return this.headers.get(name) != null;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void setStatus(int code) {
        this.response.setStatus(code);
    }

    public void setStatus(int code, String message) {
        this.response.setStatus(code, message);
    }

    public void sendError(int code, String value) throws IOException {
        this.response.sendError(code, value);
    }

    public void sendError(int code) throws IOException {
        this.response.sendError(code);
    }

    public void setDateHeader(String name, long value) {
        this.response.setDateHeader(name, value);
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public void addHeader(String key, String value) {
        this.setHeader(key, value);
    }

    public void addIntHeader(String key, int value) {
        this.setIntHeader(key, value);
    }

    public void addDateHeader(String key, long value) {
        this.setDateHeader(key, value);
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public boolean isCommitted() {
        return true;
    }

    public void reset() {
        this.resetBuffer();
    }

    public void resetBuffer() {
    }

    public void clearBuffer() {
    }

    public void setLocale(Locale locale) {
    }

    public Locale getLocale() {
        return null;
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    public String getChain() {
        return null;
    }

    public String getHeader(String key) {
        return null;
    }

    public StreamImpl startChaining() {
        return null;
    }

    public int getRemaining() {
        return 0;
    }

    public void setSessionId(String id) {
    }

    public void setForbidForward(boolean forbid) {
        this.forbidForward = forbid;
    }

    public boolean getForbidForward() {
        return this.forbidForward;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void killCache() {
    }
}

