/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.QPooledConnection;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class QXAPooledConnection
extends QPooledConnection {
    private XAResource xaConn;

    QXAPooledConnection(DBPool pool, Connection conn) {
        super(pool, conn);
        this.xaConn = (XAResource)((Object)conn);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw new SQLException(L.l("can't set auto-commit when using transactions"));
    }

    public void commit() throws SQLException {
        throw new SQLException(L.l("can't call commit() when using transactions"));
    }

    public void rollback() throws SQLException {
        throw new SQLException(L.l("can't call rollback() when using transactions"));
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        return this.xaConn.isSameRM(resource);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.xaConn.start(xid, flags);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaConn.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaConn.getTransactionTimeout();
    }

    public void forget(Xid xid) throws XAException {
        this.xaConn.forget(xid);
    }

    public int prepare(Xid xid) throws XAException {
        return this.xaConn.prepare(xid);
    }

    public void rollback(Xid xid) throws XAException {
        this.xaConn.rollback(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaConn.commit(xid, onePhase);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaConn.recover(flag);
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            this.close();
        }
        catch (SQLException e) {
            throw new XAException(e.getLocalizedMessage());
        }
        this.xaConn.end(xid, flags);
    }

    public String toString() {
        return "[XAPool " + this.xaConn + "]";
    }
}

