/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import java.util.ArrayList;
import java.util.Iterator;

public class LongKeyLruCache {
    private CacheItem[] entries;
    private int capacity;
    private int size;
    private int mask;
    private CacheItem head;
    private CacheItem tail;

    public LongKeyLruCache(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this.entries = new CacheItem[capacity];
        this.mask = capacity - 1;
        this.capacity = initialCapacity;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        ArrayList<Object> listeners = null;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            for (int i2 = 0; i2 < this.entries.length; ++i2) {
                CacheItem item = this.entries[i2];
                if (item != null && item.value instanceof CacheListener) {
                    if (listeners == null) {
                        listeners = new ArrayList<Object>();
                    }
                    listeners.add(item.value);
                }
                this.entries[i2] = null;
            }
            this.size = 0;
            this.head = null;
            this.tail = null;
        }
        int n = i = listeners == null ? -1 : listeners.size() - 1;
        while (i >= 0) {
            CacheListener listener = (CacheListener)listeners.get(i);
            listener.removeEvent();
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long key) {
        int hash = (int)(key & (long)this.mask);
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            for (int count = this.size + 1; count > 0; --count) {
                CacheItem item = this.entries[hash];
                if (item == null) {
                    return null;
                }
                if (item.key == key) {
                    this.updateLru(item);
                    return item.value;
                }
                hash = hash + 1 & this.mask;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(long key, Object value) {
        while (this.size >= this.capacity) {
            this.remove(this.tail.key);
        }
        Object oldValue = null;
        int hash = (int)(key & (long)this.mask);
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            for (int count = this.size + 1; count > 0; --count) {
                CacheItem item = this.entries[hash];
                if (item == null) {
                    this.entries[hash] = item = new CacheItem(key, value);
                    ++this.size;
                    item.next = this.head;
                    if (this.head != null) {
                        this.head.prev = item;
                    } else {
                        this.tail = item;
                    }
                    this.head = item;
                    return null;
                }
                if (item.key == key) {
                    this.updateLru(item);
                    oldValue = item.value;
                    item.value = value;
                    break;
                }
                hash = hash + 1 & this.mask;
            }
        }
        if (oldValue instanceof CacheListener && oldValue != value) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    private void updateLru(CacheItem item) {
        CacheItem prev = item.prev;
        CacheItem next = item.next;
        if (prev != null) {
            prev.next = next;
            item.prev = null;
            item.next = this.head;
            this.head.prev = item;
            this.head = item;
            if (next != null) {
                next.prev = prev;
            } else {
                this.tail = prev;
            }
        }
    }

    public boolean removeTail() {
        CacheItem last = this.tail;
        if (last == null) {
            return false;
        }
        this.remove(last.key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long key) {
        int count;
        int hash = (int)(key & (long)this.mask);
        Object value = null;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            for (count = this.size + 1; count > 0; --count) {
                CacheItem item = this.entries[hash];
                if (item == null) {
                    return null;
                }
                if (item.key == key) {
                    int nextHash;
                    CacheItem nextItem;
                    this.entries[hash] = null;
                    --this.size;
                    CacheItem prev = item.prev;
                    CacheItem next = item.next;
                    if (prev != null) {
                        prev.next = next;
                    } else {
                        this.head = next;
                    }
                    if (next != null) {
                        next.prev = prev;
                    } else {
                        this.tail = prev;
                    }
                    for (int i = 1; i <= count && (nextItem = this.entries[nextHash = hash + i & this.mask]) != null; ++i) {
                        this.entries[nextHash] = null;
                        this.refillEntry(nextItem);
                    }
                    value = item.value;
                    break;
                }
                hash = hash + 1 & this.mask;
            }
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        if (value instanceof CacheListener) {
            ((CacheListener)value).removeEvent();
        }
        return value;
    }

    private void refillEntry(CacheItem item) {
        int baseHash = (int)item.key;
        for (int count = 0; count < this.size + 1; ++count) {
            int hash = baseHash + count & this.mask;
            if (this.entries[hash] != null) continue;
            this.entries[hash] = item;
            return;
        }
    }

    public Iterator keys() {
        KeyIterator iter = new KeyIterator();
        iter.init(this);
        return iter;
    }

    public Iterator keys(Iterator oldIter) {
        KeyIterator iter = (KeyIterator)oldIter;
        iter.init(this);
        return iter;
    }

    public Iterator values() {
        ValueIterator iter = new ValueIterator();
        iter.init(this);
        return iter;
    }

    public Iterator values(Iterator oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return iter;
    }

    static class ValueIterator
    implements Iterator {
        CacheItem item;

        ValueIterator() {
        }

        void init(LongKeyLruCache cache) {
            this.item = cache.head;
        }

        public boolean hasNext() {
            return this.item != null;
        }

        public Object next() {
            Object value = this.item.value;
            this.item = this.item.next;
            return value;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class KeyIterator
    implements Iterator {
        CacheItem item;

        KeyIterator() {
        }

        void init(LongKeyLruCache cache) {
            this.item = cache.head;
        }

        public boolean hasNext() {
            return this.item != null;
        }

        public Object next() {
            long value = this.item.key;
            this.item = this.item.next;
            return new Long(value);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class CacheItem {
        CacheItem prev;
        CacheItem next;
        long key;
        Object value;
        int index;

        CacheItem(long key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

