/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CauchoSystem;
import java.util.Enumeration;
import java.util.Hashtable;

public class QThreadLocal
implements AlarmListener {
    private static final long TIMEOUT_INTERVAL = 15000L;
    private ThreadLocal local;
    private Hashtable localMap;

    public QThreadLocal() {
        if (CauchoSystem.isJdk12()) {
            this.createLocal();
        } else {
            this.localMap = new Hashtable();
            new Alarm(this, 15000L);
        }
    }

    private void createLocal() {
        this.local = new ThreadLocal();
    }

    public Object get() {
        if (CauchoSystem.isJdk12()) {
            return this.getLocal();
        }
        return this.localMap.get(Thread.currentThread());
    }

    private Object getLocal() {
        return this.local.get();
    }

    public void set(Object obj) {
        if (CauchoSystem.isJdk12()) {
            this.setLocal(obj);
        } else if (obj != null) {
            this.localMap.put(Thread.currentThread(), obj);
        } else {
            this.localMap.remove(Thread.currentThread());
        }
    }

    private void setLocal(Object obj) {
        this.local.set(obj);
    }

    public void handleAlarm(Alarm alarm) {
        Enumeration e = this.localMap.keys();
        while (e.hasMoreElements()) {
            Thread t = (Thread)e.nextElement();
            if (t.isAlive()) continue;
            this.localMap.remove(t);
        }
        alarm.queue(15000L);
    }
}

