/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.ChangeListener;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.LooseXml;
import com.caucho.xml.XmlParser;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class Registry {
    static L10N L = new L10N(class$com$caucho$util$Registry == null ? (class$com$caucho$util$Registry = Registry.class$("com.caucho.util.Registry")) : class$com$caucho$util$Registry);
    private static Registry defaultRegistry;
    private static int changeCount;
    private static ArrayList listeners;
    private RegistryNode top;
    private ArrayList dependList = new ArrayList();
    private long lastModifiedCheck;
    private boolean isModified;
    static /* synthetic */ Class class$com$caucho$util$Registry;

    public RegistryNode createNode(String name, String value) {
        return new RegistryNode(this, name, value, null, 0);
    }

    public boolean isModified() {
        long now = Alarm.getCurrentTime();
        if (this.isModified) {
            return true;
        }
        if (now < this.lastModifiedCheck + 1000L) {
            return false;
        }
        this.lastModifiedCheck = now;
        for (int i = this.dependList.size() - 1; i >= 0; --i) {
            Depend depend = (Depend)this.dependList.get(i);
            if (!depend.isModified()) continue;
            this.isModified = true;
            return true;
        }
        return false;
    }

    public ArrayList getDependList() {
        return this.dependList;
    }

    public RegistryNode getTop() {
        return this.top;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry parse(Path path) throws IOException, SAXException {
        ReadStream is = null;
        try {
            is = path.openRead();
            Registry registry = Registry.parse(is);
            return registry;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static Registry parse(ReadStream is) throws IOException, SAXException {
        RegistryNode top;
        LooseXml parser = new LooseXml();
        Registry root = new Registry();
        root.top = top = new RegistryNode(root, null, null, is.getPath().getUserPath(), 1);
        Registry.parse(is, top);
        return root;
    }

    static RegistryNode parse(ReadStream is, RegistryNode top) throws IOException, SAXException {
        LooseXml parser = new LooseXml();
        Path path = is.getPath();
        if (path != null) {
            top.getRoot().dependList.add(new Depend(path));
        }
        SaxHandler handler = new SaxHandler(path, top);
        parser.setDocumentHandler(handler);
        parser.parse(is);
        return top;
    }

    public static synchronized Registry setDefault(Registry registry) {
        return Registry.setRegistry(registry);
    }

    public static synchronized Registry setRegistry(Registry registry) {
        Registry old = defaultRegistry;
        defaultRegistry = registry;
        if (old != null) {
            old.isModified = true;
        }
        if (registry != null) {
            registry.isModified = false;
        }
        Registry.handleChange();
        return old;
    }

    public static synchronized Registry getRegistry() {
        return defaultRegistry;
    }

    public static RegistryNode lookup(String path) {
        Registry registry = Registry.getRegistry();
        if (registry == null) {
            return null;
        }
        RegistryNode node = registry.top;
        return node == null ? null : node.lookup(path);
    }

    public static boolean getBoolean(String path, boolean deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getBoolean();
    }

    public static int getInt(String path, int deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getInt();
    }

    public static double getDouble(String path, double deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getDouble();
    }

    public static String getString(String path, String deflt) {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getString();
    }

    public static String getPath(String path, String deflt) {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getPath();
    }

    public static QDate getDate(String path, QDate deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getDate();
    }

    public static long getPeriod(String path, long deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getPeriod();
    }

    public static synchronized void addListener(ChangeListener listener) {
        if (listeners == null) {
            listeners = new ArrayList();
        }
        listeners.add(listener);
    }

    public static int getChangeCount() {
        return changeCount;
    }

    public static synchronized void removeListener(ChangeListener listener) {
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    static void handleChange() {
        ++changeCount;
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            ChangeListener listener = (ChangeListener)listeners.get(i);
            listener.handleChange(null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class SaxHandler
    extends HandlerBase {
        Path path;
        private Locator locator;
        ArrayList elements = new ArrayList();
        RegistryNode node;
        private boolean hasText;
        private boolean hasTag;
        private boolean preserveSpace;

        SaxHandler(Path path, RegistryNode top) {
            this.path = path;
            this.node = top;
        }

        Registry getRoot() {
            return this.node.getRoot();
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String name, AttributeList attrs) throws SAXException {
            if (this.hasText) {
                throw this.error(L.l("Element <{0}> is forbidden because parent tag <{1}> already contains text.  Tags must either contain other tags or text, not both.", (Object)name, this.node.getName()));
            }
            if (name.equals("resin:include")) {
                this.doInclude(attrs);
                return;
            }
            if (name.equals("resin:include-directory")) {
                this.doIncludeDirectory(attrs);
                return;
            }
            RegistryNode child = this.locator instanceof XmlParser ? this.node.add(name, null, ((XmlParser)((Object)this.locator)).getFilename(), this.locator.getLineNumber()) : this.node.add(name, null, this.locator.getSystemId(), this.locator.getLineNumber());
            this.node = child;
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                String key = attrs.getName(i);
                String value = attrs.getValue(i);
                if (key.equals("id")) {
                    child.id = value;
                    child.value = value;
                    continue;
                }
                if (key.equals("xml:space")) {
                    if (!value.equals("preserve")) continue;
                    this.preserveSpace = true;
                    continue;
                }
                if (key.equals("xmlns") || key.startsWith("xmlns:")) continue;
                child.add(key, value, this.locator.getSystemId(), this.locator.getLineNumber());
            }
            this.hasText = false;
            this.hasTag = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doInclude(AttributeList args) throws SAXException {
            try {
                String href = args.getValue("href");
                if (href == null) {
                    throw new SAXException("resin:include expects `href' attribute");
                }
                Path subpath = this.path.getParent().lookup(href);
                if (!subpath.canRead()) {
                    throw new SAXException(L.l("can't find `{0}' in resin:include", subpath));
                }
                ReadStream is = null;
                try {
                    is = subpath.openRead();
                    Registry.parse(is, this.node);
                    this.node = this.node.getFirstChild();
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new SAXException(e.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doIncludeDirectory(AttributeList args) throws SAXException {
            try {
                String href = args.getValue("href");
                if (href == null || href.equals("")) {
                    throw this.error(L.l("resin:include-directory expects `href' attribute"));
                }
                String ext = args.getValue("extension");
                if (ext == null || ext.equals("")) {
                    throw this.error(L.l("resin:include-directory expects `extension' attribute"));
                }
                Path subpath = this.path.getParent().lookup(href);
                if (!subpath.isDirectory()) {
                    throw this.error(L.l("can't find `{0}' in resin:include-directory", subpath));
                }
                String[] list = subpath.list();
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].endsWith(ext)) continue;
                    ReadStream is = null;
                    try {
                        is = subpath.lookup(list[i]).openRead();
                        Registry.parse(is, this.node);
                        continue;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw this.error(e.toString());
            }
            if (this.node.getFirstChild() != null) {
                this.node = this.node.getFirstChild();
            }
        }

        public void endElement(String name) {
            if (this.node != null) {
                this.node = this.node.parent;
            }
            this.hasText = false;
            this.preserveSpace = false;
            this.hasTag = true;
        }

        private boolean isWhitespace(char ch) {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public void characters(char[] chars, int offset, int length) throws SAXException {
            char ch = ' ';
            if (!this.preserveSpace) {
                while (length > 0 && ((ch = chars[offset]) == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) {
                    ++offset;
                    --length;
                }
                ch = ' ';
                while (length > 0 && ((ch = chars[offset + length - 1]) == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) {
                    --length;
                }
            } else if (length > 0) {
                ch = chars[offset];
            }
            if (length <= 0) {
                return;
            }
            if (this.hasTag) {
                throw this.error(L.l("Text `{0}' is forbidden because parent tag <{1}> already contains a tag.  Tags must either contain other tags or text, not both.", (Object)new String(chars, offset, length), this.node.getName()));
            }
            if (this.node.id != null) {
                throw this.error("can't use both id=value and text at `" + ch + "'");
            }
            this.node.value = this.node.value == null ? new String(chars, offset, length) : this.node.value + new String(chars, offset, length);
            if (!this.preserveSpace) {
                this.node.value = this.node.value.trim();
            }
            this.hasText = true;
        }

        SAXException error(String text) {
            return new SAXException(this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ": " + text);
        }
    }
}

