/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharCursor;

public class StringCharCursor
extends CharCursor {
    String string;
    int pos;

    public StringCharCursor(String string) {
        this.string = string;
        this.pos = 0;
    }

    public StringCharCursor(String string, int offset) {
        this.string = string;
        this.pos = offset;
    }

    public int getIndex() {
        return this.pos;
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.string.length();
    }

    public char setIndex(int pos) {
        if (pos < 0) {
            this.pos = 0;
            return '\uffff';
        }
        if (pos >= this.string.length()) {
            this.pos = this.string.length();
            return '\uffff';
        }
        this.pos = pos;
        return this.string.charAt(pos);
    }

    public char next() {
        if (++this.pos >= this.string.length()) {
            this.pos = this.string.length();
            return '\uffff';
        }
        return this.string.charAt(this.pos);
    }

    public char previous() {
        if (--this.pos < 0) {
            this.pos = 0;
            return '\uffff';
        }
        return this.string.charAt(this.pos);
    }

    public char current() {
        if (this.pos >= this.string.length()) {
            return '\uffff';
        }
        return this.string.charAt(this.pos);
    }

    public char skip(int n) {
        this.pos += n;
        if (this.pos >= this.string.length()) {
            this.pos = this.string.length();
            return '\uffff';
        }
        return this.string.charAt(this.pos);
    }

    public void init(String string) {
        this.string = string;
        this.pos = 0;
    }

    public Object clone() {
        return new StringCharCursor(this.string);
    }
}

