/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.ClassLoaderLocal;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ClassLoaderStream
extends StreamImpl {
    private static ClassLoaderStream stdoutStream;
    private static ClassLoaderStream stderrStream;
    ClassLoaderLocal classLoaderStream;

    public ClassLoaderStream(String contextVariable, OutputStream defaultStream) {
        this.classLoaderStream = new ClassLoaderLocal(contextVariable);
        this.classLoaderStream.setGlobal(defaultStream);
    }

    public static void setStdout(OutputStream os) {
        if (os != null) {
            if (stdoutStream == null) {
                stdoutStream = new ClassLoaderStream("caucho.stdout.stream", os);
                WriteStream out = new WriteStream(stdoutStream);
                System.setOut(new PrintStream(out, true));
            } else {
                stdoutStream.setDefaultStream(os);
            }
        }
    }

    public static ClassLoaderStream getStdout() {
        return stdoutStream;
    }

    public static void setStderr(OutputStream os) {
        if (os != null) {
            if (stderrStream == null) {
                stderrStream = new ClassLoaderStream("caucho.stderr.stream", os);
                WriteStream err = new WriteStream(stderrStream);
                System.setErr(new PrintStream(err, true));
            } else {
                stderrStream.setDefaultStream(os);
            }
        }
    }

    public static ClassLoaderStream getStderr() {
        return stderrStream;
    }

    public String getVariable() {
        return this.classLoaderStream.getVariable();
    }

    public OutputStream getDefaultStream() {
        return (OutputStream)this.classLoaderStream.getGlobal();
    }

    public void setDefaultStream(OutputStream defaultStream) {
        this.classLoaderStream.setGlobal(defaultStream);
    }

    public boolean canWrite() {
        OutputStream stream = this.getStream();
        return stream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        OutputStream stream = this.getStream();
        if (stream == null) {
            return;
        }
        OutputStream outputStream = stream;
        synchronized (outputStream) {
            stream.write(buf, offset, length);
            if (isEnd) {
                stream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        OutputStream stream = this.getStream();
        if (stream == null) {
            return;
        }
        OutputStream outputStream = stream;
        synchronized (outputStream) {
            stream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        OutputStream stream = this.getStream();
        if (stream == null) {
            return;
        }
        OutputStream outputStream = stream;
        synchronized (outputStream) {
            stream.flush();
        }
    }

    public void setStream(OutputStream os) {
        this.classLoaderStream.set(os);
    }

    public OutputStream getStream() {
        return (OutputStream)this.classLoaderStream.get();
    }
}

