/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;

class HttpStream
extends StreamImpl {
    private static WriteStream dbg = LogStream.open("/caucho.com/vfs.http");
    private static HashMap reserved;
    private static Object LOCK;
    private static HttpStream savedStream;
    private static long saveTime;
    private Socket _s;
    private InputStream is;
    private OutputStream os;
    private ReadStream rs;
    private WriteStream ws;
    private String host;
    private int port;
    private String method;
    private boolean isHead;
    private boolean isPost;
    private MemoryStream tempStream;
    private boolean isKeepalive;
    private boolean didGet;
    private int contentLength;
    private boolean isChunked;
    private int chunkLength;
    private boolean isRequestDone;
    private HashMap attributes;
    private long socketTimeout;
    private byte[] tempBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpStream(Path path, String host, int port, Socket s) throws IOException {
        block3: {
            this.socketTimeout = 120000L;
            this._s = s;
            boolean isOkay = false;
            try {
                this.host = host;
                this.port = port;
                this.is = s.getInputStream();
                this.os = s.getOutputStream();
                this.ws = VfsStream.openWrite(this.os);
                this.rs = VfsStream.openRead(this.is, this.ws);
                this.attributes = new HashMap();
                this.init(path);
                isOkay = true;
                Object var7_6 = null;
                if (isOkay) break block3;
                this._s = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!isOkay) {
                    this._s = null;
                    s.close();
                }
                throw throwable;
            }
            s.close();
            {
            }
        }
    }

    static HttpStream openRead(HttpPath path) throws IOException {
        HttpStream stream = HttpStream.createStream(path);
        stream.isPost = false;
        return stream;
    }

    static HttpStream openReadWrite(HttpPath path) throws IOException {
        HttpStream stream = HttpStream.createStream(path);
        stream.isPost = true;
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpStream createStream(HttpPath path) throws IOException {
        Socket s;
        String host = path.getHost();
        int port = path.getPort();
        HttpStream stream = null;
        long streamTime = 0L;
        Object object = LOCK;
        synchronized (object) {
            if (savedStream != null && host.equals(savedStream.getHost()) && port == savedStream.getPort()) {
                stream = savedStream;
                streamTime = saveTime;
                savedStream = null;
            }
        }
        if (stream != null) {
            if (Alarm.getCurrentTime() < streamTime + 5000L) {
                stream.init(path);
                return stream;
            }
            try {
                stream.isKeepalive = false;
                stream.close();
            }
            catch (IOException e) {
                dbg.log(e);
            }
        }
        try {
            s = new Socket(host, port);
        }
        catch (ConnectException e) {
            throw new ConnectException(path.getURL() + ": " + e.getMessage());
        }
        long socketTimeout = 0L;
        Object timeoutObj = path.getAttribute("socket-timeout");
        if (timeoutObj instanceof Integer) {
            socketTimeout = (long)((Integer)timeoutObj).intValue() * 1000L;
        }
        HttpStream httpStream = new HttpStream(path, host, port, s);
        if (socketTimeout > 0L) {
            httpStream.setSocketTimeout(socketTimeout);
        }
        return httpStream;
    }

    private void init(Path path) {
        this.contentLength = -1;
        this.isChunked = false;
        this.isRequestDone = false;
        this.isKeepalive = true;
        this.didGet = false;
        this.isPost = false;
        this.isHead = false;
        this.method = null;
        this.attributes.clear();
        if (this.socketTimeout >= 1000L) {
            try {
                this._s.setSoTimeout((int)this.socketTimeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setPath(path);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHead(boolean isHead) {
        this.isHead = isHead;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setSocketTimeout(long timeout) {
        this.socketTimeout = timeout;
    }

    public Object getAttribute(String name) throws IOException {
        if (!this.didGet) {
            this.getConnInput();
        }
        return this.attributes.get(name.toLowerCase());
    }

    public Iterator getAttributeNames() throws IOException {
        if (!this.didGet) {
            this.getConnInput();
        }
        return this.attributes.keySet().iterator();
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name.toLowerCase(), value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name.toLowerCase());
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (!this.isPost) {
            return;
        }
        if (this.tempStream == null) {
            this.tempStream = new MemoryStream();
        }
        this.tempStream.write(buf, offset, length, isEnd);
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        try {
            return this.readInt(buf, offset, length);
        }
        catch (IOException e) {
            this.isKeepalive = false;
            throw e;
        }
    }

    public int readInt(byte[] buf, int offset, int length) throws IOException {
        if (!this.didGet) {
            this.getConnInput();
        }
        if (this.isRequestDone) {
            return -1;
        }
        int len = length;
        if (this.isChunked) {
            if (this.chunkLength == 0) {
                int ch = this.rs.read();
                while (ch >= 0 && (ch == 13 || ch == 10 || ch == 32)) {
                    ch = this.rs.read();
                }
                while (ch >= 0 && ch != 10) {
                    if (ch >= 48 && ch <= 57) {
                        this.chunkLength = 16 * this.chunkLength + ch - 48;
                    } else if (ch >= 97 && ch <= 102) {
                        this.chunkLength = 16 * this.chunkLength + ch - 97 + 10;
                    } else if (ch >= 65 && ch <= 70) {
                        this.chunkLength = 16 * this.chunkLength + ch - 65 + 10;
                    }
                    ch = this.rs.read();
                }
                if (this.chunkLength == 0) {
                    this.isRequestDone = true;
                    return -1;
                }
            } else if (this.chunkLength < 0) {
                return -1;
            }
            if (this.chunkLength < len) {
                len = this.chunkLength;
            }
        } else if (this.contentLength >= 0) {
            if (this.isHead || this.contentLength == 0) {
                this.isRequestDone = true;
                return -1;
            }
            if (this.contentLength < len) {
                len = this.contentLength;
            }
        }
        if ((len = this.rs.read(buf, offset, len)) >= 0) {
            if (this.isChunked) {
                this.chunkLength -= len;
            } else if (this.contentLength > 0) {
                this.contentLength -= len;
            }
        }
        return len;
    }

    private void getConnInput() throws IOException {
        if (this.didGet) {
            return;
        }
        try {
            this.getConnInputImpl();
        }
        catch (IOException e) {
            this.isKeepalive = false;
            throw e;
        }
    }

    private void getConnInputImpl() throws IOException {
        if (this.didGet) {
            return;
        }
        this.didGet = true;
        if (this.method != null) {
            this.ws.print(this.method);
            this.ws.print(' ');
        } else if (this.isPost) {
            this.ws.print("POST ");
        } else if (this.isHead) {
            this.ws.print("HEAD ");
        } else {
            this.ws.print("GET ");
        }
        this.ws.print(this.path.getPath());
        if (this.path.getQuery() != null) {
            this.ws.print("?");
            this.ws.print(this.path.getQuery());
        }
        this.ws.print(" HTTP/1.1\r\n");
        this.ws.print("Host: ");
        this.ws.print(this.path.getHost());
        if (this.path.getPort() != 80) {
            this.ws.print(":");
            this.ws.print(String.valueOf(this.path.getPort()));
        }
        this.ws.print("\r\n");
        Object userAgent = this.getAttribute("User-Agent");
        if (userAgent == null) {
            this.ws.print("User-Agent: Mozilla/4.0 (compatible; Resin 1.0; JDK)\r\n");
        } else {
            this.ws.print("User-Agent: " + userAgent + "\r\n");
        }
        Iterator iter = this.getAttributeNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (reserved.get(name.toLowerCase()) != null) continue;
            this.ws.print(name + ": " + this.getAttribute(name) + "\r\n");
        }
        if (!this.isKeepalive) {
            this.ws.print("Connection: close\r\n");
        }
        if (this.isPost) {
            int length = 0;
            if (this.tempStream != null) {
                length += this.tempStream.getLength();
            }
            this.ws.print("Content-Length: ");
            this.ws.print(length);
            this.ws.print("\r\n");
        }
        this.ws.print("\r\n");
        if (this.isPost && this.tempStream != null) {
            this.tempStream.writeToStream(this.ws);
            this.tempStream.destroy();
            this.tempStream = null;
        }
        this.parseHeaders();
        if (this.isHead) {
            this.isRequestDone = true;
        }
    }

    private void parseHeaders() throws IOException {
        char ch;
        CharBuffer line = new CharBuffer();
        int count = 0;
        do {
            if (this.rs.readln(line)) continue;
            this.isKeepalive = false;
            return;
        } while (line.length() == 0 && ++count < 10);
        if (line.length() == 0) {
            this.isKeepalive = false;
            return;
        }
        int i = 0;
        for (i = 0; i < line.length() && line.charAt(i) != ' '; ++i) {
        }
        while (i < line.length() && line.charAt(i) == ' ') {
            ++i;
        }
        int status = 0;
        while (i < line.length() && (ch = line.charAt(i)) >= '0' && ch <= '9') {
            status = 10 * status + ch - 48;
            ++i;
        }
        if (status != 200) {
            this.isKeepalive = false;
        } else if (!line.startsWith("HTTP/1.1 ")) {
            this.isKeepalive = false;
        }
        this.attributes.put("status", String.valueOf(status));
        CharBuffer key = new CharBuffer();
        while (true) {
            line.clear();
            if (!this.rs.readln(line) || line.length() == 0) break;
            for (i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
            }
            key.clear();
            while (i < line.length() && !Character.isWhitespace(line.charAt(i)) && line.charAt(i) != ':') {
                key.append(line.charAt(i));
                ++i;
            }
            while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            if (key.length() == 0 || i >= line.length() || line.charAt(i) != ':') continue;
            ++i;
            while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            key.toLowerCase();
            String value = line.substring(i);
            if (dbg.canWrite()) {
                dbg.log(key + ": " + value);
            }
            if (key.matches("content-length")) {
                this.contentLength = new Integer(value);
            } else if (key.matches("connection") && value.equalsIgnoreCase("close")) {
                this.isKeepalive = false;
            } else if (key.matches("transfer-encoding") && value.equalsIgnoreCase("chunked")) {
                this.isChunked = true;
                this.chunkLength = 0;
            }
            this.attributes.put(key.toLowerCase().toString(), value);
        }
    }

    public int getAvailable() throws IOException {
        if (!this.didGet) {
            this.getConnInput();
        }
        if (this.contentLength > 0) {
            return this.contentLength;
        }
        return this.rs.getAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        boolean isReuse = false;
        try {
            if (this.isKeepalive) {
                try {
                    if (!this.didGet) {
                        this.getConnInput();
                    }
                    if (!this.isRequestDone) {
                        if (this.tempBuffer == null) {
                            this.tempBuffer = new byte[256];
                        }
                        while (this.read(this.tempBuffer, 0, this.tempBuffer.length) > 0) {
                        }
                    }
                }
                catch (IOException e) {
                    this.isKeepalive = false;
                }
            }
            if (this.isKeepalive) {
                long now = Alarm.getCurrentTime();
                Object object = LOCK;
                // MONITORENTER : object
                HttpStream oldSaved = savedStream;
                savedStream = this;
                saveTime = now;
                isReuse = true;
                // MONITOREXIT : object
                if (oldSaved != null && oldSaved != this) {
                    oldSaved.isKeepalive = false;
                    oldSaved.close();
                }
                Object var8_6 = null;
                if (isReuse) return;
                Socket s = this._s;
                this._s = null;
                if (s == null) return;
                s.close();
                return;
            }
            if (this.ws != null) {
                this.ws.close();
            }
            this.ws = null;
            if (this.rs != null) {
                this.rs.close();
            }
            this.rs = null;
            if (this.os != null) {
                this.os.close();
            }
            this.os = null;
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            Object var8_7 = null;
            if (isReuse) return;
            Socket s = this._s;
            this._s = null;
            if (s == null) return;
            s.close();
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (isReuse) throw throwable;
            Socket s = this._s;
            this._s = null;
            if (s == null) throw throwable;
            s.close();
            throw throwable;
        }
    }

    static {
        LOCK = new Object();
        reserved = new HashMap();
        reserved.put("user-agent", "");
        reserved.put("content-length", "");
        reserved.put("content-encoding", "");
        reserved.put("connection", "");
        reserved.put("host", "");
    }
}

