/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.JniStream;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class QJniSocket
extends QSocket {
    int _fd = 0;
    JniStream _stream;
    InetAddress _localAddr;
    InetAddress _remoteAddr;

    void setFd(int fd) {
        this._fd = fd;
        this._localAddr = null;
        this._remoteAddr = null;
    }

    public InetAddress getLocalAddress() {
        if (this._localAddr == null) {
            try {
                this._localAddr = InetAddress.getByName(this.ipToName(this.getLocalIP(this._fd)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._localAddr;
    }

    public long getLocalIP() {
        return this.getLocalIP(this._fd);
    }

    native long getLocalIP(int var1);

    public int getLocalPort() {
        return this.getLocalPort(this._fd);
    }

    native int getLocalPort(int var1);

    public void setSoTimeout(int timeout) {
        this.setTimeout(this._fd, timeout);
    }

    native int setTimeout(int var1, int var2);

    public InetAddress getRemoteAddress() {
        if (this._remoteAddr == null) {
            try {
                this._remoteAddr = InetAddress.getByName(this.ipToName(this.getRemoteIP(this._fd)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._remoteAddr;
    }

    private String ipToName(long ip) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 24; i >= 0; i -= 8) {
            int value = (int)(ip >> i) & 0xFF;
            if (value < 10) {
                cb.append((char)(value + 48));
            } else if (value < 100) {
                cb.append((char)(value / 10 + 48));
                cb.append((char)(value % 10 + 48));
            } else {
                cb.append((char)(value / 100 + 48));
                cb.append((char)(value / 10 % 10 + 48));
                cb.append((char)(value % 10 + 48));
            }
            if (i == 0) continue;
            cb.append('.');
        }
        return cb.close();
    }

    public long getRemoteIP() {
        return this.getRemoteIP(this._fd);
    }

    native long getRemoteIP(int var1);

    public int getRemotePort() {
        return this.getRemotePort(this._fd);
    }

    native int getRemotePort(int var1);

    public boolean isSecure() {
        return this.isSecure(this._fd);
    }

    native boolean isSecure(int var1);

    public String getCipherSuite() {
        return this.getCipher(this._fd);
    }

    native String getCipher(int var1);

    public int getCipherBits() {
        return this.getCipherBits(this._fd);
    }

    native int getCipherBits(int var1);

    public X509Certificate getClientCertificate() throws CertificateException {
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        int len = this.getClientCertificate(this._fd, buffer, 0, buffer.length);
        X509Certificate cert = null;
        if (len > 0 && len < buffer.length) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream is = new ByteArrayInputStream(buffer, 0, len);
                cert = (X509Certificate)cf.generateCertificate(is);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                return null;
            }
        }
        TempBuffer.free(tb);
        return cert;
    }

    native int getClientCertificate(int var1, byte[] var2, int var3, int var4);

    public StreamImpl getStream() throws IOException {
        if (this._stream == null) {
            this._stream = new JniStream();
        }
        this._stream.init(this._fd);
        return this._stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this._stream != null) {
                this._stream.close();
            }
            Object var2_1 = null;
            int fd = this._fd;
            this._fd = 0;
            if (fd != 0) {
                this.closeNative(fd);
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            int fd = this._fd;
            this._fd = 0;
            if (fd != 0) {
                this.closeNative(fd);
            }
            throw throwable;
        }
    }

    native void closeNative(int var1);
}

