/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.Cron;
import com.caucho.util.CronListener;
import com.caucho.util.QDate;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TimestampFilter;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.WeakHashMap;

public class RotateStream
implements CronListener {
    private static final long DAY = 86400000L;
    private static final long ROLLOVER_SIZE = 1000000L;
    private static WeakHashMap streams = new WeakHashMap();
    private Path path;
    private StreamImpl streamImpl;
    private WriteStream stream;
    private String timestamp;
    private TimestampFilter timestampFilter;
    private WriteStream timestampStream;
    private long maxLength;
    private int maxCount;
    private QDate calendar = new QDate();
    private long nextTime = -1L;
    private long rolloverPeriod = -1L;
    private long rolloverSize = 1000000L;
    private long updateInterval = 60000L;

    private RotateStream(Path path) {
        this.path = path;
        this.rolloverSize = 1000000L;
        this.maxCount = 2;
        this.stream = new WriteStream();
        Cron cron = new Cron(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotateStream create(Path path) {
        WeakHashMap weakHashMap = streams;
        synchronized (weakHashMap) {
            RotateStream stream = (RotateStream)streams.get(path);
            if (stream == null) {
                stream = new RotateStream(path);
                streams.put(path, stream);
            }
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        WeakHashMap weakHashMap = streams;
        synchronized (weakHashMap) {
            streams.clear();
        }
    }

    public void setMaxRolloverCount(int count) {
        if (count < 0) {
            count = 1;
        }
        this.maxCount = count;
    }

    public void setRolloverPeriod(long period) {
        if (period > 0L) {
            this.rolloverPeriod = period;
            this.rolloverPeriod += 3599999L;
            this.rolloverPeriod -= this.rolloverPeriod % 3600000L;
        } else {
            this.rolloverPeriod = -1L;
        }
    }

    public void setRolloverSize(long size) {
        this.rolloverSize = size <= 0L ? 0x3FFFFFFFL : size;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        if (this.timestampFilter == null) {
            try {
                this.stream.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.timestampFilter = new TimestampFilter();
            this.timestampFilter.setTimestamp(timestamp);
            this.timestampStream = new WriteStream();
            this.timestampFilter.setStream(this.timestampStream);
            StreamImpl source = this.stream.getSource();
            this.stream.init(this.timestampFilter);
            this.stream.setDisableClose(true);
            if (source != null) {
                this.timestampStream.init(source);
            } else {
                this.init();
            }
        } else {
            this.timestampFilter.setTimestamp(timestamp);
        }
    }

    public boolean canWrite() {
        return this.path != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteStream getStream() {
        WriteStream writeStream = this.stream;
        synchronized (writeStream) {
            this.rotateLog();
        }
        if (this.stream.getSource() == null) {
            this.init();
        }
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCron(Cron cron) {
        block7: {
            try {
                WriteStream stream = this.stream;
                if (stream == null) break block7;
                WriteStream writeStream = stream;
                synchronized (writeStream) {
                    if (stream.getSource() != null) {
                        this.rotateLog();
                    }
                }
            }
            finally {
                cron.queue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateLog() {
        long now = Alarm.getCurrentTime();
        if (now < this.nextTime) {
            return;
        }
        this.close();
        try {
            String savedName = null;
            this.calendar.setTime(now);
            long zoneOffset = this.calendar.getZoneOffset();
            if (this.nextTime < 0L && this.rolloverPeriod > 0L) {
                long modifiedTime = this.path.getLastModified();
                if (modifiedTime < 0L) {
                    this.nextTime = RegistryNode.periodEnd(now + zoneOffset, this.rolloverPeriod) - zoneOffset;
                    return;
                }
                this.nextTime = RegistryNode.periodEnd(modifiedTime + zoneOffset, this.rolloverPeriod) - zoneOffset;
                if (now < this.nextTime) {
                    return;
                }
            }
            if (this.rolloverPeriod > 0L) {
                String date = this.rolloverPeriod % 86400000L == 0L ? QDate.formatLocal(this.nextTime - 1L, "%Y%m%d") : QDate.formatLocal(this.nextTime - 1L, "%Y%m%d.%H");
                savedName = this.path.getTail() + "." + date;
                this.nextTime = RegistryNode.periodEnd(now + zoneOffset, this.rolloverPeriod) - zoneOffset;
            } else {
                if (this.path.getLength() < this.rolloverSize) {
                    this.nextTime = now + this.updateInterval;
                    return;
                }
                this.nextTime = now + this.updateInterval;
            }
            Path parent = this.path.getParent();
            Path back = parent.lookup(this.path.getTail() + ".bak");
            try {
                back.remove();
                this.path.renameTo(back);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.rolloverPeriod > 0L) {
                try {
                    back.renameTo(parent.lookup(savedName));
                }
                catch (IOException e) {}
            } else {
                for (int i = this.maxCount - 1; i >= 1; --i) {
                    try {
                        Path oldPath = parent.lookup(this.path.getTail() + "." + i);
                        Path newPath = parent.lookup(this.path.getTail() + "." + (i + 1));
                        oldPath.renameTo(newPath);
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                try {
                    back.renameTo(parent.lookup(this.path.getTail() + "." + 1));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        finally {
            this.init();
        }
    }

    private void init() {
        try {
            this.path.getParent().mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.streamImpl = this.path.openAppendImpl();
            if (this.timestampStream != null) {
                this.timestampStream.init(this.streamImpl);
                this.timestampStream.setDisableClose(true);
            } else {
                this.stream.init(this.streamImpl);
                this.stream.setDisableClose(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

