/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QDocument;
import com.caucho.xml.QEmptyNodeList;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.io.Serializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class QAbstractNode
implements CauchoNode,
Serializable {
    protected static L10N L = new L10N("/com/caucho/xml/messages");
    QDocument owner;
    QNode parent;
    QAbstractNode next;
    QAbstractNode previous;
    String filename;
    int line;

    public void setLocation(String filename, int line, int column) {
        this.filename = filename;
        this.line = line;
    }

    public String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        if (this.previous != null) {
            return this.previous.getFilename();
        }
        if (this.parent != null) {
            return this.parent.getFilename();
        }
        return null;
    }

    public String getBaseURI() {
        return this.owner.getSystemId();
    }

    public int getLine() {
        if (this.filename != null) {
            return this.line;
        }
        if (this.previous != null) {
            return this.previous.getLine();
        }
        if (this.parent != null) {
            return this.parent.getLine();
        }
        return 0;
    }

    public int getColumn() {
        return 0;
    }

    public Document getOwnerDocument() {
        return this.owner;
    }

    public boolean isSupported(String feature, String version) {
        return this.owner.getImplementation().hasFeature(feature, version);
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getPrefix() {
        return "";
    }

    public void setPrefix(String prefix) {
    }

    public String getCanonicalName() {
        return this.getNodeName();
    }

    public String getLocalName() {
        return this.getNodeName();
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String value) {
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return new QEmptyNodeList();
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node getPreviousSibling() {
        return this.previous;
    }

    public Node getNextSibling() {
        return this.next;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new QDOMException(3, "");
    }

    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        throw new QDOMException(3, "");
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw new QDOMException(3, "");
    }

    public Node appendChild(Node newNode) throws DOMException {
        throw new QDOMException(3, "");
    }

    public boolean hasChildNodes() {
        return false;
    }

    public boolean equals(Node arg, boolean deep) {
        return this == arg;
    }

    void remove() {
        if (this.owner != null) {
            ++this.owner.changeCount;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        } else if (this.parent != null) {
            this.parent.firstChild = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        } else if (this.parent != null) {
            this.parent.lastChild = this.previous;
        }
        this.previous = null;
        this.next = null;
        this.parent = null;
    }

    public QAbstractNode getNextPreorder() {
        if (this.next != null) {
            return this.next;
        }
        QNode ptr = this.parent;
        while (ptr != null) {
            if (ptr.next != null) {
                return ptr.next;
            }
            ptr = ptr.parent;
        }
        return null;
    }

    public boolean hasContent() {
        return false;
    }

    public QAbstractNode getNextContent() {
        QAbstractNode node = this.next;
        while (node != null) {
            if (node.hasContent()) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    public QAbstractNode getPreviousContent() {
        QAbstractNode node = this.previous;
        while (node != null) {
            if (node.hasContent()) {
                return node;
            }
            node = node.previous;
        }
        return null;
    }

    public String getTextValue() {
        return this.getNodeValue();
    }

    public boolean supports(String feature, String version) {
        return this.owner.implementation.hasFeature(feature, version);
    }

    public void normalize() {
    }

    public Node cloneNode(boolean deep) {
        return this.importNode(this.owner, deep);
    }

    public short compareTreePosition(Node other) {
        throw new UnsupportedOperationException();
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public String lookupNamespacePrefix(String namespaceURI, boolean useDefault) {
        throw new UnsupportedOperationException();
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqualNode(Node arg) {
        return this.equals(arg);
    }

    public Node getInterface(String feature) {
        throw new UnsupportedOperationException();
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException();
    }

    public Object getUserData(String key) {
        throw new UnsupportedOperationException();
    }

    Node importNode(QDocument owner, boolean deep) {
        throw new UnsupportedOperationException();
    }

    boolean isNameValid(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!XmlChar.isNameStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (XmlChar.isNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean checkValid() throws Exception {
        if (this.parent == null) {
            if (this.next != null || this.previous != null) {
                throw new Exception("null bad: " + this);
            }
            return true;
        }
        if (this.parent.owner != this.owner && this.owner != this.parent) {
            throw new Exception("owner bad: " + this);
        }
        QAbstractNode ptr = this.parent.firstChild;
        while (ptr != null && ptr != this) {
            ptr = ptr.next;
        }
        if (ptr == null) {
            throw new Exception("not in parent: " + this);
        }
        ptr = this.parent.lastChild;
        while (ptr != null && ptr != this) {
            ptr = ptr.previous;
        }
        if (ptr == null) {
            throw new Exception("not in parent: " + this);
        }
        if (this.next == null && this.parent.lastChild != this) {
            throw new Exception("bad tail: " + this);
        }
        if (this.next != null && this.next.previous != this) {
            throw new Exception("bad link: " + this);
        }
        if (this.previous == null && this.parent.firstChild != this) {
            throw new Exception("bad head: " + this);
        }
        if (this.previous != null && this.previous.next != this) {
            throw new Exception("bad link: " + this);
        }
        return true;
    }

    void print(XmlPrinter out) throws IOException {
    }

    public void print(WriteStream out) throws IOException {
        XmlPrinter.printXml(out, this);
    }

    public void printPretty(WriteStream out) throws IOException {
        XmlPrinter.printPrettyXml(out, this);
    }

    public void printHtml(WriteStream out) throws IOException {
        XmlPrinter.printHtml(out, this);
    }
}

