/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QDocument;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QAttr
extends QNode
implements Attr {
    QName name;
    private String value;
    private boolean specified = true;

    QAttr(QName name, String value) {
        this.name = name;
        if (name == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    public Element getOwnerElement() {
        return (Element)this.getParentNode();
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeName() {
        return this.name.getName();
    }

    public String getName() {
        return this.name.getName();
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getCanonicalName() {
        return this.name.getCanonicalName();
    }

    public String getNamespaceURI() {
        String uri = this.name.getNamespace();
        if (uri == "") {
            return null;
        }
        return uri;
    }

    public String getNodeValue() {
        return this.value;
    }

    public void setNodeValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public void setSpecified(boolean specified) {
        this.specified = specified;
    }

    Node importNode(QDocument owner, boolean deep) {
        QAttr node = new QAttr(this.name, this.value);
        node.owner = owner;
        return node;
    }

    public void print(XmlPrinter out) throws IOException {
        if (!this.specified) {
            return;
        }
        out.attribute(this.getNamespaceURI(), this.getLocalName(), this.getNodeName(), this.getNodeValue());
    }

    public String toString() {
        if (this.value != null) {
            return "[Attr " + this.name + " " + this.value + "]";
        }
        return "[Attr " + this.name + "]";
    }
}

