/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.xml.QName;
import org.xml.sax.Attributes;

class QAttributes
implements Attributes {
    QName[] names = new QName[32];
    String[] values = new String[32];
    int size;

    QAttributes() {
    }

    void clear() {
        this.size = 0;
    }

    void add(QName name, String value) {
        if (this.size == this.names.length) {
            QName[] newNames = new QName[2 * this.names.length];
            String[] newValues = new String[2 * this.names.length];
            System.arraycopy(this.names, 0, newNames, 0, this.names.length);
            System.arraycopy(this.values, 0, newValues, 0, this.names.length);
            this.names = newNames;
            this.values = newValues;
        }
        this.names[this.size] = name;
        this.values[this.size] = value;
        ++this.size;
    }

    public int getLength() {
        return this.size;
    }

    public QName getName(int i) {
        if (i < this.size) {
            return this.names[i];
        }
        return null;
    }

    public String getQName(int i) {
        if (i < this.size) {
            return this.names[i].getName();
        }
        return null;
    }

    public String getURI(int i) {
        if (i < this.size) {
            return this.names[i].getNamespaceURI();
        }
        return null;
    }

    public String getLocalName(int i) {
        if (i < this.size) {
            return this.names[i].getLocalName();
        }
        return null;
    }

    public String getValue(int i) {
        if (i < this.size) {
            return this.values[i];
        }
        return null;
    }

    public String getValue(String qName) {
        for (int i = 0; i < this.size; ++i) {
            if (!qName.equals(this.names[i].getName())) continue;
            return this.values[i];
        }
        return null;
    }

    public String getValue(String uri, String localName) {
        for (int i = 0; i < this.size; ++i) {
            if (!uri.equals(this.names[i].getNamespaceURI()) || !localName.equals(this.names[i].getLocalName())) continue;
            return this.values[i];
        }
        return null;
    }

    public int getIndex(String qName) {
        for (int i = 0; i < this.size; ++i) {
            if (!qName.equals(this.names[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String uri, String localName) {
        for (int i = 0; i < this.size; ++i) {
            if (!uri.equals(this.names[i].getNamespaceURI()) || !localName.equals(this.names[i].getLocalName())) continue;
            return i;
        }
        return -1;
    }

    public String getType(int i) {
        return "CDATA";
    }

    public String getType(String uri, String localName) {
        return "CDATA";
    }

    public String getType(String qName) {
        return "CDATA";
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("QAttributes[");
        for (int i = 0; i < this.size; ++i) {
            cb.append(" ");
            cb.append(this.names[i]);
            cb.append("=\"");
            cb.append(this.values[i]);
            cb.append("\"");
        }
        cb.append("]");
        return cb.close();
    }
}

