/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAttr;
import com.caucho.xml.QAttributeDef;
import com.caucho.xml.QContentParticle;
import com.caucho.xml.QDocument;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.QElement;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Node;

class QElementDef
extends QNode {
    String name;
    Object content;
    ArrayList attr;
    boolean hasDefault;
    QDocumentType dtd;

    QElementDef(String name) {
        this.name = name;
    }

    public String getNodeName() {
        return "#element";
    }

    public String getTagName() {
        return "#element";
    }

    public short getNodeType() {
        return -1;
    }

    Node importNode(QDocument owner, boolean deep) {
        QElementDef def = new QElementDef(this.name);
        return def;
    }

    public void addAttribute(String name, String type, ArrayList enumeration, String qualifier, String deflt) {
        if (this.attr == null) {
            this.attr = new ArrayList();
        }
        if (deflt != null) {
            this.hasDefault = true;
            this.dtd.setAttributeDefaults();
        }
        this.attr.add(new QAttributeDef(name, type, enumeration, qualifier, deflt));
    }

    void fillDefaults(QElement element) {
        if (!this.hasDefault) {
            return;
        }
        for (int i = 0; i < this.attr.size(); ++i) {
            QAttributeDef attrDef = (QAttributeDef)this.attr.get(i);
            if (attrDef.deflt == null || !element.getAttribute(attrDef.name).equals("")) continue;
            QAttr attr = (QAttr)element.owner.createAttribute(attrDef.name, attrDef.deflt);
            attr.owner = element.owner;
            attr.setSpecified(false);
            element.setAttributeNode(attr);
        }
    }

    public void print(XmlPrinter os) throws IOException {
        if (this.content != null) {
            os.print("<!ELEMENT ");
            os.print(this.name);
            os.print(" ");
            if (this.content instanceof QContentParticle) {
                ((QContentParticle)this.content).print(os);
            } else {
                os.print(String.valueOf(this.content));
            }
            os.println(">");
        }
        if (this.attr != null) {
            os.print("<!ATTLIST ");
            os.print(this.name);
            for (int i = 0; i < this.attr.size(); ++i) {
                String enumType;
                int j;
                QAttributeDef attribute = (QAttributeDef)this.attr.get(i);
                if (this.attr.size() == 1) {
                    os.print(" ");
                } else {
                    os.print("\n  ");
                }
                os.print(attribute.name);
                if (attribute.type.equals("#ENUM")) {
                    os.print(" (");
                    for (j = 0; j < attribute.enumeration.size(); ++j) {
                        enumType = (String)attribute.enumeration.get(j);
                        if (j != 0) {
                            os.print(" | ");
                        }
                        os.print(enumType);
                    }
                    os.print(")");
                } else if (attribute.type.equals("NOTATION")) {
                    os.print(" NOTATION (");
                    for (j = 0; j < attribute.enumeration.size(); ++j) {
                        enumType = (String)attribute.enumeration.get(j);
                        if (j != 0) {
                            os.print(" | ");
                        }
                        os.print(enumType);
                    }
                    os.print(")");
                } else {
                    os.print(" ");
                    os.print(attribute.type);
                }
                if (attribute.qualifier != null) {
                    os.print(" ");
                    os.print(attribute.qualifier);
                }
                if (attribute.deflt == null) continue;
                os.print(" \"");
                os.print(attribute.deflt);
                os.print("\"");
            }
            os.println(">");
        }
    }
}

