/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathParseException;
import com.caucho.xpath.XPathParser;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromContext;
import java.util.Iterator;
import org.w3c.dom.Node;

public class XPath {
    static WriteStream dbg = LogStream.open("/caucho.com/xpath");

    private XPath() {
    }

    public static Node find(String query, Node node) throws XPathException {
        Pattern pattern = XPath.parseSelect(query);
        return pattern.find(node);
    }

    public static Iterator select(String query, Node node) throws XPathException {
        Pattern pattern = XPath.parseSelect(query);
        return pattern.select(node);
    }

    public static Pattern parseSelect(String query) throws XPathParseException {
        Pattern pattern = null;
        if (pattern == null) {
            pattern = XPath.parseSelect(query, null);
        }
        return pattern;
    }

    public static Pattern parseSelect(String query, NamespaceContext namespace) throws XPathParseException {
        XPathParser parser = new XPathParser(query, namespace);
        AbstractPattern pattern = parser.parseSelect();
        if (dbg.canWrite()) {
            dbg.log("select: " + pattern);
        }
        return new Pattern(pattern);
    }

    public static Pattern parseMatch(String query) throws XPathParseException {
        Pattern pattern = null;
        if (pattern == null) {
            pattern = XPath.parseMatch(query, null);
        }
        return pattern;
    }

    public static Pattern parseMatch(String query, NamespaceContext namespace) throws XPathParseException {
        XPathParser parser = new XPathParser(query, namespace);
        AbstractPattern pattern = parser.parseMatch();
        if (dbg.canWrite()) {
            dbg.log("match: " + pattern);
        }
        return new Pattern(pattern);
    }

    public static String evalString(String query, Node node) throws XPathException {
        Expr expr = XPath.parseExpr(query);
        return expr.evalString(node);
    }

    public static double evalNumber(String query, Node node) throws XPathException {
        Expr expr = XPath.parseExpr(query);
        return expr.evalNumber(node);
    }

    public static Object evalObject(String query, Node node) throws XPathException {
        Expr expr = XPath.parseExpr(query);
        return expr.evalObject(node);
    }

    public static Expr parseExpr(String query) throws XPathParseException {
        Expr expr = null;
        if (expr == null) {
            expr = XPath.parseExpr(query, null);
        }
        return expr;
    }

    public static Expr parseExpr(String query, NamespaceContext namespace) throws XPathParseException {
        XPathParser parser = new XPathParser(query, namespace);
        Expr expr = parser.parseExpr();
        if (dbg.canWrite()) {
            dbg.log("expr: " + expr);
        }
        return expr;
    }

    public static Expr parseExpr(String query, NamespaceContext namespace, AbstractPattern nodeList) throws XPathParseException {
        XPathParser parser = new XPathParser(query, namespace);
        Expr expr = parser.parseExpr(new FromContext(), nodeList);
        if (expr != null) {
            expr.setListContext(nodeList);
        }
        if (dbg.canWrite()) {
            dbg.log("expr: " + expr);
        }
        return expr;
    }

    public static Env createEnv() {
        return Env.create();
    }

    public static Env createEnv(Env global) {
        Env env = Env.create();
        env.init(global);
        return env;
    }

    public static Env createCall(Env parent) {
        Env env = Env.create();
        env.initMacro(parent);
        return env;
    }

    public static Env createLoop(Env parent) {
        Env env = Env.create();
        env.init(parent);
        return env;
    }

    public static void freeEnv(Env env) {
    }
}

