/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BooleanExpr
extends Expr {
    private int code;
    private Expr left;
    private Expr right;
    private boolean value;
    private ArrayList args;

    public BooleanExpr(int code, Expr left, Expr right) {
        this.code = code;
        this.left = left;
        this.right = right;
        if (code == 5) {
            this.code = left.isNodeSet() || right.isNodeSet() ? 5 : (left.isBoolean() || right.isBoolean() ? 11 : (left.isNumber() || right.isNumber() ? 13 : (left.isString() && right.isString() ? 19 : 5)));
        } else if (code == 6) {
            this.code = left.isNodeSet() || right.isNodeSet() ? 6 : (left.isBoolean() || right.isBoolean() ? 12 : (left.isNumber() || right.isNumber() ? 14 : (left.isString() && right.isString() ? 20 : 6)));
        } else if (code == 7) {
            this.code = left.isNodeSet() || right.isNodeSet() ? 7 : (left.isNumber() || right.isNumber() ? 15 : 7);
        } else if (code == 8) {
            this.code = left.isNodeSet() || right.isNodeSet() ? 8 : (left.isNumber() || right.isNumber() ? 16 : 8);
        } else if (code == 9) {
            this.code = left.isNodeSet() || right.isNodeSet() ? 9 : (left.isNumber() || right.isNumber() ? 17 : 9);
        } else if (code == 10) {
            this.code = left.isNodeSet() || right.isNodeSet() ? 10 : (left.isNumber() || right.isNumber() ? 18 : 10);
        }
    }

    public BooleanExpr(int code, Expr expr) {
        this.code = code;
        this.left = expr;
    }

    public BooleanExpr(boolean value) {
        this.code = 0;
        this.value = value;
    }

    public BooleanExpr(int code, ArrayList args) {
        this.code = code;
        this.args = args;
        if (args.size() > 0) {
            this.left = (Expr)args.get(0);
        }
        if (args.size() > 1) {
            this.right = (Expr)args.get(1);
        }
    }

    public boolean isBoolean() {
        return true;
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        switch (this.code) {
            case 0: {
                return this.value;
            }
            case 11: {
                return this.left.evalBoolean(node, env) == this.right.evalBoolean(node, env);
            }
            case 13: {
                return this.left.evalNumber(node, env) == this.right.evalNumber(node, env);
            }
            case 19: {
                String lstr = this.left.evalString(node, env);
                String rstr = this.right.evalString(node, env);
                return lstr == rstr || lstr != null && lstr.equals(rstr);
            }
            case 5: {
                Object lobj = this.left.evalObject(node, env);
                Object robj = this.right.evalObject(node, env);
                if (lobj == robj) {
                    return true;
                }
                return this.eq(lobj, robj);
            }
            case 12: {
                return this.left.evalBoolean(node, env) != this.right.evalBoolean(node, env);
            }
            case 14: {
                return this.left.evalNumber(node, env) != this.right.evalNumber(node, env);
            }
            case 20: {
                String lstr = this.left.evalString(node, env);
                String rstr = this.right.evalString(node, env);
                return !lstr.equals(rstr);
            }
            case 6: {
                Object lobj = this.left.evalObject(node, env);
                Object robj = this.right.evalObject(node, env);
                if (lobj == robj) {
                    return false;
                }
                return this.neq(lobj, robj);
            }
            case 7: {
                return this.lt(this.left.evalObject(node, env), this.right.evalObject(node, env));
            }
            case 8: {
                return this.le(this.left.evalObject(node, env), this.right.evalObject(node, env));
            }
            case 9: {
                return this.lt(this.right.evalObject(node, env), this.left.evalObject(node, env));
            }
            case 10: {
                return this.le(this.right.evalObject(node, env), this.left.evalObject(node, env));
            }
            case 15: {
                return this.left.evalNumber(node, env) < this.right.evalNumber(node, env);
            }
            case 16: {
                return this.left.evalNumber(node, env) <= this.right.evalNumber(node, env);
            }
            case 17: {
                return this.left.evalNumber(node, env) > this.right.evalNumber(node, env);
            }
            case 18: {
                return this.left.evalNumber(node, env) >= this.right.evalNumber(node, env);
            }
            case 3: {
                return this.left.evalBoolean(node, env) || this.right.evalBoolean(node, env);
            }
            case 4: {
                return this.left.evalBoolean(node, env) && this.right.evalBoolean(node, env);
            }
            case 28: {
                return true;
            }
            case 29: {
                return false;
            }
            case 30: {
                return !this.left.evalBoolean(node, env);
            }
            case 31: {
                return this.left.evalBoolean(node, env);
            }
            case 43: {
                String lstr = this.left.evalString(node, env);
                String rstr = this.right.evalString(node, env);
                return lstr.startsWith(rstr);
            }
            case 44: {
                String lstr = this.left.evalString(node, env);
                String rstr = this.right.evalString(node, env);
                return lstr.indexOf(rstr) >= 0;
            }
            case 32: {
                String lstr = this.left.evalString(node, env);
                while (node != null) {
                    String lang;
                    if (node instanceof Element && (lang = ((Element)node).getAttribute("xml:lang")) != null && lang.equals(lstr)) {
                        return true;
                    }
                    node = node.getParentNode();
                }
                return false;
            }
            case 56: {
                return false;
            }
        }
        throw new RuntimeException("unknown code: " + this.code);
    }

    private boolean eq(Object lobj, Object robj) throws XPathException {
        if (lobj instanceof ArrayList) {
            ArrayList list = (ArrayList)lobj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.eq(list.get(i), robj)) continue;
                return true;
            }
            return false;
        }
        if (lobj instanceof Iterator) {
            Iterator iter = (Iterator)lobj;
            while (iter.hasNext()) {
                if (!this.eq(iter.next(), robj)) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof ArrayList) {
            ArrayList list = (ArrayList)robj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.eq(lobj, list.get(i))) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof NodeIterator) {
            Iterator iter = null;
            iter = (Iterator)((NodeIterator)robj).clone();
            while (iter.hasNext()) {
                if (!this.eq(lobj, iter.next())) continue;
                return true;
            }
            return false;
        }
        if (lobj instanceof Boolean || robj instanceof Boolean) {
            return BooleanExpr.toBoolean(lobj) == BooleanExpr.toBoolean(robj);
        }
        if (lobj instanceof Double || robj instanceof Double) {
            return BooleanExpr.toDouble(lobj) == BooleanExpr.toDouble(robj);
        }
        return BooleanExpr.toString(lobj).equals(BooleanExpr.toString(robj));
    }

    private boolean neq(Object lobj, Object robj) throws XPathException {
        if (lobj instanceof ArrayList) {
            ArrayList list = (ArrayList)lobj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.neq(list.get(i), robj)) continue;
                return true;
            }
            return false;
        }
        if (lobj instanceof Iterator) {
            Iterator iter = (Iterator)lobj;
            while (iter.hasNext()) {
                if (!this.neq(iter.next(), robj)) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof ArrayList) {
            ArrayList list = (ArrayList)robj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.neq(lobj, list.get(i))) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof NodeIterator) {
            Iterator iter = null;
            iter = (Iterator)((NodeIterator)robj).clone();
            while (iter.hasNext()) {
                if (!this.neq(lobj, iter.next())) continue;
                return true;
            }
            return false;
        }
        if (lobj instanceof Boolean || robj instanceof Boolean) {
            return BooleanExpr.toBoolean(lobj) != BooleanExpr.toBoolean(robj);
        }
        if (lobj instanceof Double || robj instanceof Double) {
            return BooleanExpr.toDouble(lobj) != BooleanExpr.toDouble(robj);
        }
        return !BooleanExpr.toString(lobj).equals(BooleanExpr.toString(robj));
    }

    private boolean lt(Object lobj, Object robj) throws XPathException {
        if (lobj instanceof ArrayList) {
            ArrayList list = (ArrayList)lobj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.lt(list.get(i), robj)) continue;
                return true;
            }
            return false;
        }
        if (lobj instanceof Iterator) {
            Iterator iter = (Iterator)lobj;
            while (iter.hasNext()) {
                if (!this.lt(iter.next(), robj)) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof ArrayList) {
            ArrayList list = (ArrayList)robj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.lt(lobj, list.get(i))) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof NodeIterator) {
            Iterator iter = null;
            iter = (Iterator)((NodeIterator)robj).clone();
            while (iter.hasNext()) {
                if (!this.lt(lobj, iter.next())) continue;
                return true;
            }
            return false;
        }
        return BooleanExpr.toDouble(lobj) < BooleanExpr.toDouble(robj);
    }

    private boolean le(Object lobj, Object robj) throws XPathException {
        if (lobj instanceof ArrayList) {
            ArrayList list = (ArrayList)lobj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.le(list.get(i), robj)) continue;
                return true;
            }
            return false;
        }
        if (lobj instanceof Iterator) {
            Iterator iter = (Iterator)lobj;
            while (iter.hasNext()) {
                if (!this.le(iter.next(), robj)) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof ArrayList) {
            ArrayList list = (ArrayList)robj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.le(lobj, list.get(i))) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof NodeIterator) {
            NodeIterator iter = null;
            iter = (NodeIterator)((NodeIterator)robj).clone();
            while (iter.hasNext()) {
                if (!this.le(lobj, iter.next())) continue;
                return true;
            }
            return false;
        }
        return BooleanExpr.toDouble(lobj) <= BooleanExpr.toDouble(robj);
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        if (this.evalBoolean(node, env)) {
            return 1.0;
        }
        return 0.0;
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        if (this.evalBoolean(node, env)) {
            return "true";
        }
        return "false";
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        Boolean value = new Boolean(this.evalBoolean(node, env));
        return value;
    }

    public String toString() {
        switch (this.code) {
            case 0: {
                return String.valueOf(this.value);
            }
            case 5: 
            case 11: 
            case 13: 
            case 19: {
                return "(" + this.left.toString() + " = " + this.right.toString() + ")";
            }
            case 6: 
            case 12: 
            case 14: 
            case 20: {
                return "(" + this.left.toString() + " != " + this.right.toString() + ")";
            }
            case 7: 
            case 15: {
                return "(" + this.left.toString() + " < " + this.right.toString() + ")";
            }
            case 8: 
            case 16: {
                return "(" + this.left.toString() + " <= " + this.right.toString() + ")";
            }
            case 9: 
            case 17: {
                return "(" + this.left.toString() + " > " + this.right.toString() + ")";
            }
            case 10: 
            case 18: {
                return "(" + this.left.toString() + " >= " + this.right.toString() + ")";
            }
            case 3: {
                return "(" + this.left.toString() + " or " + this.right.toString() + ")";
            }
            case 4: {
                return "(" + this.left.toString() + " and " + this.right.toString() + ")";
            }
            case 28: {
                return "true()";
            }
            case 29: {
                return "false()";
            }
            case 30: {
                return "not(" + this.left.toString() + ")";
            }
            case 31: {
                return "boolean(" + this.left.toString() + ")";
            }
            case 43: {
                return "starts-with(" + this.left + ", " + this.right + ")";
            }
            case 44: {
                return "contains(" + this.left + ", " + this.right + ")";
            }
            case 32: {
                return "lang(" + this.left + ")";
            }
            case 56: {
                return "function-available(" + this.left + ")";
            }
        }
        return super.toString();
    }
}

