/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathFun;
import com.caucho.xpath.pattern.AbstractPattern;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class FunExpr
extends Expr {
    private String name;
    private AbstractPattern pattern;
    private ArrayList args;

    public FunExpr(String name, AbstractPattern pattern, ArrayList args) {
        this.name = name;
        this.pattern = pattern;
        this.args = args;
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        return FunExpr.toBoolean(this.evalObject(node, env));
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        return FunExpr.toDouble(this.evalObject(node, env));
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        return FunExpr.toString(this.evalObject(node, env));
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        XPathFun fun = env.getFunction(this.name);
        if (fun == null) {
            throw new RuntimeException("unknown function: " + this.name);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.args.size(); ++i) {
            Expr expr = (Expr)this.args.get(i);
            values.add(expr.evalObject(node, env));
        }
        return fun.eval(node, env, this.pattern, values);
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append(this.name);
        cb.append("(");
        for (int i = 0; i < this.args.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this.args.get(i));
        }
        cb.append(")");
        return cb.toString();
    }
}

