/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Node;

public class FilterIterator
extends NodeIterator {
    private NodeIterator parentIter;
    private Expr expr;
    private Node node;
    private Node next;

    public FilterIterator(NodeIterator parentIter, Expr expr, ExprEnvironment env, Node context) throws XPathException {
        super(env);
        this.parentIter = parentIter;
        this.expr = expr;
        this.env = env;
        this.contextNode = context;
        this.node = this.findFirstMatchingNode(parentIter);
        this.position = 1;
        this.next = this.node;
    }

    public boolean hasNext() {
        block3: {
            if (this.next == null) {
                try {
                    this.next = this.nextNode();
                }
                catch (XPathException e) {
                    if (!dbg.canWrite()) break block3;
                    dbg.log(e);
                }
            }
        }
        return this.next != null;
    }

    public Node nextNode() throws XPathException {
        if (this.next != null) {
            this.node = this.next;
            this.next = null;
            return this.node;
        }
        if (this.node != null) {
            this.node = this.findFirstMatchingNode(this.parentIter);
            ++this.position;
        }
        this.next = null;
        return this.node;
    }

    private Node findFirstMatchingNode(NodeIterator parentIter) throws XPathException {
        Node node = parentIter.nextNode();
        double value;
        while (node == null || !(this.expr.isNumber() ? (value = this.expr.evalNumber(node, parentIter)) == (double)parentIter.getContextPosition() : (this.expr.isBoolean() ? this.expr.evalBoolean(node, parentIter) : ((value = this.expr.evalObject(node, parentIter)) instanceof Number ? Expr.toDouble(value) == (double)parentIter.getContextPosition() : Expr.toBoolean(value))))) {
            if (parentIter == null || (node = parentIter.nextNode()) == null) {
                node = null;
                return null;
            }
            if (parentIter.getContextPosition() == 1) {
                this.position = 0;
                this.size = 0;
            }
            this.contextNode = node;
            parentIter.setContextNode(node);
        }
        return node;
    }

    public Object clone() {
        FilterIterator clone;
        block2: {
            clone = null;
            try {
                clone = this.parentIter == null ? new FilterIterator(null, this.expr, this.env, this.contextNode) : new FilterIterator((NodeIterator)this.parentIter.clone(), this.expr, this.env, this.contextNode);
                clone.env = this.env;
                clone.position = this.position;
                clone.node = this.node;
            }
            catch (Exception e) {
                if (!dbg.canWrite()) break block2;
                dbg.log(e);
            }
        }
        return clone;
    }
}

