/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FilterIterator;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Node;

public class FilterPattern
extends AbstractPattern {
    private Expr expr;
    private AbstractPattern position;

    public FilterPattern(AbstractPattern parent, Expr expr) {
        super(parent);
        this.expr = expr;
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    public String getNodeName() {
        return this.parent.getNodeName();
    }

    public Expr getExpr() {
        return this.expr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (!this.parent.match(node, env)) {
            return false;
        }
        int envPosition = env.getContextPosition();
        if (envPosition > 0) {
            if (this.expr.isBoolean()) {
                return this.expr.evalBoolean(node, env);
            }
            if (this.expr.isNumber()) {
                double test = this.expr.evalNumber(node, env);
                return envPosition == (int)test;
            }
            Object value = this.expr.evalObject(node, env);
            if (value instanceof Number) {
                return envPosition == ((Number)value).intValue();
            }
            return Expr.toBoolean(value);
        }
        if (!(env instanceof Env)) {
            throw new RuntimeException(String.valueOf(env));
        }
        Env globalEnv = (Env)env;
        boolean oldMorePositions = globalEnv.setMorePositions(true);
        int oldIndex = globalEnv.setPositionIndex(0);
        try {
            int i = 0;
            while (globalEnv.hasMorePositions()) {
                globalEnv.setPositionIndex(i);
                globalEnv.setMorePositions(false);
                if (this.expr.isNumber()) {
                    double test = this.expr.evalNumber(node, env);
                    double position = this.parent.position(node, globalEnv, this.parent.copyPosition());
                    if (position == test) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (this.expr.isBoolean()) {
                    if (this.expr.evalBoolean(node, env)) {
                        boolean test = true;
                        return test;
                    }
                } else {
                    Object value = this.expr.evalObject(node, env);
                    if (value instanceof Number) {
                        double test = ((Number)value).doubleValue();
                        double position = this.parent.position(node, globalEnv, this.parent.copyPosition());
                        if (position == test) {
                            boolean bl = true;
                            return bl;
                        }
                    } else if (Expr.toBoolean(value)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                ++i;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            globalEnv.setPositionIndex(oldIndex);
            globalEnv.setMorePositions(oldMorePositions);
        }
    }

    public NodeIterator createNodeIterator(Node node, ExprEnvironment env, AbstractPattern match) throws XPathException {
        NodeIterator parentIter = this.parent.createNodeIterator(node, env, this.parent.copyPosition());
        return new FilterIterator(parentIter, this.expr, env, node);
    }

    public AbstractPattern copyPosition() {
        return null;
    }

    public String toString() {
        return this.parent.toString() + "[" + this.expr + "]";
    }
}

