/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import org.w3c.dom.Node;

public class NamespacePattern
extends AbstractPattern {
    private String prefix;
    private int nodeType;

    public NamespacePattern(AbstractPattern parent, String prefix, int nodeType) {
        super(parent);
        this.prefix = prefix.intern();
        this.nodeType = nodeType;
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    public double getPriority() {
        return -0.25;
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != this.nodeType) {
            return false;
        }
        String prefix = node.getPrefix();
        if (prefix != this.prefix) {
            return false;
        }
        return this.parent.match(node, env);
    }

    public String toString() {
        switch (this.nodeType) {
            case 2: {
                return this.parent.toString() + "@" + this.prefix + ":*";
            }
            case 1: {
                return this.parent.toString() + this.prefix + ":*";
            }
        }
        return super.toString();
    }
}

