/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import com.caucho.xpath.pattern.FromAny;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromParent;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.FromSelf;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeTypePattern
extends AbstractPattern {
    public static final int NODE = -2;
    public static final int ANY = -1;
    private AbstractPattern match;
    private int nodeType;

    private NodeTypePattern(AbstractPattern parent, int nodeType) {
        super(parent);
        this.nodeType = nodeType;
    }

    public static AbstractPattern create(AbstractPattern parent, int nodeType) {
        if (nodeType == -2 && parent instanceof FromParent && parent.parent instanceof FromContext) {
            FromContext context = (FromContext)parent.parent;
            return new FromContext(context.getCount() + 1);
        }
        return new NodeTypePattern(parent, nodeType);
    }

    public double getPriority() {
        if (this.parent instanceof Axis && this.parent.getParent() != null && !(this.parent.getParent() instanceof FromRoot) && !(this.parent.getParent() instanceof FromAny)) {
            return 0.5;
        }
        return -0.5;
    }

    public String getNodeName() {
        switch (this.nodeType) {
            case 3: {
                return "#text";
            }
            case 9: {
                return "#document";
            }
            case 8: {
                return "#comment";
            }
        }
        return "*";
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (this.nodeType == 2) {
            if (node.getNodeType() != 2) {
                return false;
            }
            if ("http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) {
                return false;
            }
        } else if (node.getNodeType() != this.nodeType && this.nodeType != -1 && (this.nodeType != -2 || node instanceof Document)) {
            return false;
        }
        return this.parent == null || this.parent.match(node, env);
    }

    public AbstractPattern copyPosition() {
        if (this.match == null) {
            AbstractPattern parent = null;
            if (this.parent != null) {
                parent = this.parent.copyPosition();
            }
            this.match = new NodeTypePattern(parent, this.nodeType);
        }
        return this.match;
    }

    public boolean equals(Object b) {
        if (!(b instanceof NodeTypePattern)) {
            return false;
        }
        NodeTypePattern bPattern = (NodeTypePattern)b;
        return this.nodeType == bPattern.nodeType && (this.parent == bPattern.parent || this.parent != null && this.parent.equals(bPattern.parent));
    }

    public String toString() {
        String prefix = this.parent == null ? "" : (this.parent instanceof FromChildren ? this.parent.getPrefix() : this.parent.toString());
        switch (this.nodeType) {
            case -1: {
                if (!(this.parent instanceof FromSelf)) {
                    return prefix + "node()";
                }
                if (this.parent.parent == null) {
                    return ".";
                }
                return this.parent.getPrefix() + ".";
            }
            case -2: {
                return prefix + "node()";
            }
            case 7: {
                return prefix + "pi()";
            }
            case 2: {
                return prefix + "*";
            }
            case 1: {
                return prefix + "*";
            }
            case 8: {
                return prefix + "comment()";
            }
            case 3: {
                return prefix + "text()";
            }
            case 5: {
                return prefix + "er()";
            }
        }
        return super.toString();
    }
}

