/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Node;

public class UniqueIterator
extends NodeIterator {
    private NodeIterator baseIterator;
    private Node node;
    private Node[] oldNodes;
    private int top;

    public UniqueIterator(ExprEnvironment env) {
        super(env);
    }

    public UniqueIterator(ExprEnvironment env, NodeIterator baseIterator) throws XPathException {
        super(env);
        this.baseIterator = baseIterator;
        this.node = baseIterator.nextNode();
        this.oldNodes = new Node[32];
    }

    public boolean hasNext() {
        return this.node != null;
    }

    public Node nextNode() throws XPathException {
        int i;
        Node next = this.node;
        if (next == null) {
            return null;
        }
        if (this.top == this.oldNodes.length) {
            Node[] newNodes = new Node[this.oldNodes.length * 2];
            System.arraycopy(this.oldNodes, 0, newNodes, 0, this.oldNodes.length);
            this.oldNodes = newNodes;
        }
        this.oldNodes[this.top++] = next;
        do {
            this.node = this.baseIterator.nextNode();
            if (this.node == null) {
                return next;
            }
            for (i = this.top - 1; i >= 0 && this.oldNodes[i] != this.node; --i) {
            }
        } while (i >= 0);
        return next;
    }

    public Object clone() {
        UniqueIterator clone = new UniqueIterator(this.env);
        clone.node = this.node;
        clone.oldNodes = new Node[this.oldNodes.length];
        System.arraycopy(this.oldNodes, 0, clone.oldNodes, 0, this.oldNodes.length);
        clone.top = this.top;
        return clone;
    }
}

