/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathParseException;
import java.util.Comparator;
import org.w3c.dom.Node;

public class Sort {
    private Expr expr;
    private boolean isText;
    private Expr isAscending;
    private Expr _lang;

    Sort(Expr expr, Expr isAscending, boolean isText) {
        this.expr = expr;
        this.isAscending = isAscending;
        this.isText = isText;
    }

    Sort(Expr expr, Expr isAscending, Expr lang) {
        this.expr = expr;
        this.isAscending = isAscending;
        this.isText = true;
        this._lang = lang;
    }

    public Sort(String expr, String isAscending, boolean isText) throws XPathParseException {
        this.expr = XPath.parseExpr(expr);
        if (isAscending != null) {
            this.isAscending = XPath.parseExpr(isAscending);
        }
        this.isText = isText;
    }

    public Sort(String expr, String isAscending, String lang) throws XPathParseException {
        this.expr = XPath.parseExpr(expr);
        if (isAscending != null) {
            this.isAscending = XPath.parseExpr(isAscending);
        }
        this._lang = XPath.parseExpr(lang);
        this.isText = true;
    }

    static Sort create(Expr expr, Expr isAscending, boolean isText) {
        return new Sort(expr, isAscending, isText);
    }

    static Sort create(Expr expr, Expr isAscending, Expr lang) {
        return new Sort(expr, isAscending, lang);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public Expr getAscending() {
        return this.isAscending;
    }

    public boolean isText() {
        return this.isText;
    }

    public Expr getLang() {
        return this._lang;
    }

    Object sortValue(Node child, Env env) throws XPathException {
        if (this.isText) {
            return this.expr.evalString(child, env);
        }
        return new Double(this.expr.evalNumber(child, env));
    }

    int cmp(Object a, Object b, Comparator comparator, boolean isAscending) {
        double db;
        if (comparator != null) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return isAscending ? -1 : 1;
            }
            if (b == null) {
                return isAscending ? 1 : -1;
            }
            int cmp = comparator.compare(a, b);
            return isAscending ? cmp : -cmp;
        }
        if (this.isText) {
            String va = (String)a;
            String vb = (String)b;
            if (va == vb) {
                return 0;
            }
            if (va == null) {
                return isAscending ? -1 : 1;
            }
            if (vb == null) {
                return isAscending ? 1 : -1;
            }
            int cmp = va.compareTo(vb);
            return isAscending ? cmp : -cmp;
        }
        double da = (Double)a;
        if (da == (db = ((Double)b).doubleValue())) {
            return 0;
        }
        if (da < db) {
            return isAscending ? -1 : 1;
        }
        if (db < da) {
            return isAscending ? 1 : -1;
        }
        if (!Double.isNaN(da)) {
            return isAscending ? -1 : 1;
        }
        if (!Double.isNaN(db)) {
            return isAscending ? 1 : -1;
        }
        return 0;
    }
}

