/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.LineMap;
import com.caucho.transform.StringTransformer;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.StringWriter;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.XmlPrinter;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StringTransformerImpl
extends TransformerImpl
implements StringTransformer {
    protected LineMap lineMap;

    StringTransformerImpl(StylesheetImpl stylesheet) {
        super(stylesheet);
    }

    public Object getProperty(String name) {
        if (name.equals("caucho.line-map")) {
            return this.lineMap;
        }
        return super.getProperty(name);
    }

    public String transform(InputStream source) throws SAXException, IOException {
        return this.transform(this.parseDocument(source, null));
    }

    public String transform(String systemId) throws SAXException, IOException {
        return this.transform(this.parseDocument(systemId));
    }

    public String transformString(String source) throws SAXException, IOException {
        return this.transform(this.parseStringDocument(source, null));
    }

    public String transform(Node node) throws SAXException, IOException {
        this.lineMap = null;
        Properties output = this.stylesheet.getOutputProperties();
        StringWriter sw = new StringWriter();
        WriteStream ws = sw.openWrite();
        XmlPrinter out = new XmlPrinter(ws);
        out.setMethod((String)output.get("method"));
        out.setEncoding("UTF-8");
        out.setMimeType((String)output.get("media-type"));
        String omit = (String)output.get("omit-xml-declaration");
        if (omit == null || omit.equals("false") || omit.equals("no")) {
            out.setPrintDeclaration(true);
        }
        out.setStandalone((String)output.get("standalone"));
        out.setSystemId((String)output.get("doctype-system"));
        out.setPublicId((String)output.get("doctype-public"));
        String indent = (String)output.get("indent");
        if (indent != null) {
            out.setPretty(indent.equals("true"));
        }
        out.setVersion((String)output.get("version"));
        if (node instanceof CauchoNode) {
            String filename = ((CauchoNode)node).getFilename();
            out.setLineMap(filename != null ? filename : "anonymous.xsl");
        } else {
            out.setLineMap("anonymous.xsl");
        }
        String includeContentType = (String)output.get("include-content-type");
        if (includeContentType != null) {
            out.setIncludeContentType(includeContentType.equals("true") || includeContentType.equals("yes"));
        }
        try {
            out.startDocument();
            this.stylesheet.transform(node, out, this);
            out.endDocument();
            this.lineMap = out.getLineMap();
            ws.close();
            return sw.getString();
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }
}

