/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class AbstractTransactionalSpringContextTests
extends AbstractDependencyInjectionSpringContextTests {
    protected PlatformTransactionManager transactionManager;
    protected TransactionStatus transactionStatus;
    private boolean defaultRollback = true;
    private boolean complete;

    public void setDefaultRollback(boolean defaultRollback) {
        this.defaultRollback = defaultRollback;
    }

    public void setTransactionManager(PlatformTransactionManager ptm) {
        this.transactionManager = ptm;
    }

    protected final void onSetUp() throws Exception {
        this.complete = !this.defaultRollback;
        this.transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        this.logger.info((Object)("Began transaction: transaction manager [" + this.transactionManager + "]; defaultCommit " + this.complete));
        this.onSetUpInTransaction();
    }

    protected void onSetUpInTransaction() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onTearDown() throws Exception {
        try {
            this.onTearDownInTransaction();
        }
        finally {
            this.endTransaction();
        }
    }

    protected void onTearDownInTransaction() {
    }

    protected void setComplete() {
        this.complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction() {
        if (this.transactionStatus != null) {
            try {
                if (!this.complete) {
                    this.transactionManager.rollback(this.transactionStatus);
                    this.logger.info((Object)"Rolled back transaction after test execution");
                } else {
                    this.transactionManager.commit(this.transactionStatus);
                    this.logger.info((Object)"Committed transaction after test execution");
                }
            }
            finally {
                this.transactionStatus = null;
            }
        }
    }
}

