/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.parser.BinaryExpr;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.BooleanBinaryExpr;
import com.caucho.es.parser.BooleanExpr;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.CastExpr;
import com.caucho.es.parser.ConditionalExpr;
import com.caucho.es.parser.FieldExpr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.es.parser.ParseClass;
import com.caucho.es.parser.PlusExpr;
import com.caucho.es.parser.SpecialExpr;
import com.caucho.es.parser.TypeExpr;
import com.caucho.es.parser.UnaryExpr;
import java.io.IOException;

class Expr {
    protected static final int TYPE_UNKNOWN = 0;
    protected static final int TYPE_ES = 1;
    protected static final int TYPE_STRING = 2;
    protected static final int TYPE_NUMBER = 3;
    protected static final int TYPE_LONG = 3;
    protected static final int TYPE_INTEGER = 4;
    protected static final int TYPE_BOOLEAN = 5;
    protected static final int TYPE_JAVA = 6;
    protected static final int TYPE_VOID = 7;
    protected ParseClass cl;
    protected Block block;
    protected Function function;
    protected int type;
    protected Class javaType;
    protected boolean isTop;
    protected boolean noValue;
    private String filename;
    private int line;
    protected int withDepth;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$caucho$es$ESBase;

    Expr(Block block) {
        this.block = block;
        this.withDepth = block.getWithDepth();
        this.function = block.function;
        this.cl = this.function.cl;
        this.filename = block.getFilename();
        this.line = block.getLine();
        this.type = 0;
    }

    String getFilename() {
        return this.filename;
    }

    int getLine() {
        return this.line;
    }

    void killValue() {
        this.noValue = true;
    }

    void setUsed() {
        this.getType();
    }

    void setTop() {
        this.noValue = true;
        this.isTop = true;
    }

    int getType() {
        return this.type;
    }

    Expr getTypeExpr() {
        return null;
    }

    Class getJavaClass() {
        if (this.javaType != null) {
            return this.javaType;
        }
        Expr type = this.getTypeExpr();
        if (!(type instanceof TypeExpr)) {
            switch (this.getType()) {
                case 2: {
                    return class$java$lang$String == null ? (class$java$lang$String = Expr.class$("java.lang.String")) : class$java$lang$String;
                }
                case 4: {
                    return Integer.TYPE;
                }
                case 3: {
                    return Double.TYPE;
                }
                case 5: {
                    return Boolean.TYPE;
                }
            }
            return class$com$caucho$es$ESBase == null ? (class$com$caucho$es$ESBase = Expr.class$("com.caucho.es.ESBase")) : class$com$caucho$es$ESBase;
        }
        TypeExpr javaType = (TypeExpr)type;
        return javaType.getJavaClass();
    }

    boolean isSimple() {
        return false;
    }

    boolean isNumeric() {
        int type = this.getType();
        return type >= 3 && type <= 5;
    }

    boolean isNum() {
        int type = this.getType();
        return type == 3 || type == 4;
    }

    Expr setBoolean() {
        return new BooleanExpr(this.block, this);
    }

    Expr next(String iter, Expr lhs) throws ESException {
        return lhs.assign(new SpecialExpr(this.block, 110, iter));
    }

    Expr fieldReference(Expr expr) {
        return new FieldExpr(this.block, this, expr);
    }

    Expr fieldReference(ESId id) throws ESException {
        return new FieldExpr(this.block, this, new LiteralExpr(this.block, id));
    }

    Expr unaryOp(int op) {
        return new UnaryExpr(this.block, this, op);
    }

    Expr doVoid() {
        return new UnaryExpr(this.block, this, 118);
    }

    Expr typeof() {
        return new UnaryExpr(this.block, this, 116);
    }

    Expr delete() throws ESException {
        return BinaryExpr.create(this.block, this, new LiteralExpr(this.block, ESBoolean.TRUE), 44);
    }

    Expr assign(Expr value) throws ESException {
        throw this.error("illegal left-hand-side of assignment");
    }

    CallExpr startCall() throws ESException {
        return new CallExpr(this.block, this, null, false);
    }

    CallExpr startNew() throws ESException {
        return new CallExpr(this.block, this, null, true);
    }

    Expr prefix(int op) throws ESException {
        return this.unaryOp(43).binaryOp(op, op, new LiteralExpr(this.block, ESNumber.create(1.0)));
    }

    Expr postfix(int op) {
        return this.unaryOp(43);
    }

    Expr binaryOp(int lex, int op, Expr rexpr) throws ESException {
        this.setUsed();
        rexpr.setUsed();
        if (lex != 61) {
            switch (op) {
                case 60: 
                case 62: 
                case 271: 
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 276: {
                    return BooleanBinaryExpr.create(this.block, this, rexpr, op);
                }
                case 43: {
                    return PlusExpr.create(this.block, this, rexpr);
                }
            }
            return BinaryExpr.create(this.block, this, rexpr, op);
        }
        if (op == 61) {
            return this.assign(rexpr);
        }
        return this.assign(this.binaryOp(op, op, rexpr));
    }

    Expr cast(Expr castType) throws ESException {
        return CastExpr.create(this.block, this, (TypeExpr)castType);
    }

    Expr conditional(Expr mexpr, Expr rexpr) {
        return new ConditionalExpr(this.block, this, mexpr, rexpr);
    }

    void printExpr() throws IOException {
        this.print();
    }

    void print() throws IOException {
        if ((class$com$caucho$es$ESBase == null ? (class$com$caucho$es$ESBase = Expr.class$("com.caucho.es.ESBase")) : class$com$caucho$es$ESBase).isAssignableFrom(this.getJavaClass()) || this instanceof LiteralExpr) {
            this.printImpl();
            if (this.isTop) {
                this.cl.println(";");
            }
            return;
        }
        switch (this.getType()) {
            case 3: {
                if (!this.noValue) {
                    this.cl.print("ESNumber.create(");
                }
                this.printNumImpl();
                if (this.noValue) break;
                this.cl.print(")");
                break;
            }
            case 4: {
                if (!this.noValue) {
                    this.cl.print("ESNumber.create(");
                }
                this.printInt32Impl();
                if (this.noValue) break;
                this.cl.print(")");
                break;
            }
            case 5: {
                if (!this.noValue) {
                    this.cl.print("(");
                }
                this.printBooleanImpl();
                if (this.noValue) break;
                this.cl.print("?ESBoolean.TRUE:ESBoolean.FALSE)");
                break;
            }
            case 2: {
                if ((class$com$caucho$es$ESBase == null ? (class$com$caucho$es$ESBase = Expr.class$("com.caucho.es.ESBase")) : class$com$caucho$es$ESBase).isAssignableFrom(this.getJavaClass())) {
                    this.printImpl();
                    break;
                }
                if (!this.noValue) {
                    this.cl.print("ESString.create(");
                }
                this.printStringImpl();
                if (this.noValue) break;
                this.cl.print(")");
                break;
            }
            case 6: {
                if (!this.noValue) {
                    this.cl.print("_env.wrap(");
                }
                this.printJavaImpl();
                if (this.noValue) break;
                this.cl.print(")");
                break;
            }
            case 7: {
                if (!this.noValue) {
                    this.cl.print("_env.wrap(");
                }
                this.printJavaImpl();
                if (this.noValue) break;
                this.cl.print(")");
                break;
            }
            default: {
                this.printImpl();
            }
        }
        if (this.isTop) {
            this.cl.println(";");
        }
    }

    void printBoolean() throws IOException {
        switch (this.getType()) {
            case 3: {
                this.cl.print("(");
                this.printNumImpl();
                this.cl.print("!=0.0)");
                break;
            }
            case 4: {
                this.cl.print("(");
                this.printInt32Impl();
                this.cl.print("!=0)");
                break;
            }
            case 5: {
                this.printBooleanImpl();
                break;
            }
            case 6: {
                this.cl.print("(");
                this.printJava();
                this.cl.print("!=null)");
                break;
            }
            default: {
                this.print();
                this.cl.print(".toBoolean()");
            }
        }
        if (this.isTop) {
            this.cl.println(";");
        }
    }

    void printInt32() throws IOException {
        switch (this.getType()) {
            case 4: {
                this.printInt32Impl();
                break;
            }
            case 3: {
                this.cl.print("((int)");
                this.printNumImpl();
                this.cl.print(")");
                break;
            }
            case 5: {
                this.cl.print("(");
                this.printBooleanImpl();
                this.cl.print("?1:0)");
                break;
            }
            default: {
                this.printImpl();
                this.cl.print(".toInt32()");
            }
        }
    }

    void printInt64() throws IOException {
        this.printInt32();
    }

    void printNum() throws IOException {
        switch (this.getType()) {
            case 3: {
                this.printNumImpl();
                break;
            }
            case 4: {
                this.cl.print("((double)");
                this.printInt32Impl();
                this.cl.print(")");
                break;
            }
            case 5: {
                this.cl.print("(");
                this.printBooleanImpl();
                this.cl.print("?1.0:0.0)");
                break;
            }
            default: {
                this.printImpl();
                this.cl.print(".toNum()");
            }
        }
    }

    void printJava() throws IOException {
        switch (this.getType()) {
            case 4: {
                this.printInt32Impl();
                break;
            }
            case 5: {
                this.printBooleanImpl();
                break;
            }
            case 2: {
                this.printStringImpl();
                break;
            }
            case 3: {
                this.printNumImpl();
                break;
            }
            case 6: {
                this.printJavaImpl();
                break;
            }
            default: {
                this.print();
                this.cl.print(".toJavaObject()");
            }
        }
    }

    void printStr() throws IOException {
        this.print();
        this.cl.print(".toStr()");
    }

    void printJavaString() throws IOException {
        switch (this.getType()) {
            case 2: {
                if (this instanceof LiteralExpr) {
                    this.printStringImpl();
                    break;
                }
                this.cl.print("String.valueOf(");
                this.printStringImpl();
                this.cl.print(")");
                break;
            }
            case 6: {
                if (this.getJavaClass().equals(class$java$lang$String == null ? (class$java$lang$String = Expr.class$("java.lang.String")) : class$java$lang$String)) {
                    this.printJavaImpl();
                    break;
                }
                this.cl.print("String.valueOf(");
                this.printJavaImpl();
                this.cl.print(")");
                break;
            }
            default: {
                this.print();
                this.cl.print(".toStr().toString()");
            }
        }
    }

    void printJavaClass(Class type) throws IOException {
        if (type.isArray()) {
            this.printJavaClass(type.getComponentType());
            this.cl.print("[]");
        } else {
            this.cl.print(type.getName());
        }
    }

    void printString() throws IOException {
        switch (this.getType()) {
            case 4: {
                this.printInt32Impl();
                break;
            }
            case 5: {
                this.printBooleanImpl();
                break;
            }
            case 2: {
                this.printStringImpl();
                break;
            }
            case 6: {
                this.printJavaImpl();
                break;
            }
            default: {
                this.print();
                this.cl.print(".valueOf()");
            }
        }
    }

    void printImpl() throws IOException {
        throw new RuntimeException("" + this);
    }

    void printBooleanImpl() throws IOException {
        throw new RuntimeException("" + this);
    }

    void printNumImpl() throws IOException {
        throw new RuntimeException("" + this);
    }

    void printInt32Impl() throws IOException {
        throw new RuntimeException("" + this);
    }

    void printInt64Impl() throws IOException {
        throw new RuntimeException("" + this);
    }

    void printStringImpl() throws IOException {
        throw new RuntimeException("no string impl for " + this.getClass());
    }

    void printJavaImpl() throws IOException {
        throw new RuntimeException("" + this);
    }

    void printLiteral(ESBase literal) throws IOException {
        this.cl.printLiteral(literal);
    }

    void exprStatement(Function fun) throws ESException {
    }

    private ESException error(String msg) {
        return this.block.error(msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

