/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.wrapper;

import com.caucho.es.wrapper.ESBeanInfo;
import com.caucho.es.wrapper.ESMethodDescriptor;
import com.caucho.util.CauchoSystem;
import com.caucho.util.LruCache;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ESIntrospector {
    static LruCache beans = new LruCache(64);
    static Integer NULL = new Integer(0);
    static final int METHOD = 1;
    static final int PROPERTY = 2;
    static final int MASK = 3;
    static String[] path = new String[]{"", "com.caucho.eswrap"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ESBeanInfo getBeanInfo(Class cl) throws IntrospectionException {
        ESBeanInfo info;
        LruCache lruCache = beans;
        synchronized (lruCache) {
            info = (ESBeanInfo)beans.get(cl);
        }
        if (info != null) {
            return info;
        }
        info = new ESBeanInfo(cl);
        ESIntrospector.getMethods(info, cl);
        lruCache = beans;
        synchronized (lruCache) {
            beans.put(cl, info);
        }
        return info;
    }

    private static void analyzeProperty(ESBeanInfo info, Class cl, ESMethodDescriptor md, boolean overwrite) throws IntrospectionException {
        Method method = md.getMethod();
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return;
        }
        String name = method.getName();
        Class<?> returnType = method.getReturnType();
        String returnName = returnType.getName();
        Class[] params = md.getParameterTypes();
        if (name.equals("keys") && params.length == 0 && (returnName.equals("java.util.Iterator") || returnName.equals("java.util.Enumeration"))) {
            info.iterator = md;
        } else if (name.equals("iterator") && params.length == 0 && (returnName.equals("java.util.Iterator") || returnName.equals("java.util.Enumeration"))) {
            if (info.iterator == null) {
                info.iterator = md;
            }
        } else if (name.startsWith("get") && !name.equals("get")) {
            String propName = Introspector.decapitalize(name.substring(3));
            if (returnName.equals("void") && params.length < 2) {
                return;
            }
            if (params.length == 0 && (propName.endsWith("Keys") && !propName.equals("Keys") || propName.endsWith("Names") && !propName.equals("Names")) && (returnName.equals("java.util.Iterator") || returnName.equals("java.util.Enumeration"))) {
                if (propName.endsWith("Keys")) {
                    info.addNamedProp(propName.substring(0, propName.length() - 4), null, null, null, md);
                } else {
                    info.addNamedProp(propName.substring(0, propName.length() - 5), null, null, null, md);
                }
            } else if (params.length == 0 && (propName.endsWith("Size") && !propName.equals("Size") || propName.endsWith("Length") && !propName.equals("Length")) && returnName.equals("int")) {
                info.addProp(propName, null, md, null);
                if (propName.endsWith("Size")) {
                    info.addIndexedProp(propName.substring(0, propName.length() - 4), null, null, md);
                } else {
                    info.addIndexedProp(propName.substring(0, propName.length() - 6), null, null, md);
                }
            } else if (params.length == 0) {
                info.addProp(propName, null, md, null);
            } else if (params.length == 1 && params[0].getName().equals("java.lang.String")) {
                info.addNamedProp(propName, md, null, null, null);
            } else if (params.length == 1 && params[0].getName().equals("int")) {
                info.addIndexedProp(propName, md, null, null);
            } else if (params.length == 1) {
                // empty if block
            }
        } else if (name.startsWith("set") && !name.equals("set")) {
            String propName = Introspector.decapitalize(name.substring(3));
            if (params.length == 0) {
                return;
            }
            if (!returnType.getName().equals("void") && params.length < 3) {
                return;
            }
            if (params.length == 1) {
                info.addProp(propName, null, null, md);
            } else if (params.length == 2 && params[0].getName().equals("java.lang.String")) {
                info.addNamedProp(propName, null, md, null, null);
            } else if (params.length == 2 && params[0].getName().equals("int")) {
                info.addIndexedProp(propName, null, md, null);
            } else if (params.length == 2) {
                // empty if block
            }
        } else if (name.startsWith("remove") && !name.equals("remove") || name.startsWith("delete") && !name.equals("remove")) {
            String propName = Introspector.decapitalize(name.substring(6));
            if (params.length == 0) {
                return;
            }
            if (!returnType.getName().equals("void") && params.length < 2) {
                return;
            }
            if (params.length == 1 && params[0].getName().equals("java.lang.String")) {
                info.addNamedProp(propName, null, null, md, null);
            }
        }
    }

    static void addEcmaMethods(ESBeanInfo info, Class cl, Class wrapCl, int mask) throws IntrospectionException {
        Method[] methods = wrapCl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            int modifiers = methods[i].getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            ESMethodDescriptor md = info.createMethodDescriptor(methods[i], true);
            if ((mask & 1) != 0) {
                info.addMethod(md);
            }
            if ((mask & 2) == 0) continue;
            ESIntrospector.analyzeProperty(info, cl, md, true);
        }
    }

    static void addEcmaWrap(ESBeanInfo info, Class cl, int mask) throws IntrospectionException {
        String name = cl.getName();
        int lastDot = name.lastIndexOf(46);
        String prefix = lastDot == -1 ? "" : name.substring(0, lastDot);
        String tail = lastDot == -1 ? name : name.substring(lastDot + 1);
        ClassLoader loader = cl.getClassLoader();
        for (int i = 0; i < path.length; ++i) {
            Class wrapCl;
            String testName = path[i].equals("") ? name + "EcmaWrap" : path[i] + "." + name + "EcmaWrap";
            try {
                wrapCl = CauchoSystem.loadClass(testName, false, loader);
                if (wrapCl != null) {
                    ESIntrospector.addEcmaMethods(info, cl, wrapCl, mask);
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            testName = path[i].equals("") ? tail + "EcmaWrap" : path[i] + "." + tail + "EcmaWrap";
            try {
                wrapCl = CauchoSystem.loadClass(testName, false, loader);
                if (wrapCl == null) continue;
                ESIntrospector.addEcmaMethods(info, cl, wrapCl, mask);
                return;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    static int getBeanInfo(ESBeanInfo info, Class cl) {
        try {
            String name = cl.getName() + "BeanInfo";
            Class beanClass = CauchoSystem.loadClass(name, false, cl.getClassLoader());
            if (beanClass == null) {
                return 3;
            }
            BeanInfo beanInfo = (BeanInfo)beanClass.newInstance();
            MethodDescriptor[] mds = beanInfo.getMethodDescriptors();
            if (mds == null) {
                return 3;
            }
            for (int i = 0; i < mds.length; ++i) {
                Method method = mds[i].getMethod();
                int modifiers = method.getModifiers();
                if (!Modifier.isStatic(modifiers) && !method.getDeclaringClass().isAssignableFrom(cl)) continue;
                info.addMethod(mds[i], true);
            }
            return 2;
        }
        catch (Exception e) {
            return 3;
        }
    }

    static void getPropBeanInfo(ESBeanInfo info, Class cl) {
        try {
            String name = cl.getName() + "BeanInfo";
            Class beanClass = CauchoSystem.loadClass(name, false, cl.getClassLoader());
            if (beanClass == null) {
                return;
            }
            BeanInfo beanInfo = (BeanInfo)beanClass.newInstance();
            PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
            for (int i = 0; props != null && i < props.length; ++i) {
                ESMethodDescriptor read = new ESMethodDescriptor(props[i].getReadMethod(), false, false);
                ESMethodDescriptor write = new ESMethodDescriptor(props[i].getWriteMethod(), false, false);
                info.addProp(props[i].getName(), null, read, write, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getMethods(ESBeanInfo info, Class cl) throws IntrospectionException {
        int modifiers;
        ESBeanInfo subInfo;
        if (!cl.isPrimitive() && !cl.isArray() && cl.getName().indexOf(46) < 0) {
            info.addNonPkgClass(cl.getName());
        }
        ESIntrospector.getPropBeanInfo(info, cl);
        int mask = ESIntrospector.getBeanInfo(info, cl);
        if (mask == 0) {
            return;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            subInfo = ESIntrospector.getBeanInfo(interfaces[i]);
            if ((mask & 1) != 0) {
                info.addMethods(subInfo);
            }
            if ((mask & 2) == 0) continue;
            info.addProps(subInfo);
        }
        Class superClass = cl.getSuperclass();
        if (superClass != null) {
            subInfo = ESIntrospector.getBeanInfo(superClass);
            if ((mask & 1) != 0) {
                info.addMethods(subInfo);
            }
            if ((mask & 2) != 0) {
                info.addProps(subInfo);
            }
        }
        if (Modifier.isPublic(modifiers = cl.getModifiers())) {
            Method[] methods = cl.getDeclaredMethods();
            int len = methods == null ? 0 : methods.length;
            for (int i = 0; i < len; ++i) {
                ESMethodDescriptor md = info.createMethodDescriptor(methods[i], false);
                if ((mask & 1) != 0) {
                    info.addMethod(md);
                }
                if ((mask & 2) == 0) continue;
                ESIntrospector.analyzeProperty(info, cl, md, false);
            }
            Field[] fields = cl.getDeclaredFields();
            for (int i = 0; fields != null && i < fields.length; ++i) {
                info.addField(fields[i]);
            }
        }
        ESIntrospector.addEcmaWrap(info, cl, mask);
    }
}

