/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.distribution;

import com.caucho.http.distribution.BackingContext;
import com.caucho.http.distribution.ObjectBacking;
import com.caucho.util.LruCache;
import java.util.Hashtable;

public class BackingManager {
    private Hashtable contextMap = new Hashtable();
    private LruCache backingCache = new LruCache(1024);
    private BackingKey key = new BackingKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectBacking getBacking(String contextId, String objectId) {
        ObjectBacking backing;
        BackingManager backingManager = this;
        synchronized (backingManager) {
            this.key.init(contextId, objectId);
            backing = (ObjectBacking)this.backingCache.get(this.key);
        }
        if (backing != null) {
            return backing;
        }
        BackingContext context = this.getContext(contextId);
        if (context == null) {
            return null;
        }
        backing = context.getBacking(objectId);
        BackingKey newKey = new BackingKey(contextId, objectId);
        return (ObjectBacking)this.backingCache.putIfNew(newKey, backing);
    }

    public BackingContext getContext(String contextId) {
        return (BackingContext)this.contextMap.get(contextId);
    }

    public void setContext(String contextId, BackingContext context) {
        this.contextMap.put(contextId, context);
    }

    public void removeContext(String contextId) {
        this.contextMap.remove(contextId);
    }

    static class BackingKey {
        private String contextId;
        private String objectId;

        BackingKey() {
        }

        BackingKey(String contextId, String objectId) {
            this.contextId = contextId;
            this.objectId = objectId;
        }

        void init(String contextId, String objectId) {
            this.contextId = contextId;
            this.objectId = objectId;
        }

        public int hashCode() {
            return this.contextId.hashCode() * 65521 + this.objectId.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof BackingKey)) {
                return false;
            }
            BackingKey key = (BackingKey)o;
            return this.contextId.equals(key.contextId) && this.objectId.equals(key.objectId);
        }
    }
}

