/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.session;

import com.caucho.http.session.SessionImpl;
import com.caucho.http.session.SessionManager;
import com.caucho.util.CauchoSystem;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class SessionStore {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/session");
    static L10N L = new L10N(class$com$caucho$http$session$SessionStore == null ? (class$com$caucho$http$session$SessionStore = SessionStore.class$("com.caucho.http.session.SessionStore")) : class$com$caucho$http$session$SessionStore);
    protected SessionManager manager;
    static /* synthetic */ Class class$com$caucho$http$session$SessionStore;

    SessionStore(SessionManager manager) {
        this.manager = manager;
    }

    void init() throws Exception {
    }

    SessionManager getManager() {
        return this.manager;
    }

    boolean load(SessionImpl session) throws Exception {
        return false;
    }

    static boolean load(SessionImpl session, InputStream is, int oldUpdateCount) throws Exception {
        SessionManager manager = session.getManager();
        DynamicClassLoader loader = manager.getApplication().getClassLoader();
        CauchoSystem.setContextClassLoader(loader);
        SessionObjectInputStream ois = new SessionObjectInputStream(is, loader);
        int random = ois.readInt();
        int random2 = -1;
        int updateCount = ois.readInt();
        if (updateCount <= oldUpdateCount) {
            ois.close();
            if (dbg.canWrite() && updateCount != oldUpdateCount) {
                dbg.log("session store: obsolete " + session.getId());
            }
            return updateCount == oldUpdateCount;
        }
        int size = ois.readInt();
        session.unbind();
        for (int i = 0; i < size; ++i) {
            String key = ois.readUTF();
            Object value = ois.readObject();
            if (value == null) continue;
            session.setAttribute(key, value);
        }
        random2 = ois.readInt();
        ois.close();
        if (random2 != random) {
            throw new IOException("session store corrupted:" + session.getId());
        }
        session.setUpdateCount(updateCount);
        return true;
    }

    void store(SessionImpl session) throws Exception {
    }

    void close(SessionImpl session) throws Exception {
        this.store(session);
    }

    static boolean store(SessionImpl session, OutputStream os) throws Exception {
        int random = (int)(2.147483647E9 * Math.random());
        Set set = session.getEntrySet();
        int size = -1;
        if (set == null || (size = set.size()) == 0) {
            return false;
        }
        ObjectOutputStream oos = new ObjectOutputStream(os);
        int updateCount = session.incrUpdateCount();
        oos.writeInt(random);
        oos.writeInt(updateCount);
        oos.writeInt(size);
        boolean ignoreNonSerializable = session.getManager().getIgnoreSerializationErrors();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object value = entry.getValue();
            oos.writeUTF((String)entry.getKey());
            if (ignoreNonSerializable && !(value instanceof Serializable)) {
                oos.writeObject(null);
                continue;
            }
            try {
                oos.writeObject(value);
            }
            catch (NotSerializableException e) {
                if (!session.getManager().getIgnoreSerializationErrors()) {
                    session.getServletContext().log(L.l("Failed storing persistent session attribute `{0}'.  Persistent session values must extend java.io.Serializable.\n{1}", entry.getKey(), String.valueOf(e)));
                }
                throw e;
            }
        }
        oos.writeInt(random);
        oos.close();
        return true;
    }

    void invalidate(SessionImpl session) throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class SessionObjectInputStream
    extends ObjectInputStream {
        private ClassLoader loader;

        SessionObjectInputStream(InputStream is, ClassLoader loader) throws IOException {
            super(is);
            this.loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String name = v.getName();
            return CauchoSystem.loadClass(name, false, this.loader);
        }
    }
}

