/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.webdav;

import com.caucho.http.webdav.AbstractPath;
import com.caucho.http.webdav.ApplicationPath;
import com.caucho.http.webdav.AttributeName;
import com.caucho.http.webdav.FilePath;
import com.caucho.server.http.Application;
import com.caucho.util.CharBuffer;
import com.caucho.util.HTTPUtil;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebDavServlet
extends GenericServlet {
    private static WriteStream dbg = LogStream.open("/caucho.com/http/webdav");
    private QDate calendar = new QDate();
    private boolean enable = false;
    private boolean enableWrite = false;
    private String user;
    private String role;
    private boolean needsSecure;
    private AbstractPath path;

    public void init() throws ServletException {
        String enable = this.getInitParameter("enable");
        if (enable == null || enable.equals("")) {
            return;
        }
        if (enable.equals("read")) {
            this.enable = true;
        } else if (enable.equals("write") || enable.equals("all") || enable.equals("yes") || enable.equals("true")) {
            this.enable = true;
            this.enableWrite = true;
        }
        this.role = this.getInitParameter("role");
        if (this.role == null) {
            this.role = "webdav";
        } else if (this.role.equals("*")) {
            this.role = null;
        }
        this.user = this.getInitParameter("user");
        String secure = this.getInitParameter("secure");
        this.needsSecure = !"false".equalsIgnoreCase(secure) && !"no".equalsIgnoreCase(secure);
        String pathSource = this.getInitParameter("path-source");
        try {
            if (pathSource != null) {
                Context env = (Context)new InitialContext().lookup("java:comp/env");
                this.path = (AbstractPath)env.lookup(pathSource);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (pathSource != null && this.path == null) {
                this.path = (AbstractPath)new InitialContext().lookup(pathSource);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        String root = this.getInitParameter("root");
        if (this.path == null) {
            if (root != null) {
                Path pwd = ((Application)this.getServletContext()).getAppDir();
                Path rootPath = pwd.lookup(root);
                try {
                    rootPath.mkdirs();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.path = new FilePath(rootPath);
            } else {
                this.path = new ApplicationPath();
            }
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        PrintWriter out = res.getWriter();
        if (!this.enable) {
            res.sendError(403);
            return;
        }
        if (this.needsSecure && !req.isSecure()) {
            res.sendError(403);
            return;
        }
        if (this.role != null && !req.isUserInRole(this.role)) {
            res.sendError(403);
            return;
        }
        if (this.user != null) {
            Principal principal = req.getUserPrincipal();
            if (principal == null) {
                res.sendError(403);
                return;
            }
            if (!principal.getName().equals(this.user)) {
                res.sendError(403);
                return;
            }
        }
        ServletContext app = this.getServletContext();
        String requestURI = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        String depthString = req.getHeader("Depth");
        int depth = Integer.MAX_VALUE;
        if ("0".equals(depthString)) {
            depth = 0;
        } else if ("1".equals(depthString)) {
            depth = 1;
        }
        if (req.getMethod().equals("OPTIONS")) {
            res.setHeader("DAV", "1");
            res.setHeader("MS-Author-Via", "DAV");
            if (this.enableWrite) {
                res.setHeader("Allow", "OPTIONS, PROPFIND, GET, HEAD, PUT, MKCOL, DELETE, COPY, MOVE, PROPPATCH");
            } else if (this.enable) {
                res.setHeader("Allow", "OPTIONS, PROPFIND, GET, HEAD");
            }
        } else if (req.getMethod().equals("PROPFIND")) {
            this.handlePropfind(req, res, depth);
        } else if (req.getMethod().equals("GET") || req.getMethod().equals("HEAD")) {
            this.handleGet(req, res);
        } else if (req.getMethod().equals("PUT") && this.enableWrite) {
            this.handlePut(req, res);
        } else if (req.getMethod().equals("MKCOL") && this.enableWrite) {
            this.handleMkcol(req, res);
        } else if (req.getMethod().equals("DELETE") && this.enableWrite) {
            this.handleDelete(req, res);
        } else if (req.getMethod().equals("COPY") && this.enableWrite) {
            this.handleCopy(req, res, depth);
        } else if (req.getMethod().equals("MOVE") && this.enableWrite) {
            this.handleMove(req, res);
        } else if (req.getMethod().equals("PROPPATCH") && this.enableWrite) {
            this.handleProppatch(req, res, depth);
        } else if (!this.enableWrite && "PUT".equals(req.getMethod()) || "MKCOL".equals(req.getMethod()) || "DELETE".equals(req.getMethod()) || "COPY".equals(req.getMethod()) || "MOVE".equals(req.getMethod()) || "PROPPATCH".equals(req.getMethod())) {
            res.sendError(403);
        } else {
            res.sendError(501, "Method not implemented");
        }
    }

    private void handlePropfind(HttpServletRequest req, HttpServletResponse res, int depth) throws ServletException, IOException {
        ServletInputStream is = req.getInputStream();
        PropfindHandler handler = new PropfindHandler();
        XmlParser parser = new XmlParser();
        parser.setContentHandler(handler);
        try {
            parser.parse((InputStream)is);
        }
        catch (SAXException e) {
            this.sendError(res, 400, "Bad Request for PROPFIND", String.valueOf(e));
            return;
        }
        Application app = (Application)this.getServletContext();
        Path appDir = app.getAppDir();
        String pathInfo = req.getPathInfo();
        String uriPwd = app.getContextPath() + req.getServletPath();
        if (pathInfo == null) {
            pathInfo = "/";
        } else {
            uriPwd = uriPwd + pathInfo;
        }
        if (this.path.isDirectory(pathInfo, req, app) && !uriPwd.endsWith("/")) {
            uriPwd = uriPwd + "/";
        }
        ServletContext rootApp = app.getContext("/");
        ArrayList properties = handler.getProperties();
        boolean isPropname = handler.isPropname();
        if (properties.size() == 0) {
            this.addAllProperties(properties, pathInfo, req, app);
        }
        this.startMultistatus(res);
        PrintWriter out = res.getWriter();
        this.printPathProperties(out, req, app, uriPwd, pathInfo, properties, isPropname, depth);
        out.println("</D:multistatus>");
    }

    private void handleProppatch(HttpServletRequest req, HttpServletResponse res, int depth) throws ServletException, IOException {
        ServletInputStream is = req.getInputStream();
        ProppatchHandler handler = new ProppatchHandler();
        XmlParser parser = new XmlParser();
        parser.setContentHandler(handler);
        try {
            parser.parse((InputStream)is);
        }
        catch (SAXException e) {
            this.sendError(res, 400, "Bad Request for PROPPATCH", "Bad Request: " + e);
            return;
        }
        Application app = (Application)this.getServletContext();
        Path appDir = app.getAppDir();
        String pathInfo = req.getPathInfo();
        String uriPwd = app.getContextPath() + req.getServletPath();
        if (pathInfo == null) {
            pathInfo = "/";
        } else {
            uriPwd = uriPwd + pathInfo;
        }
        if (this.path.isDirectory(pathInfo, req, app) && !uriPwd.endsWith("/")) {
            uriPwd = uriPwd + "/";
        }
        ArrayList forbidden = new ArrayList();
        this.startMultistatus(res);
        PrintWriter out = res.getWriter();
        out.println("<D:response>");
        out.println("<D:href>" + this.escapeXml(uriPwd) + "</D:href>");
        ArrayList properties = new ArrayList();
        ArrayList commands = handler.getCommands();
        for (int i = 0; i < commands.size(); ++i) {
            ProppatchCommand command = (ProppatchCommand)commands.get(i);
            int code = command.getCode();
            AttributeName name = command.getName();
            String value = command.getValue();
            out.println("<D:propstat><D:prop><" + name.getName() + " xmlns:" + name.getPrefix() + "=\"" + name.getNamespace() + "\"/>");
            if (code == ProppatchCommand.SET) {
                this.path.setAttribute(name, value, pathInfo, req, app);
                out.println("<D:status>HTTP/1.1 200 OK</D:status>");
            } else if (code == ProppatchCommand.REMOVE) {
                this.path.removeAttribute(name, pathInfo, req, app);
                out.println("<D:status>HTTP/1.1 200 OK</D:status>");
            } else {
                out.println("<D:status>HTTP/1.1 424 Failed</D:status>");
            }
            out.println("</D:prop></D:propstat>");
        }
        out.println("</D:response>");
        out.println("</D:multistatus>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        OutputStream os;
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if (!this.path.isDirectory(this.getParent(pathInfo), req, app)) {
            this.sendError(res, 409, "Conflict", "PUT requires a parent collection");
            return;
        }
        boolean isCreate = !this.path.exists(pathInfo, req, app);
        try {
            os = this.path.openWrite(pathInfo, req, app);
        }
        catch (IOException e) {
            dbg.log(e);
            this.sendError(res, 403, "Forbidden", "PUT forbidden");
            return;
        }
        WriteStream ws = Vfs.openWrite(os);
        try {
            ServletInputStream is = req.getInputStream();
            ws.writeStream((InputStream)is);
        }
        finally {
            ws.close();
        }
        if (isCreate) {
            res.setStatus(201, "Created");
            res.setHeader("Location", req.getRequestURL().toString());
            PrintWriter out = res.getWriter();
            out.println("<title>Created</h1>");
            out.println("<h1>Created " + req.getRequestURL() + "</h1>");
        } else {
            res.setStatus(204, "No Content");
        }
    }

    private void handleMkcol(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/xml; charset=\"utf-8\"");
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if (this.path.exists(pathInfo, req, app)) {
            res.sendError(405, "Collection already exists");
            return;
        }
        if (!this.path.isDirectory(this.getParent(pathInfo), req, app)) {
            res.sendError(409, "MKCOL needs parent collection");
            return;
        }
        ServletInputStream is = req.getInputStream();
        int ch = is.read();
        if (ch >= 0) {
            res.sendError(415, "MKCOL doesn't understand content-type");
            return;
        }
        if (!this.path.mkdir(pathInfo, req, app)) {
            res.sendError(403, "MKCOL forbidden");
            return;
        }
        res.setHeader("Location", req.getRequestURI());
        this.sendError(res, 201, null, "Created collection " + HTTPUtil.encodeString(req.getRequestURI()));
    }

    private void printCreateProperties(PrintWriter out, HttpServletRequest req, Application app) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String uriPwd = app.getContextPath() + req.getServletPath();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        ArrayList properties = new ArrayList();
        this.addAllProperties(properties, pathInfo, req, app);
        this.printPathProperties(out, req, app, uriPwd, pathInfo, properties, false, 0);
    }

    private void addAllProperties(ArrayList properties, String pathInfo, HttpServletRequest req, Application app) throws IOException, ServletException {
        properties.add(new AttributeName("DAV:", "resourcetype", "D:resourcetype"));
        properties.add(new AttributeName("DAV:", "getcontenttype", "D:getcontenttype"));
        properties.add(new AttributeName("DAV:", "getcontentlength", "D:getcontentlength"));
        properties.add(new AttributeName("DAV:", "creationdate", "D:creationdate"));
        properties.add(new AttributeName("DAV:", "getlastmodified", "D:getlastmodified"));
        Iterator iter = this.path.getAttributeNames(pathInfo, req, app);
        while (iter.hasNext()) {
            AttributeName name = (AttributeName)iter.next();
            if (properties.contains(name)) continue;
            properties.add(name);
        }
    }

    private void printPathProperties(PrintWriter out, HttpServletRequest req, ServletContext app, String uri, String pathInfo, ArrayList properties, boolean isPropname, int depth) throws IOException, ServletException {
        String qName;
        AttributeName prop;
        int j;
        out.println("<D:response>");
        out.print("<D:href>");
        out.print(this.escapeXml(uri));
        out.println("</D:href>");
        if (!this.path.exists(pathInfo, req, app)) {
            out.println("<D:propstat>");
            out.println("<D:status>HTTP/1.1 404 Not Found</D:status>");
            out.println("</D:propstat>");
            out.println("</D:response>");
            return;
        }
        ArrayList<AttributeName> unknownProperties = new ArrayList<AttributeName>();
        out.println("<D:propstat>");
        out.println("<D:prop>");
        boolean isDirectory = this.path.isDirectory(pathInfo, req, app);
        for (j = 0; j < properties.size(); ++j) {
            prop = (AttributeName)properties.get(j);
            String localName = prop.getLocal();
            String propUri = prop.getNamespace();
            qName = prop.getName();
            String prefix = prop.getPrefix();
            if (isPropname) {
                if (propUri.equals("DAV:")) {
                    out.println("<D:" + localName + "/>");
                    continue;
                }
                if (prefix.equals("D")) {
                    prefix = "caucho-D";
                    qName = "caucho-D:" + localName;
                }
                String nsPrefix = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                out.println("<" + qName + " " + nsPrefix + "=\"" + propUri + "\"/>");
                continue;
            }
            String value = this.path.getAttribute(prop, pathInfo, req, app);
            if (value != null) {
                if (prefix.equals("D")) {
                    prefix = "caucho-D";
                    qName = "caucho-D:" + localName;
                }
                String nsPrefix = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                out.print("<" + qName + " " + nsPrefix + "=\"" + propUri + "\">");
                out.print(value);
                out.println("</" + prop.getName() + ">");
                continue;
            }
            if (!propUri.equals("DAV:")) {
                unknownProperties.add(prop);
                continue;
            }
            if (localName.equals("resourcetype")) {
                if (isDirectory) {
                    out.print("<D:resourcetype>");
                    out.print("<D:collection/>");
                    out.println("</D:resourcetype>");
                    continue;
                }
                out.println("<D:resourcetype/>");
                continue;
            }
            if (localName.equals("getcontentlength")) {
                out.print("<D:getcontentlength>");
                out.print(this.path.getLength(pathInfo, req, app));
                out.println("</D:getcontentlength>");
                continue;
            }
            if (localName.equals("getlastmodified")) {
                out.print("<D:getlastmodified>");
                out.print(QDate.format(this.path.getLastModified(pathInfo, req, app)));
                out.println("</D:getlastmodified>");
                continue;
            }
            if (localName.equals("creationdate")) {
                out.print("<D:creationdate>");
                long time = this.path.getLastModified(pathInfo, req, app);
                out.print(QDate.format(time, "%Y-%m-%dT%H:%M:%SZ"));
                out.println("</D:creationdate>");
                continue;
            }
            if (localName.equals("displayname")) {
                int p;
                out.print("<D:displayname>");
                String name = pathInfo;
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((p = pathInfo.lastIndexOf(47)) > 0 && p < pathInfo.length()) {
                    name = pathInfo.substring(p + 1);
                }
                out.print(this.escapeXml(name));
                out.println("</D:displayname>");
                continue;
            }
            if (localName.equals("getcontenttype")) {
                String mimeType = app.getMimeType(uri);
                if (mimeType != null) {
                    out.print("<D:getcontenttype>");
                    out.print(mimeType);
                    out.println("</D:getcontenttype>");
                    continue;
                }
                out.println("<D:getcontenttype/>");
                continue;
            }
            unknownProperties.add(prop);
        }
        out.println("</D:prop>");
        out.println("<D:status>HTTP/1.1 200 OK</D:status>");
        out.println("</D:propstat>");
        if (unknownProperties.size() != 0) {
            out.println("<D:propstat>");
            out.println("<D:prop>");
            for (j = 0; j < unknownProperties.size(); ++j) {
                prop = (AttributeName)unknownProperties.get(j);
                if (prop.getNamespace().equals("DAV:")) {
                    out.println("<D:" + prop.getLocal() + "/>");
                    continue;
                }
                String prefix = prop.getPrefix();
                qName = prop.getName();
                if (prefix.equals("D")) {
                    prefix = "caucho-D";
                    qName = "caucho-D:" + prop.getLocal();
                }
                String nsPrefix = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                out.println("<" + qName + " " + nsPrefix + "=\"" + prop.getNamespace() + "\"/>");
            }
            out.println("</D:prop>");
            out.println("<D:status>HTTP/1.1 404 Not Found</D:status>");
            out.println("</D:propstat>");
        }
        out.println("</D:response>");
        if (depth > 0 && this.path.isDirectory(pathInfo, req, app)) {
            String[] list = this.path.list(pathInfo, req, app);
            for (int i = 0; i < list.length; ++i) {
                String suburi = uri.endsWith("/") ? uri + list[i] : uri + "/" + list[i];
                String subpath = pathInfo.endsWith("/") ? pathInfo + list[i] : pathInfo + "/" + list[i];
                if (this.path.isDirectory(subpath, req, app)) {
                    suburi = suburi + '/';
                }
                if (!this.path.canRead(subpath, req, app) || list[i].startsWith(".") || list[i].equals("CVS") || list[i].endsWith("~")) continue;
                this.printPathProperties(out, req, app, suburi, subpath, properties, isPropname, depth - 1);
            }
        }
    }

    private void handleDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        String uri = req.getContextPath() + pathInfo;
        if (this.path.isFile(pathInfo, req, app)) {
            if (!this.path.remove(pathInfo, req, app)) {
                res.sendError(403, "Forbidden");
            } else {
                res.setStatus(204, "No Content");
            }
        } else if (this.path.isDirectory(pathInfo, req, app)) {
            PrintWriter out = res.getWriter();
            if (this.deleteRecursive(req, res, out, uri, pathInfo, false)) {
                out.println("<D:status>HTTP/1.0 403 Forbidden</D:status>");
                out.println("</D:response>");
                out.println("</D:multistatus>");
            } else {
                res.setStatus(204, "No Content");
            }
        } else {
            res.sendError(404);
        }
    }

    private boolean deleteRecursive(HttpServletRequest req, HttpServletResponse res, PrintWriter out, String uri, String pathInfo, boolean hasError) throws IOException {
        ServletContext app = this.getServletContext();
        boolean newError = false;
        if (this.path.isDirectory(pathInfo, req, app)) {
            String[] list = this.path.list(pathInfo, req, app);
            for (int i = 0; i < list.length; ++i) {
                try {
                    String suburi = this.lookup(uri, list[i]);
                    String subpath = this.lookup(pathInfo, list[i]);
                    hasError = this.deleteRecursive(req, res, out, suburi, subpath, hasError);
                    continue;
                }
                catch (IOException e) {
                    if (!dbg.canWrite()) continue;
                    dbg.log(e);
                }
            }
            if (!this.path.rmdir(pathInfo, req, app)) {
                newError = true;
            }
        } else if (!this.path.remove(pathInfo, req, app)) {
            newError = true;
        }
        if (newError) {
            if (!hasError) {
                this.startMultistatus(res);
                out.println("<D:response>");
            }
            out.println("<D:href>" + this.escapeXml(uri) + "</D:href>");
            hasError = true;
        }
        return hasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCopy(HttpServletRequest req, HttpServletResponse res, int depth) throws ServletException, IOException {
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if (depth == 1) {
            depth = Integer.MAX_VALUE;
        }
        if (!this.path.exists(pathInfo, req, app)) {
            res.sendError(404);
            return;
        }
        String destURI = this.getDestination(req);
        if (destURI == null) {
            res.sendError(403, "Forbidden");
            return;
        }
        String prefix = req.getContextPath();
        if (req.getServletPath() != null) {
            prefix = prefix + req.getServletPath();
        }
        if (!destURI.startsWith(prefix)) {
            res.sendError(403, "Forbidden");
            return;
        }
        String destPath = destURI.substring(prefix.length());
        if (destPath.equals(pathInfo)) {
            res.sendError(403, "Forbidden");
            return;
        }
        if (destPath.startsWith(pathInfo) && (pathInfo.endsWith("/") || destPath.startsWith(pathInfo + '/'))) {
            res.sendError(403, "Forbidden");
            return;
        }
        if (pathInfo.startsWith(destPath) && (destPath.endsWith("/") || pathInfo.startsWith(destPath + '/'))) {
            res.sendError(403, "Forbidden");
            return;
        }
        String overwrite = req.getHeader("Overwrite");
        if (overwrite == null) {
            overwrite = "T";
        }
        if (!this.path.exists(destPath, req, app)) {
            res.setStatus(201);
        } else if (!overwrite.equals("F")) {
            this.removeRecursive(destPath, req);
            res.setStatus(204, "No Content");
        } else {
            res.sendError(412, "Overwrite not allowed for COPY");
            return;
        }
        if (!this.path.exists(this.getParent(destPath), req, app)) {
            res.sendError(409, "COPY needs parent of destination");
            return;
        }
        if (this.path.isFile(pathInfo, req, app)) {
            OutputStream os = this.path.openWrite(destPath, req, app);
            WriteStream ws = Vfs.openWrite(os);
            try {
                InputStream is = this.path.openRead(pathInfo, req, app);
                try {
                    ws.writeStream(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                ws.close();
            }
            return;
        }
        this.copyRecursive(pathInfo, destPath, depth, req);
    }

    private void removeRecursive(String pathInfo, HttpServletRequest req) throws IOException {
        ServletContext app = this.getServletContext();
        if (this.path.isDirectory(pathInfo, req, app)) {
            String[] list = this.path.list(pathInfo, req, app);
            for (int i = 0; i < list.length; ++i) {
                try {
                    this.removeRecursive(this.lookup(pathInfo, list[i]), req);
                    continue;
                }
                catch (IOException e) {
                    dbg.log(e);
                }
            }
        }
        this.path.remove(pathInfo, req, app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRecursive(String srcPath, String destPath, int depth, HttpServletRequest req) throws IOException {
        ServletContext app = this.getServletContext();
        if (this.path.isDirectory(srcPath, req, app)) {
            this.path.mkdir(destPath, req, app);
            if (depth == 0) {
                return;
            }
            String[] list = this.path.list(srcPath, req, app);
            for (int i = 0; i < list.length; ++i) {
                try {
                    this.copyRecursive(this.lookup(srcPath, list[i]), this.lookup(destPath, list[i]), depth - 1, req);
                    continue;
                }
                catch (IOException e) {
                    dbg.log(e);
                }
            }
        } else {
            OutputStream os = this.path.openWrite(destPath, req, app);
            WriteStream ws = Vfs.openWrite(os);
            try {
                InputStream is = this.path.openRead(srcPath, req, app);
                try {
                    ws.writeStream(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                ws.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMove(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        int depth = Integer.MAX_VALUE;
        if (!this.path.exists(pathInfo, req, app)) {
            res.sendError(404);
            return;
        }
        String destURI = this.getDestination(req);
        if (destURI == null) {
            res.sendError(403, "Forbidden");
            return;
        }
        String prefix = req.getContextPath();
        if (req.getServletPath() != null) {
            prefix = prefix + req.getServletPath();
        }
        if (!destURI.startsWith(prefix)) {
            res.sendError(403, "Forbidden");
            return;
        }
        String destPath = destURI.substring(prefix.length());
        if (destPath.equals(pathInfo)) {
            res.sendError(403, "Forbidden");
            return;
        }
        if (destPath.startsWith(pathInfo) && (pathInfo.endsWith("/") || destPath.startsWith(pathInfo + '/'))) {
            res.sendError(403, "Forbidden");
            return;
        }
        if (pathInfo.startsWith(destPath) && (destPath.endsWith("/") || pathInfo.startsWith(destPath + '/'))) {
            res.sendError(403, "Forbidden");
            return;
        }
        String overwrite = req.getHeader("Overwrite");
        if (overwrite == null) {
            overwrite = "T";
        }
        if (!this.path.exists(destPath, req, app)) {
            res.setStatus(201);
        } else if (!overwrite.equals("F")) {
            this.removeRecursive(destPath, req);
            res.setStatus(204, "No Content");
        } else {
            res.sendError(412, "Overwrite not allowed for MOVE");
            return;
        }
        if (!this.path.exists(this.getParent(destPath), req, app)) {
            res.sendError(409, "MOVE needs parent of destination");
            return;
        }
        if (this.path.isFile(pathInfo, req, app)) {
            HashMap props = this.getProperties(pathInfo, req, app);
            OutputStream os = this.path.openWrite(destPath, req, app);
            WriteStream ws = Vfs.openWrite(os);
            try {
                InputStream is = this.path.openRead(pathInfo, req, app);
                try {
                    ws.writeStream(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                ws.close();
            }
            this.setProperties(props, destPath, req, app);
            this.path.remove(pathInfo, req, app);
            return;
        }
        this.moveRecursive(pathInfo, destPath, req);
        res.setStatus(204, "No Content");
    }

    private String getDestination(HttpServletRequest request) {
        String dest = request.getHeader("Destination");
        if ((dest = URLDecoder.decode(dest)).startsWith("/")) {
            return dest;
        }
        String prefix = request.getScheme() + "://";
        String host = request.getHeader("Host");
        if (host != null) {
            prefix = prefix + host.toLowerCase();
        }
        if (dest.startsWith(prefix)) {
            return dest.substring(prefix.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveRecursive(String srcPath, String destPath, HttpServletRequest req) throws IOException {
        ServletContext app = this.getServletContext();
        if (this.path.isDirectory(srcPath, req, app)) {
            this.path.mkdir(destPath, req, app);
            String[] list = this.path.list(srcPath, req, app);
            for (int i = 0; i < list.length; ++i) {
                try {
                    this.moveRecursive(this.lookup(srcPath, list[i]), this.lookup(destPath, list[i]), req);
                    continue;
                }
                catch (IOException e) {
                    dbg.log(e);
                }
            }
            this.path.remove(srcPath, req, app);
        } else {
            HashMap props = this.getProperties(srcPath, req, app);
            OutputStream os = this.path.openWrite(destPath, req, app);
            WriteStream rs = Vfs.openWrite(os);
            try {
                InputStream is = this.path.openRead(srcPath, req, app);
                try {
                    rs.writeStream(is);
                }
                finally {
                    is.close();
                }
            }
            finally {
                rs.close();
                os.close();
            }
            this.setProperties(props, destPath, req, app);
            this.path.remove(srcPath, req, app);
        }
    }

    private HashMap getProperties(String pathInfo, HttpServletRequest req, ServletContext app) throws IOException {
        HashMap<AttributeName, String> properties = null;
        Iterator iter = this.path.getAttributeNames(pathInfo, req, app);
        while (iter.hasNext()) {
            AttributeName name = (AttributeName)iter.next();
            String value = this.path.getAttribute(name, pathInfo, req, app);
            if (properties == null) {
                properties = new HashMap<AttributeName, String>();
            }
            properties.put(name, value);
        }
        return properties;
    }

    private void setProperties(HashMap map, String pathInfo, HttpServletRequest req, ServletContext app) throws IOException {
        if (map == null) {
            return;
        }
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            AttributeName name = (AttributeName)iter.next();
            String value = (String)map.get(name);
            this.path.setAttribute(name, value, pathInfo, req, app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletContext app = this.getServletContext();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        String mimeType = app.getMimeType(pathInfo);
        res.setContentType(mimeType);
        if (!this.path.isFile(pathInfo, req, app) || !this.path.canRead(pathInfo, req, app)) {
            res.sendError(404);
            return;
        }
        long length = this.path.getLength(pathInfo, req, app);
        res.setContentLength((int)length);
        res.setDateHeader("Last-Modified", this.path.getLastModified(pathInfo, req, app));
        if (req.getMethod().equals("HEAD")) {
            return;
        }
        ServletOutputStream os = res.getOutputStream();
        InputStream is = this.path.openRead(pathInfo, req, app);
        ReadStream rs = Vfs.openRead(is);
        try {
            rs.writeToStream((OutputStream)os);
        }
        finally {
            rs.close();
        }
    }

    protected void startMultistatus(HttpServletResponse res) throws IOException {
        res.setStatus(207, "Multistatus");
        res.setContentType("text/xml; charset=\"utf-8\"");
        PrintWriter out = res.getWriter();
        out.println("<?xml version=\"1.0\"?>");
        out.println("<D:multistatus xmlns:D=\"DAV:\">");
    }

    protected void sendError(HttpServletResponse res, int status, String statusText, String message) throws IOException {
        if (statusText == null) {
            res.setStatus(status);
        } else {
            res.setStatus(status, statusText);
        }
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        if (statusText != null) {
            out.print("<title>");
            out.print(statusText);
            out.println("</title>");
            out.print("<h1>");
            out.print(statusText);
            out.println("</h1>");
            out.println(message);
        } else {
            out.print("<title>");
            out.print(message);
            out.println("</title>");
            out.print("<h1>");
            out.print(message);
            out.println("</h1>");
        }
    }

    private void handleDirectory(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException, ServletException {
        ServletContext app = this.getServletContext();
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.println("<title>Directory of " + pathInfo + "</title>");
        out.println("<h1>Directory of " + pathInfo + "</h1>");
        String[] list = this.path.list(pathInfo, req, app);
        for (int i = 0; i < list.length; ++i) {
            out.println("<a href=\"" + list[i] + "\">" + list[i] + "</a><br>");
        }
    }

    private String escapeXml(String data) {
        CharBuffer cb = CharBuffer.allocate();
        block5: for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            switch (ch) {
                case '<': {
                    cb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    cb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    cb.append("&amp;");
                    continue block5;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.close();
    }

    protected String getParent(String pathInfo) {
        int p = pathInfo.lastIndexOf(47, pathInfo.length() - 2);
        if (p < 0) {
            return "/";
        }
        return pathInfo.substring(0, p);
    }

    protected String lookup(String parent, String child) {
        if (parent.endsWith("/")) {
            return parent + child;
        }
        return parent + '/' + child;
    }

    public void destroy() {
        this.path.destroy();
    }

    static class ProppatchCommand {
        public static int SET = 0;
        public static int REMOVE = 1;
        public static int CHANGE = 2;
        private int code;
        private AttributeName name;
        private String value;

        ProppatchCommand(int code, AttributeName name, String value) {
            this.code = code;
            this.name = name;
            this.value = value;
        }

        int getCode() {
            return this.code;
        }

        AttributeName getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }
    }

    static class ProppatchHandler
    extends DefaultHandler {
        ArrayList commands = new ArrayList();
        boolean inProp;
        boolean inSet;
        boolean inRemove;
        boolean isPropname;
        AttributeName attributeName;
        CharBuffer value;

        ProppatchHandler() {
        }

        boolean isPropname() {
            return this.isPropname;
        }

        ArrayList getCommands() {
            return this.commands;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("set")) {
                this.inSet = true;
            } else if (localName.equals("remove")) {
                this.inRemove = true;
            } else if (localName.equals("prop")) {
                this.inProp = true;
            } else if (localName.equals("propname")) {
                this.isPropname = true;
            } else if (this.inProp) {
                if (this.attributeName == null) {
                    this.attributeName = new AttributeName(uri, localName, qName);
                    this.value = CharBuffer.allocate();
                } else {
                    int p = qName.indexOf(58);
                    if (p > 0) {
                        this.value.append("<" + qName + " xmlns:" + qName.substring(p + 1) + "=\"" + uri + "\">");
                    } else {
                        this.value.append("<" + qName + " xmlns=\"" + uri + "\">");
                    }
                }
            }
        }

        public void characters(char[] buffer, int offset, int length) {
            if (this.value != null) {
                this.value.append(buffer, offset, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("prop")) {
                this.inProp = false;
            } else if (localName.equals("set")) {
                this.inSet = false;
            } else if (localName.equals("remove")) {
                this.inRemove = false;
            } else if (this.attributeName != null) {
                if (localName.equals(this.attributeName.getLocal()) && uri.equals(this.attributeName.getNamespace())) {
                    if (this.inSet) {
                        this.commands.add(new ProppatchCommand(ProppatchCommand.SET, this.attributeName, this.value.close()));
                    } else if (this.inRemove) {
                        this.commands.add(new ProppatchCommand(ProppatchCommand.REMOVE, this.attributeName, this.value.close()));
                    }
                    this.value = null;
                    this.attributeName = null;
                } else {
                    this.value.append("</" + qName + ">");
                }
            }
        }
    }

    static class PropfindHandler
    extends DefaultHandler {
        ArrayList properties = new ArrayList();
        boolean inProp;
        boolean isPropname;

        PropfindHandler() {
        }

        ArrayList getProperties() {
            return this.properties;
        }

        boolean isPropname() {
            return this.isPropname;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("prop")) {
                this.inProp = true;
            } else if (localName.equals("propname")) {
                this.isPropname = true;
            } else if (this.inProp) {
                if (qName.indexOf(58) > 0 && uri.equals("")) {
                    throw new SAXException("illegal empty namespace");
                }
                this.properties.add(new AttributeName(uri, localName, qName));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("prop")) {
                this.inProp = false;
            }
        }
    }
}

