/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.ErrorParser;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavaCompiler;
import com.caucho.java.JavacErrorParser;
import com.caucho.java.LineMap;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ExternalCompiler
extends JavaCompiler
implements AlarmListener {
    Process process;
    String userPrefix;
    boolean isDead;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileInt(String path, LineMap lineMap) throws IOException {
        InputStream errorStream;
        MemoryStream tempStream;
        block36: {
            tempStream = new MemoryStream();
            WriteStream error = new WriteStream(tempStream);
            InputStream inputStream = null;
            errorStream = null;
            boolean chdir = CauchoSystem.isUnix();
            this.process = null;
            try {
                int status;
                ArrayList<String> argList;
                Path classFile;
                String className;
                block35: {
                    String javac = this.getCompiler();
                    Path javaPath = this.getSourceDir().lookup(path);
                    className = path.substring(0, path.length() - ".java".length());
                    classFile = this.getClassDir().lookup(className + ".class");
                    String parent = Vfs.lookupNative(path).getParent().getNativePath();
                    argList = new ArrayList<String>();
                    argList.add(javac);
                    for (int i = 0; this.args != null && i < this.args.size(); ++i) {
                        argList.add((String)this.args.get(i));
                    }
                    if (javac.endsWith("jikes") || javac.endsWith("jikes.exe")) {
                        argList.add("+E");
                        chdir = false;
                        if (this.charEncoding != null) {
                            String encoding = Encoding.getJavaName(this.charEncoding);
                            argList.add("-encoding");
                            argList.add(encoding);
                        }
                    } else if (this.charEncoding != null) {
                        String encoding = Encoding.getJavaName(this.charEncoding);
                        argList.add("-encoding");
                        argList.add(encoding);
                    }
                    argList.add("-classpath");
                    argList.add(this.normalizeClassPath(this.getClassPath(), !chdir));
                    argList.add("-d");
                    argList.add(this.normalizePath(this.getClassDirName(), !chdir));
                    if (chdir) {
                        argList.add(path);
                    } else {
                        argList.add(javaPath.getNativePath());
                    }
                    this.process = this.executeCompiler(argList, chdir);
                    if (this.process != null) {
                        inputStream = this.process.getInputStream();
                        errorStream = this.process.getErrorStream();
                    }
                    Alarm alarm = null;
                    if (this.maxCompileTime > 1000L) {
                        alarm = new Alarm(this, this.maxCompileTime);
                    }
                    status = 666;
                    try {
                        this.waitForErrors(error, inputStream, errorStream);
                        if (this.process != null) {
                            status = this.process.waitFor();
                            this.process = null;
                        }
                    }
                    catch (Throwable e) {
                        if (this.isDead) {
                            throw new JavaCompileException(L.l("The compilation has timed out.  You can increase the timeout value by changing the max-compile-time."));
                        }
                        throw new IOExceptionWrapper(e);
                    }
                    finally {
                        if (alarm != null) {
                            alarm.dequeue();
                        }
                    }
                    if (this.process != null) {
                        status = 666;
                        try {
                            this.process.destroy();
                        }
                        catch (Throwable e) {
                            if (!dbg.canWrite()) break block35;
                            dbg.log(e);
                        }
                    }
                }
                if (status != 0 || classFile.getLength() <= 0L) {
                    ReadStream read;
                    error.close();
                    tempStream.close();
                    if (dbg.canWrite()) {
                        read = tempStream.openRead();
                        dbg.writeStream(read);
                        read.close();
                        dbg.flush();
                    }
                    read = tempStream.openRead();
                    JavacErrorParser parser = new JavacErrorParser();
                    String errors = ((ErrorParser)parser).parseErrors(read, lineMap);
                    read.close();
                    if (errors == null || errors.equals("")) {
                        int ch;
                        CharBuffer cb = new CharBuffer();
                        if (status == 0) {
                            cb.append("Compilation for '" + className + "' did not generate a .class file.\n");
                            cb.append("Make sure the `package' matches the directory.\n");
                        } else {
                            cb.append("Unknown compiler error executing:\n");
                        }
                        for (int i = 0; i < argList.size(); ++i) {
                            cb.append(" " + argList.get(i) + "\n");
                        }
                        read = tempStream.openRead();
                        while ((ch = read.read()) >= 0) {
                            cb.append((char)ch);
                        }
                        read.close();
                        errors = cb.toString();
                    } else if (errors.indexOf("command not found") >= 0) {
                        throw new JavaCompileException(L.l("Resin can't execute the compiler `{0}'.  This usually means that the compiler is not in the operating system's PATH or the compiler is incorrectly specified in the configuration.  You may need to add the full path to <java compiler='{0}'/>.\n\n{1}", argList.get(0), errors));
                    }
                    throw new JavaCompileException(errors);
                }
                Object var22_27 = null;
                if (inputStream == null) break block36;
            }
            catch (Throwable throwable) {
                Object var22_28 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (errorStream != null) {
                    errorStream.close();
                }
                tempStream.destroy();
                throw throwable;
            }
            inputStream.close();
        }
        if (errorStream != null) {
            errorStream.close();
        }
        tempStream.destroy();
    }

    private void waitForErrors(WriteStream error, InputStream inputStream, InputStream errorStream) throws IOException {
        byte[] buffer = new byte[256];
        if (inputStream == null || errorStream == null) {
            return;
        }
        while (true) {
            int stdoutLen;
            int stderrLen;
            if ((stderrLen = errorStream.available()) > 0 && (stderrLen = errorStream.read(buffer, 0, buffer.length)) > 0) {
                error.write(buffer, 0, stderrLen);
                continue;
            }
            while ((stdoutLen = inputStream.available()) > 0 && (stdoutLen = inputStream.read(buffer, 0, buffer.length)) > 0) {
                error.write(buffer, 0, stdoutLen);
            }
            if (stderrLen < 0 && stdoutLen < 0) {
                return;
            }
            if (stderrLen == 0 && (stderrLen = errorStream.read(buffer, 0, buffer.length)) > 0) {
                error.write(buffer, 0, stderrLen);
            }
            if (stderrLen < 0 && stdoutLen == 0 && (stdoutLen = inputStream.read(buffer, 0, buffer.length)) > 0) {
                error.write(buffer, 0, stdoutLen);
            }
            if (this.isDead || stderrLen < 0 && stdoutLen < 0) break;
        }
    }

    public void handleAlarm(Alarm alarm) {
        this.isDead = true;
        if (this.process != null) {
            try {
                this.process.destroy();
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
    }

    private Process executeCompiler(ArrayList argList, boolean chdir) throws IOException {
        String[] args;
        if (chdir) {
            CharBuffer cb = new CharBuffer();
            cb.append("cd ");
            cb.append(this.getSourceDirName());
            cb.append(";");
            for (int i = 0; i < argList.size(); ++i) {
                cb.append(" ");
                cb.append(argList.get(i));
            }
            args = new String[]{"/bin/sh", "-c", cb.toString()};
        } else {
            args = new String[argList.size()];
            argList.toArray(args);
        }
        if (dbg.canWrite()) {
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    dbg.print(" ");
                }
                dbg.print(args[i]);
            }
            dbg.println();
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            return runtime.exec(args);
        }
        catch (Exception e) {
            throw new JavaCompileException(L.l("Resin can't execute the compiler `{0}'.  This usually means that the compiler is not in the operating system's PATH or the compiler is incorrectly specified in the configuration.  You may need to add the full path to <java compiler='{0}'/>.\n\n{1}", (Object)args[0], String.valueOf(e)));
        }
    }

    String normalizeClassPath(String classPath, boolean generateRelative) {
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        CharBuffer cb = CharBuffer.allocate();
        while (head < classPath.length()) {
            tail = classPath.indexOf(sep, head);
            if (tail < 0) {
                tail = classPath.length();
            }
            if (tail > head) {
                String segment = classPath.substring(head, tail);
                if (cb.length() != 0) {
                    cb.append(sep);
                }
                cb.append(this.normalizePath(segment, generateRelative));
            }
            head = tail + 1;
        }
        return cb.close();
    }

    String normalizePath(String segment, boolean generateRelative) {
        if (this.userPrefix == null) {
            Path userPath = Vfs.lookup(CauchoSystem.getUserDir());
            char sep = CauchoSystem.getFileSeparatorChar();
            this.userPrefix = userPath.getNativePath();
            if (this.userPrefix.length() == 0 || this.userPrefix.charAt(this.userPrefix.length() - 1) != sep) {
                this.userPrefix = this.userPrefix + sep;
            }
        }
        Path path = Vfs.lookup(segment);
        String nativePath = path.getNativePath();
        if (!generateRelative) {
            return nativePath;
        }
        if (nativePath.startsWith(this.userPrefix)) {
            nativePath = nativePath.substring(this.userPrefix.length());
        }
        if (nativePath.equals("")) {
            return ".";
        }
        return nativePath;
    }
}

