/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.http.security.AbstractLogin;
import com.caucho.http.session.SessionImpl;
import com.caucho.http.session.SessionManager;
import com.caucho.security.SecurityContext;
import com.caucho.security.SecurityContextProvider;
import com.caucho.server.http.Application;
import com.caucho.server.http.CacheInvocation;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.Response;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public abstract class AbstractRequest
implements CauchoRequest,
SecurityContextProvider {
    static WriteStream dbg = LogStream.open("/caucho.com/http/invocation");
    static WriteStream dbgAuth = LogStream.open("/caucho.com/http/auth");
    static L10N L = new L10N(class$com$caucho$server$http$AbstractRequest == null ? (class$com$caucho$server$http$AbstractRequest = AbstractRequest.class$("com.caucho.server.http.AbstractRequest")) : class$com$caucho$server$http$AbstractRequest);
    public static String REQUEST_URI = "javax.servlet.include.request_uri";
    public static String CONTEXT_PATH = "javax.servlet.include.context_path";
    public static String SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static String PATH_INFO = "javax.servlet.include.path_info";
    public static String QUERY_STRING = "javax.servlet.include.query_string";
    public static String STATUS_CODE = "javax.servlet.error.status_code";
    public static String EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static String MESSAGE = "javax.servlet.error.message";
    public static String EXCEPTION = "javax.servlet.error.exception";
    public static String ERROR_URI = "javax.servlet.error.request_uri";
    public static String SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static String JSP_EXCEPTION = "javax.servlet.jsp.jspException";
    public static String SHUTDOWN = "com.caucho.shutdown";
    protected QDate calendar;
    protected Invocation invocation;
    protected CacheInvocation cache;
    private boolean varyCookies;
    private String varyCookie;
    private boolean hasCookie;
    private boolean isCaching;
    private Principal userPrincipal;
    static /* synthetic */ Class class$com$caucho$server$http$AbstractRequest;

    void init() {
        SecurityContext.setProvider(this);
    }

    void start() {
        this.invocation = null;
        this.cache = null;
        this.varyCookies = false;
        this.varyCookie = null;
        this.hasCookie = false;
        this.isCaching = false;
        this.userPrincipal = null;
    }

    protected abstract CauchoResponse getResponse();

    public abstract ReadStream getStream() throws IOException;

    public int getRequestDepth(int depth) {
        return depth + 1;
    }

    public abstract long getDate();

    public abstract ServletInputStream getInputStream() throws IOException;

    public abstract BufferedReader getReader() throws IOException;

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract String getRemoteAddr();

    public abstract String getRemoteHost();

    public abstract String getScheme();

    public CharSegment getMethodBuffer() {
        CharBuffer cb = new CharBuffer();
        cb.append(this.getMethod());
        return cb;
    }

    public abstract String getMethod();

    public abstract String getProtocol();

    public abstract String getRequestURI();

    public String getPageURI() {
        String uri = (String)this.getAttribute(REQUEST_URI);
        if (uri != null) {
            return uri;
        }
        return this.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        if (this.getServerPort() > 0 && this.getServerPort() != 80 && this.getServerPort() != 443) {
            sb.append(":");
            sb.append(this.getServerPort());
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    public abstract String getContextPath();

    public String getPageContextPath() {
        String uri = (String)this.getAttribute(REQUEST_URI);
        if (uri != null) {
            return (String)this.getAttribute(CONTEXT_PATH);
        }
        return this.getContextPath();
    }

    public abstract String getServletPath();

    public String getPageServletPath() {
        String uri = (String)this.getAttribute(REQUEST_URI);
        if (uri != null) {
            return (String)this.getAttribute(SERVLET_PATH);
        }
        return this.getServletPath();
    }

    public abstract String getPathInfo();

    public String getPagePathInfo() {
        String uri = (String)this.getAttribute(REQUEST_URI);
        if (uri != null) {
            return (String)this.getAttribute(PATH_INFO);
        }
        return this.getPathInfo();
    }

    public abstract String getQueryString();

    public String getPageQueryString() {
        String uri = (String)this.getAttribute(REQUEST_URI);
        if (uri != null) {
            return (String)this.getAttribute(QUERY_STRING);
        }
        return this.getQueryString();
    }

    public abstract int getContentLength();

    public abstract String getContentType();

    public abstract String getCharacterEncoding();

    public abstract String getHeader(String var1);

    public void setHeader(String key, String value) {
    }

    void setInvocation(Invocation invocation) {
        this.invocation = invocation;
    }

    Invocation getInvocation() {
        return this.invocation;
    }

    Application getApplication() {
        if (this.invocation != null) {
            return this.invocation.getApplication();
        }
        return null;
    }

    public CauchoApplication getCauchoApplication() {
        return this.getApplication();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIntHeader(String key) {
        String value = this.getHeader(key);
        if (value == null) {
            return -1;
        }
        int len = value.length();
        if (len == 0) {
            throw new NumberFormatException(value);
        }
        int iValue = 0;
        int i = 0;
        char ch = value.charAt(i);
        int sign = 1;
        if (ch == '+') {
            if (i + 1 >= len) throw new NumberFormatException(value);
            ch = value.charAt(++i);
        } else if (ch == '-') {
            sign = -1;
            if (i + 1 >= len) throw new NumberFormatException(value);
            ch = value.charAt(++i);
        }
        while (i < len && (ch = value.charAt(i)) >= '0' && ch <= '9') {
            iValue = 10 * iValue + ch - 48;
            ++i;
        }
        if (i >= len) return sign * iValue;
        throw new NumberFormatException(value);
    }

    public long getDateHeader(String key) {
        String value = this.getHeader(key);
        if (value == null) {
            return -1L;
        }
        long date = -1L;
        try {
            if (this.calendar == null) {
                this.calendar = new QDate();
            }
            date = this.calendar.parseDate(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (date == Long.MAX_VALUE) {
            throw new IllegalArgumentException(value);
        }
        return date;
    }

    protected void setVaryCookie(String cookie) {
        if (!this.varyCookies) {
            this.varyCookie = cookie;
        } else if (this.varyCookie != null && !this.varyCookie.equals(cookie)) {
            this.varyCookie = null;
        }
        this.varyCookies = true;
    }

    boolean getVaryCookies() {
        return this.varyCookies;
    }

    String getVaryCookie() {
        return this.varyCookie;
    }

    protected void setHasCookie() {
        this.hasCookie = true;
    }

    boolean getHasCookie() {
        return this.hasCookie;
    }

    public abstract HttpSession getSession(boolean var1);

    public HttpSession getSession() {
        return this.getSession(true);
    }

    protected SessionImpl createSession(boolean create, boolean hasOldSession) {
        SessionImpl session;
        Application application = this.getApplication();
        SessionManager manager = application.getSessionManager();
        String id = this.getRequestedSessionId();
        long now = Alarm.getCurrentTime();
        if (id != null && id.length() > 6) {
            session = manager.getSession(id, now, create);
            if (session != null && session.isValid()) {
                if (session != null) {
                    this.setHasCookie();
                }
                if (!session.getId().equals(id) && manager.enableSessionCookies()) {
                    this.getResponse().setSessionId(session.getId());
                }
                return session;
            }
        } else {
            id = null;
        }
        if (!create) {
            return null;
        }
        session = manager.createSession(id, now, this.getSessionGroup(), this);
        if (session != null) {
            this.setHasCookie();
        }
        if (session.getId().equals(id)) {
            return session;
        }
        if (manager.enableSessionCookies()) {
            this.getResponse().setSessionId(session.getId());
        }
        return session;
    }

    public abstract int getSessionGroup();

    public abstract String getRequestedSessionId();

    public abstract boolean isRequestedSessionIdValid();

    public abstract boolean isRequestedSessionIdFromCookie();

    public abstract boolean isRequestedSessionIdFromURL();

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public abstract Enumeration getHeaderNames();

    public abstract Enumeration getAttributeNames();

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public abstract void removeAttribute(String var1);

    public abstract Enumeration getParameterNames();

    public abstract String[] getParameterValues(String var1);

    public abstract String getParameter(String var1);

    public abstract Cookie[] getCookies();

    public abstract Cookie getCookie(String var1);

    public abstract String getRealPath(String var1);

    public abstract String getPathTranslated();

    public abstract Enumeration getHeaders(String var1);

    public abstract Locale getLocale();

    public abstract Enumeration getLocales();

    public abstract boolean isSecure();

    protected void finish() throws IOException {
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        int p;
        String pathInfo;
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.getCauchoApplication().getRequestDispatcher(path);
        }
        CharBuffer cb = CharBuffer.allocate();
        Application app = this.getApplication();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        cb.append(path);
        if (app == null) {
            return this.getCauchoApplication().getRequestDispatcher(cb.close());
        }
        return app.getRequestDispatcher(cb.close());
    }

    boolean isCacheable() {
        return this.cache != null && this.cache.isCacheable();
    }

    protected boolean isTop() {
        return false;
    }

    protected boolean checkLogin() {
        return false;
    }

    public String getChain(String contentType) {
        return this.getApplication().getChain(contentType);
    }

    public String getMedia() {
        Application app = this.getApplication();
        if (app == null) {
            return null;
        }
        return app.getMedia(this);
    }

    public String getAuthType() {
        Application app = this.getApplication();
        if (app != null) {
            return app.getLogin().getAuthType();
        }
        return "none";
    }

    public String getRemoteUser(boolean create) {
        if (this.userPrincipal == null) {
            if (!create) {
                return null;
            }
            this.userPrincipal = this.getUserPrincipal();
        }
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public boolean authenticate() throws ServletException, IOException {
        if (this.userPrincipal != null) {
            return true;
        }
        Application app = this.getApplication();
        if (app == null) {
            throw new ServletException("Expected valid application");
        }
        AbstractLogin login = app.getLogin();
        if (this.getResponse() instanceof Response) {
            ((Response)this.getResponse()).setPrivateCache(true);
        }
        this.userPrincipal = login.authenticate(this, this.getResponse(), app);
        return this.userPrincipal != null;
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    public Principal getUserPrincipal() {
        try {
            if (this.userPrincipal != null) {
                return this.userPrincipal;
            }
            Application app = this.getApplication();
            if (app == null) {
                return null;
            }
            AbstractLogin login = app.getLogin();
            if (login != null) {
                this.userPrincipal = login.getUserPrincipal(this, this.getResponse(), app);
            }
            return this.userPrincipal;
        }
        catch (ServletException e) {
            if (this.getApplication() != null) {
                this.getApplication().log(String.valueOf((Object)e), e);
            }
            dbg.log(e);
            return null;
        }
    }

    public void logout() {
        this.userPrincipal = null;
    }

    public void logoutUserPrincipal() {
        this.userPrincipal = null;
    }

    public boolean isUserInRole(String role) {
        Principal user;
        boolean inRole;
        block9: {
            AbstractLogin login;
            Application app = this.getApplication();
            AbstractLogin abstractLogin = login = app == null ? null : app.getLogin();
            if (login == null) {
                return false;
            }
            inRole = false;
            user = this.getUserPrincipal();
            try {
                inRole = login.isUserInRole(this, this.getResponse(), app, user, role);
            }
            catch (ServletException e) {
                if (app != null) {
                    app.log(String.valueOf((Object)e), e);
                }
                if (!dbgAuth.canWrite()) break block9;
                dbgAuth.log(e);
            }
        }
        if (dbgAuth.canWrite()) {
            if (user == null) {
                dbgAuth.log("no user for isUserInRole");
            } else if (inRole) {
                dbgAuth.log(user + " is in role: " + role);
            } else {
                dbgAuth.log("failed " + user + " in role: " + role);
            }
        }
        return inRole;
    }

    protected void free() {
        this.invocation = null;
        this.cache = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

