/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.server.http.JniRequest;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.util.Alarm;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.http.Cookie;

class JniResponse
extends Response {
    static byte[] httpok = "200 OK".getBytes();
    static byte[] contentLengthBytes = "\nContent-Length:".getBytes();
    static byte[] contentTypeBytes = "\nContent-Type:".getBytes();
    static byte[] textHtmlBytes = "\nContent-Type:text/html".getBytes();
    static byte[] resinServerBytes = ("\nServer:Resin/" + Version.VERSION).getBytes();
    static byte[] lflf = "\n\n".getBytes();
    JniRequest req;
    private WriteStream writeStream;

    JniResponse(Request request) {
        super(request);
        this.req = (JniRequest)request;
    }

    boolean allowKeepalive() {
        return false;
    }

    protected boolean writeHeadersInt(WriteStream os, int length) throws IOException {
        if (this.statusCode == 200) {
            os.write(httpok, 0, httpok.length);
        } else {
            os.write(this.statusCode / 100 % 10 + 48);
            os.write(this.statusCode / 10 % 10 + 48);
            os.write(this.statusCode % 10 + 48);
            os.write(32);
            os.print(this.statusMessage);
        }
        os.write(resinServerBytes, 0, resinServerBytes.length);
        if (this.isNoCache) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            os.print("\nCache-Control: no-cache");
        } else if (this.isPrivateCache()) {
            os.print("\nCache-Control:private");
        }
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            String key = (String)this.headerKeys.get(i);
            os.write(10);
            os.print(key);
            os.write(58);
            os.print((String)this.headerValues.get(i));
            if (!dbg.canWrite()) continue;
            dbg.log(key + ": " + this.headerValues.get(i));
        }
        long date = Alarm.getCurrentTime();
        for (int i = 0; i < this.cookiesOut.size(); ++i) {
            Cookie cookie = (Cookie)this.cookiesOut.get(i);
            int version = cookie.getVersion();
            this.fillCookie(this.cb, cookie, date, 0);
            os.print("\nSet-Cookie:");
            os.print(this.cb.getBuffer(), 0, this.cb.getLength());
            if (version > 0) {
                this.fillCookie(this.cb, cookie, date, 0);
                os.print("\nSet-Cookie2:");
                os.print(this.cb.getBuffer(), 0, this.cb.getLength());
            }
            if (!dbg.canWrite()) continue;
            dbg.log("Set-Cookie: " + this.cb);
        }
        if (this.contentType == "text/html" && this.charEncoding == null) {
            os.write(textHtmlBytes, 0, textHtmlBytes.length);
        } else if (this.contentType != null) {
            os.write(contentTypeBytes, 0, contentTypeBytes.length);
            os.print(this.contentType);
            if (dbg.canWrite()) {
                dbg.log("\nContent-Type: " + this.contentType);
            }
        }
        boolean hasContentLength = false;
        if (this.contentLength >= 0L) {
            os.write(contentLengthBytes, 0, contentLengthBytes.length);
            os.print(this.contentLength);
        } else if (length >= 0) {
            os.write(contentLengthBytes, 0, contentLengthBytes.length);
            os.print(length);
        }
        os.print("\n\n");
        return false;
    }
}

