/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Request;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MultipartStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;

class MultipartForm {
    static WriteStream dbg = LogStream.open("/caucho.com/http/form");
    static L10N L = new L10N(class$com$caucho$server$http$MultipartForm == null ? (class$com$caucho$server$http$MultipartForm = MultipartForm.class$("com.caucho.server.http.MultipartForm")) : class$com$caucho$server$http$MultipartForm);
    static /* synthetic */ Class class$com$caucho$server$http$MultipartForm;

    MultipartForm() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parsePostData(HashMap table, ReadStream rawIs, String boundary, Request request, String javaEncoding, long uploadMax) throws IOException {
        ReadStream is;
        MultipartStream ms = new MultipartStream(rawIs, boundary);
        ms.setEncoding(javaEncoding);
        while ((is = ms.openRead()) != null) {
            String attr = (String)ms.getAttribute("content-disposition");
            if (attr == null || !attr.startsWith("form-data")) continue;
            String name = MultipartForm.getAttribute(attr, "name");
            String filename = MultipartForm.getAttribute(attr, "filename");
            if (name == null) continue;
            if (filename != null) {
                String contentType = (String)ms.getAttribute("content-type");
                Path tempDir = request.getApplication().getTempDir();
                try {
                    tempDir.mkdirs();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Path tempFile = tempDir.createTempFile("form", ".tmp");
                request.addCloseOnExit(tempFile);
                WriteStream os = tempFile.openWrite();
                try {
                    os.writeStream(is);
                }
                finally {
                    os.close();
                }
                if (uploadMax > 0L && tempFile.getLength() > uploadMax) {
                    String msg = L.l("multipart form data `{0}' too large", "" + tempFile.getLength());
                    tempFile.remove();
                    throw new IOException(msg);
                }
                MultipartForm.addTable(table, name, tempFile.getNativePath());
                MultipartForm.addTable(table, name + ".file", tempFile.getNativePath());
                MultipartForm.addTable(table, name + ".filename", filename);
                MultipartForm.addTable(table, name + ".content-type", contentType);
                if (!dbg.canWrite()) continue;
                dbg.log("mp-file: " + name + "(filename:" + filename + ")");
                continue;
            }
            CharBuffer value = CharBuffer.allocate();
            int ch = is.readChar();
            while (ch >= 0) {
                value.append((char)ch);
                ch = is.readChar();
            }
            if (dbg.canWrite()) {
                dbg.log("mp-form: " + name + "=" + value);
            }
            MultipartForm.addTable(table, name, value.close());
        }
        if (!ms.isComplete()) {
            throw new IOException("Incomplete form");
        }
    }

    private static void addTable(HashMap table, String name, String value) {
        String[] oldArray = (String[])table.get(name);
        if (oldArray != null) {
            String[] newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
            table.put(name, newArray);
        } else {
            table.put(name, new String[]{value});
        }
    }

    private static String getAttribute(String attr, String name) {
        CharBuffer value;
        block8: {
            char ch;
            int i;
            int length;
            block9: {
                block7: {
                    if (attr == null) {
                        return null;
                    }
                    length = attr.length();
                    i = attr.indexOf(name);
                    if (i < 0) {
                        return null;
                    }
                    i += name.length();
                    while (i < length && attr.charAt(i) != '=') {
                        ++i;
                    }
                    ++i;
                    while (i < length && attr.charAt(i) == ' ') {
                        ++i;
                    }
                    value = CharBuffer.allocate();
                    if (i >= length || attr.charAt(i) != '\'') break block7;
                    ++i;
                    while (i < length && attr.charAt(i) != '\'') {
                        value.append(attr.charAt(i));
                        ++i;
                    }
                    break block8;
                }
                if (i >= length || attr.charAt(i) != '\"') break block9;
                ++i;
                while (i < length && attr.charAt(i) != '\"') {
                    value.append(attr.charAt(i));
                    ++i;
                }
                break block8;
            }
            if (i >= length) break block8;
            while (i < length && (ch = attr.charAt(i)) != ' ' && ch != ';') {
                value.append(ch);
                ++i;
            }
        }
        return value.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

