/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoRequestDispatcher;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ChainRequest;
import com.caucho.server.http.DispatchResponse;
import com.caucho.server.http.Request;
import com.caucho.server.http.RequestAdapter;
import com.caucho.server.http.Response;
import com.caucho.server.http.ResponseAdapter;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class QNamedDispatcher
implements CauchoRequestDispatcher {
    private Application application;
    private FilterChain filterChain;
    private String queryString;

    QNamedDispatcher(FilterChain filterChain, String queryString, Application application) {
        this.filterChain = filterChain;
        this.queryString = queryString;
        this.application = application;
    }

    public void forward(CauchoRequest req, CauchoResponse response, String method) throws ServletException, IOException {
        this.forward((ServletRequest)req, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chain(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        AbstractRequest req = (AbstractRequest)request;
        CauchoResponse res = (CauchoResponse)response;
        ChainRequest subRequest = new ChainRequest();
        subRequest.init(this.application, req, res);
        subRequest.startChaining(res);
        try {
            this.forward((ServletRequest)subRequest, (ServletResponse)res);
        }
        finally {
            subRequest.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest req, ServletResponse res, String method) throws ServletException, IOException {
        String oldMethod = ((HttpServletRequest)req).getMethod();
        if (req instanceof Request) {
            Request request = (Request)req;
            request.setMethod(method);
            try {
                this.include(req, res);
            }
            finally {
                request.setMethod(oldMethod);
            }
        } else {
            this.include(req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ResponseAdapter resAdapt = null;
        if (!(response instanceof CauchoResponse)) {
            resAdapt = ResponseAdapter.create((HttpServletResponse)response);
            response = resAdapt;
        }
        CauchoResponse res = (CauchoResponse)response;
        if (!(request instanceof CauchoRequest)) {
            RequestAdapter adapt = new RequestAdapter();
            adapt.init((HttpServletRequest)request, res, this.application);
            request = adapt;
        }
        AbstractRequest req = (AbstractRequest)request;
        WriteStream s = res.getStream();
        s.setDisableClose(true);
        DispatchResponse subResponse = new DispatchResponse();
        subResponse.setRequest(req);
        subResponse.init(req, s);
        subResponse.start();
        ClassLoader oldLoader = CauchoSystem.getContextClassLoader();
        try {
            this.filterChain.doFilter((ServletRequest)req, (ServletResponse)subResponse);
        }
        finally {
            subResponse.finish(false);
        }
        if (resAdapt != null) {
            resAdapt.close();
        }
    }

    public void forward(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (res instanceof CauchoResponse) {
            ((CauchoResponse)res).clearBuffer();
        } else {
            res.resetBuffer();
        }
        res.setContentLength(-1);
        this.filterChain.doFilter(req, res);
        if (res instanceof Response) {
            ((Response)res).finish(true);
        }
    }
}

