/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.server.http.RunnerRequest;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.http.Cookie;

public class RunnerResponse
extends Response {
    RunnerRequest req;

    RunnerResponse(Request request) {
        super(request);
        this.req = (RunnerRequest)request;
    }

    protected boolean writeHeadersInt(WriteStream os, int length) throws IOException {
        boolean isHead;
        this.cb.clear();
        int version = this.req.getVersion();
        if (version >= 257) {
            this.cb.append("HTTP/1.1 ");
        } else {
            this.cb.append("HTTP/1.0 ");
        }
        this.cb.append((char)(this.statusCode / 100 % 10 + 48));
        this.cb.append((char)(this.statusCode / 10 % 10 + 48));
        this.cb.append((char)(this.statusCode % 10 + 48));
        this.cb.append(' ');
        this.cb.append(this.statusMessage);
        this.req.writeStatus(this.cb);
        if (this.isNoCache) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            this.req.writeHeader("Cache-Control", "no-cache");
        } else if (this.isPrivateCache() && version == 257) {
            this.req.writeHeader("Cache-Control", "private");
        }
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            String key = (String)this.headerKeys.get(i);
            String value = (String)this.headerValues.get(i);
            this.req.writeHeader(key, value);
        }
        if (this.contentLength >= 0L) {
            this.cb.clear();
            this.cb.append(this.contentLength);
            this.req.writeHeader("Content-Length", this.cb);
        } else if (length >= 0) {
            this.cb.clear();
            this.cb.append(length);
            this.req.writeHeader("Content-Length", this.cb);
            this.contentLength = length;
        }
        long date = this.request.getDate();
        for (int i = 0; i < this.cookiesOut.size(); ++i) {
            Cookie cookie = (Cookie)this.cookiesOut.get(i);
            int cookieVersion = cookie.getVersion();
            this.fillCookie(this.cb, cookie, date, 0);
            this.req.writeHeader("Set-Cookie", this.cb);
            if (cookieVersion <= 0) continue;
            this.fillCookie(this.cb, cookie, date, cookieVersion);
            this.req.writeHeader("Set-Cookie2", this.cb);
        }
        if (this.contentType != null) {
            this.req.writeHeader("Content-Type", this.contentType);
        }
        if (!(isHead = this.getResponseStream().isHead()) || this.contentLength >= 0L) {
            this.req.sendHeader();
        }
        return false;
    }

    protected void writeHeadFinish(WriteStream os, int length) throws IOException {
        this.cb.clear();
        this.cb.append(this.getResponseStream().getContentLength());
        this.req.writeHeader("Content-Length", this.cb);
        this.req.sendHeader();
    }
}

