/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.http.admin.ApplicationAdmin;
import com.caucho.http.admin.HostAdmin;
import com.caucho.regexp.Regexp;
import com.caucho.server.http.Application;
import com.caucho.server.http.CacheInvocation;
import com.caucho.server.http.ClassLoaderContext;
import com.caucho.server.http.EarContext;
import com.caucho.server.http.EarExpansion;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.ServletServer;
import com.caucho.server.http.WarExpansion;
import com.caucho.server.http.WebAppMap;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.L10N;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.RotateStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;

public class VirtualHost
extends ClassLoaderContext {
    static WriteStream dbg = LogStream.open("/caucho.com/http/host");
    static WriteStream warLog = LogStream.open("/log/http/war");
    static L10N L = new L10N(class$com$caucho$server$http$VirtualHost == null ? (class$com$caucho$server$http$VirtualHost = VirtualHost.class$("com.caucho.server.http.VirtualHost")) : class$com$caucho$server$http$VirtualHost);
    private volatile boolean _hasConfigureInit;
    private volatile boolean _isInitComplete;
    private volatile boolean _isInitStarted;
    private volatile boolean _isModified;
    private volatile boolean _isClosed;
    private ServletServer _server;
    private Path _cache;
    private String _serverName;
    private String _host;
    private int _port;
    private RegistryNode _applicationDefaultRegistry;
    private Path _warDir;
    private Path _warExpandDir;
    private WarExpansion _warExpansion;
    private EarExpansion _earExpansion;
    private long _updateInterval = 2000L;
    private long _lastUpdateTime;
    private ArrayList _earList = new ArrayList();
    private HashMap _contextRootMap = new HashMap();
    private WebAppMap _webAppMap;
    private Application _defaultApplication;
    private long _bogusDate;
    private boolean _hasEjb;
    private HostAdmin _admin;
    private boolean _isSecure;
    private String _urlCharacterEncoding;
    private ArrayList _regexp;
    private HostVar _hostVar = new HostVar();
    static /* synthetic */ Class class$com$caucho$server$http$VirtualHost;

    VirtualHost(ServletServer server) {
        super(server);
    }

    public Path getWarDir() {
        return this._warDir;
    }

    public String getServerName() {
        return this._serverName;
    }

    public Path getWarExpandDir() {
        return this._warExpandDir;
    }

    public boolean hasEjb() {
        return this._hasEjb;
    }

    public HostAdmin getAdmin() {
        return this._admin;
    }

    public String getURLCharacterEncoding() {
        if (this._urlCharacterEncoding != null) {
            return this._urlCharacterEncoding;
        }
        return this.getDefaultApplication().getCharEncoding();
    }

    String getHost() {
        return this._host;
    }

    boolean isCaseInsensitive() {
        return this._server.isCaseInsensitive();
    }

    int getPort() {
        return this._port;
    }

    ArrayList getRegexp() {
        return this._regexp;
    }

    void setRegexp(ArrayList regexp) {
        this._regexp = regexp;
    }

    public void setPathVariableMap(HashMap map) {
        super.setPathVariableMap(map);
        map.put("host", this._hostVar);
    }

    public String getURL() {
        String name = this._serverName;
        if (name == null) {
            name = this.getName();
        } else if (name.startsWith("http:") || name.startsWith("https:")) {
            return name;
        }
        if (name == null || name.equals("")) {
            name = this.getServer().getHost();
            if (name == null) {
                name = "localhost";
            }
            this._port = this.getServer().getPort();
        }
        if (this._port == 443) {
            return "https://" + name;
        }
        if (this._port == 80 || this._port == 0) {
            return "http://" + name;
        }
        return "http://" + name + ":" + this._port;
    }

    public String getCanonicalName() {
        String name = this._serverName;
        if (name == null || name.equals("")) {
            name = this.getName();
        }
        if (name == null || name.equals("")) {
            name = this.getServer().getHost();
        }
        if (name == null || name.equals("")) {
            name = "localhost";
        }
        return name;
    }

    public String getCanonicalURL() {
        if (this._serverName == null || this._serverName.equals("")) {
            return null;
        }
        String name = this._serverName;
        if (name != null && (name.startsWith("http:") || name.startsWith("https:"))) {
            return name;
        }
        if (this._port == 443) {
            return "https://" + name;
        }
        if (this._port == 80 || this._port == 0) {
            return "http://" + name;
        }
        return "http://" + name + ":" + this._port;
    }

    RegistryNode getApplicationDefaultRegistry() {
        return this._applicationDefaultRegistry;
    }

    Iterator getApplications() {
        return this._webAppMap.getApplications().iterator();
    }

    Application getApplication(String contextPath) {
        WebAppMap.Entry entry;
        if (this.isCaseInsensitive()) {
            contextPath = contextPath.toLowerCase();
        }
        if ((entry = this._webAppMap.findByContextPath(contextPath)) != null) {
            return entry.getApplication();
        }
        return null;
    }

    Application getDefaultApplication() {
        if (this._defaultApplication != null) {
            return this._defaultApplication;
        }
        WebAppMap.Entry entry = this._webAppMap.add("");
        this._defaultApplication = entry.getApplication();
        if (this._defaultApplication == null) {
            entry.setCfgAppDir(this.getDocPath());
            this.addWarEar(entry);
            try {
                this._defaultApplication = entry.createApplication();
                this._defaultApplication.init();
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
        return this._defaultApplication;
    }

    public ArrayList getApplicationAdminList() {
        ArrayList<ApplicationAdmin> adminList = new ArrayList<ApplicationAdmin>();
        ArrayList appList = this._webAppMap.getApplications();
        for (int i = 0; i < appList.size(); ++i) {
            Application app = (Application)appList.get(i);
            if (app == null) continue;
            adminList.add(app.getAdmin());
        }
        return adminList;
    }

    void initPaths(ServletServer server, String host, RegistryNode registry, RegistryNode defaultRegistry, HashMap pathVariableMap) throws Exception {
        this._server = server;
        this.setPathVariableMap(pathVariableMap);
        Path serverRoot = server.getRootPath();
        pathVariableMap.put("resin:pwd", serverRoot);
        registry = registry == null ? new RegistryNode() : (RegistryNode)registry.clone();
        if (defaultRegistry != null) {
            VirtualHost.mergeRegistry(registry, defaultRegistry);
        }
        this.setRegistry(registry);
        if (host == null) {
            host = "";
        } else if (host.equals("*")) {
            host = "";
        }
        this._serverName = registry.getELString("server-name", null, this.getEnv());
        int p = host.indexOf(44);
        if (p > 0) {
            host = host.substring(0, p);
        }
        if ((p = host.indexOf(32)) > 0) {
            host = host.substring(0, p);
        }
        if ((p = host.indexOf(9)) > 0) {
            host = host.substring(0, p);
        }
        host = host.trim();
        this._port = 0;
        p = host.indexOf(58);
        if (p > 0) {
            this._port = new Integer(host.substring(p + 1));
            host = host.substring(0, p);
        }
        this._host = host;
        if (this._serverName != null) {
            this.setName(this._serverName);
        } else {
            this.setName(host);
        }
        Path rootPath = VirtualHost.lookupPath(registry, "root-dir", serverRoot, this.getEnv());
        this.setRootPath(rootPath);
        pathVariableMap.put("host-root", this.getRootPath());
        Path serverDoc = server.getDocPath();
        pathVariableMap.put("resin:pwd", serverDoc);
        Path appPath = registry.lookup("root-dir") != null ? rootPath : serverDoc;
        appPath = VirtualHost.lookupPath(registry, "app-dir", appPath, this.getEnv());
        pathVariableMap.put("resin:pwd", this.getRootPath());
        Path docPath = VirtualHost.lookupPath(registry, "doc-dir", appPath, this.getEnv());
        this.setDocPath(docPath);
        pathVariableMap.put("host-doc", this.getDocPath());
        pathVariableMap.put("app-dir", this.getDocPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configureInit() throws Exception {
        if (this._hasConfigureInit) {
            throw new IllegalStateException();
        }
        if (_dbgLife.canWrite()) {
            _dbgLife.log("init: " + this);
        }
        RegistryNode registry = this.getRegistry();
        VirtualHost.verifyElements(registry, _hostElements);
        this._applicationDefaultRegistry = VirtualHost.selectDefault(registry, _appDefaultElements);
        this._urlCharacterEncoding = registry.getELString("character-encoding", "utf-8", this.getEnv());
        this._urlCharacterEncoding = registry.getELString("url-character-encoding", this._urlCharacterEncoding, this.getEnv());
        this._bogusDate = registry.getELInt("bogus-date", 0, this.getEnv());
        this._admin = new HostAdmin(this);
        this._updateInterval = registry.getELPeriod("class-update-interval", 2000L, this.getEnv());
        this._warDir = VirtualHost.lookupPath(registry, "war-dir", null, this.getEnv());
        this._warExpandDir = VirtualHost.lookupPath(registry, "war-expand-dir", null, this.getEnv());
        if (this._warExpandDir != null) {
            this._warExpandDir.mkdirs();
            this.setWebInfPath(this._warExpandDir);
            this.setAddWebInfClasses(true);
        } else if (this._warDir != null) {
            this._warExpandDir = this._warDir;
            this._warExpandDir.mkdirs();
            this.setWebInfPath(this._warExpandDir);
            this.setAddWebInfClasses(true);
        } else {
            this._warExpandDir = this.getRootPath().lookup("_war");
            this.setWebInfPath(null);
        }
        if (this._warDir == null) {
            this._warDir = this._warExpandDir;
        }
        this._isSecure = registry.getELBoolean("secure", false, this.getEnv());
        super.init();
        this._warExpansion = new WarExpansion(this);
        this._earExpansion = new EarExpansion(this);
        this._earExpansion.initEarDir();
        DynamicClassLoader classLoader = this.getClassLoader();
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this._webAppMap = new WebAppMap(this);
            this.readEarList();
            this.configureApplications();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
        this._hasConfigureInit = true;
    }

    private void readEarList() throws Exception {
        if (this.getWebInfPath() == null) {
            return;
        }
        Path webInfPath = this.getWebInfPath().lookup("WEB-INF");
        if (!webInfPath.canRead()) {
            return;
        }
        String[] list = webInfPath.list();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].endsWith(".ear")) continue;
            EarContext ear = this.loadEar(list[i].substring(0, list[i].length() - 4));
        }
    }

    private EarContext loadEar(String earName) throws Exception {
        Path webInfPath = this.getWebInfPath().lookup("WEB-INF");
        Path earConfigFile = webInfPath.lookup(earName + ".ear");
        Registry earRegistry = null;
        try {
            earRegistry = Registry.parse(earConfigFile);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        EarContext earContext = new EarContext(this);
        earContext.setName(earName);
        earContext.setRootPath(this._warExpandDir.lookup("_" + earName));
        earContext.setWebInfPath(earContext.getRootPath());
        earContext.setAddWebInfClasses(true);
        earContext.init(earRegistry.getTop());
        this._earList.add(earContext);
        return earContext;
    }

    private void configureApplications() throws Exception {
        boolean hasDefault = false;
        Object warNames = null;
        Object earNames = null;
        Iterator iter = this.getRegistry().iterator();
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            if (!node.getName().equals("web-app")) continue;
            String appName = node.getValue();
            if ("".equals(node.getValue()) || "/".equals(node.getValue()) || "/*".equals(node.getValue())) {
                hasDefault = true;
                appName = "";
            }
            this.configureWebApp(node, appName);
        }
        if (!hasDefault && this.getApplication("") == null) {
            boolean isDefaultHost = this.getServer().getDefaultHost() == this;
            String mode = isDefaultHost ? "http-server" : "host";
            WebAppMap.Entry entry = this._webAppMap.add("");
            entry.setCfgAppDir(this.getDocPath());
            entry.setMode(mode);
        }
    }

    private RotateStream configLog(RegistryNode node) throws ServletException, IOException, RegistryException {
        Path logPath = node.getELPath(null, null, this.getEnv());
        if ((logPath = node.getELPath("href", logPath, this.getEnv())) == null) {
            return null;
        }
        long rolloverPeriod = node.getELPeriod("rollover-period", -1L, this.getEnv());
        int rolloverSize = node.getELInt("rollover-size", -1, this.getEnv());
        String timestamp = node.getELString("timestamp", null, this.getEnv());
        RotateStream rotateStream = null;
        logPath.getParent().mkdirs();
        rotateStream = RotateStream.create(logPath);
        this._server.addRandom(logPath.getLength());
        this._server.addRandom(logPath.getParent().getLastModified());
        if (rotateStream != null) {
            if (rolloverPeriod > 0L) {
                rotateStream.setRolloverPeriod(rolloverPeriod);
            } else if (rolloverSize > 0) {
                rotateStream.setRolloverSize(rolloverSize);
            }
        }
        if (rotateStream != null && timestamp != null) {
            rotateStream.setTimestamp(timestamp);
        }
        return rotateStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws ServletException {
        if (!this._hasConfigureInit) {
            return;
        }
        Object object = this;
        synchronized (object) {
            if (this._isInitComplete || this._isInitStarted || this._isModified || this._isClosed) {
                return;
            }
            this._isInitStarted = true;
        }
        try {
            this.initWars();
            object = this._webAppMap;
            synchronized (object) {
                Application app;
                int i;
                ArrayList webAppList = (ArrayList)this._webAppMap.getWebAppList().clone();
                ArrayList<Application> list = new ArrayList<Application>();
                for (i = 0; i < webAppList.size(); ++i) {
                    WebAppMap.Entry entry = (WebAppMap.Entry)webAppList.get(i);
                    this.addWarEar(entry);
                    try {
                        list.add(entry.createApplication());
                        continue;
                    }
                    catch (Throwable e) {
                        dbg.log(e);
                    }
                }
                for (i = 0; i < list.size(); ++i) {
                    app = (Application)list.get(i);
                    if (!app.isEarApplication()) continue;
                    app.init();
                }
                for (i = 0; i < list.size(); ++i) {
                    app = (Application)list.get(i);
                    if (app.isLazyInit()) continue;
                    app.init();
                }
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            this._lastUpdateTime = Alarm.getCurrentTime();
            this._isInitComplete = true;
        }
    }

    void restartWarDir() throws Exception {
        this.initWars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initWars() throws Exception {
        ArrayList newWars;
        ArrayList oldWars;
        Object object = this._warExpansion;
        synchronized (object) {
            this._warExpansion.initWarDir();
            oldWars = this._warExpansion.getDeletedWars();
            newWars = this._warExpansion.getNewWars(true);
        }
        if (oldWars.size() != 0 || newWars.size() != 0) {
            this.getServer().clearCache();
        }
        object = this._webAppMap;
        synchronized (object) {
            String webName;
            String name;
            int i;
            for (i = 0; i < oldWars.size(); ++i) {
                name = (String)oldWars.get(i);
                webName = "/" + name;
                WebAppMap.Entry entry = this._webAppMap.findByWebName(webName);
                if (entry == null) continue;
                entry.setWarAppDir(null);
                Application app = entry.getApplication();
                if (app == null) continue;
                _dbgLife.log(app + " restart from .war change.");
                app.restartInt();
            }
            for (i = 0; i < newWars.size(); ++i) {
                name = (String)newWars.get(i);
                webName = "/" + name;
                Path appDir = this._warExpandDir.lookup(name);
                String contextPath = name.equals("ROOT") ? "" : webName;
                WebAppMap.Entry entry = this._webAppMap.findByWebName(webName);
                if (entry == null && this._webAppMap.findByContextPath(contextPath) != null) continue;
                if (entry == null) {
                    entry = this._webAppMap.add(webName);
                }
                entry.setWarAppDir(appDir);
                Path war = this._warDir.lookup(name + ".war");
                if (war.canRead()) {
                    entry.setWarPath(war);
                    entry.addDepend(war);
                }
                if ((war = this._warDir.lookup(name + ".jar")).canRead()) {
                    entry.setWarPath(war);
                    entry.addDepend(war);
                }
                this.addWarEar(entry);
                Application app = entry.getApplication();
                if (app != null) {
                    _dbgLife.log(app + " restart from .war change.");
                    app.restartInt();
                    continue;
                }
                app = entry.createApplication();
                app.init();
            }
        }
    }

    private void configureWebApp(RegistryNode node, String url) throws Exception {
        String appDir = node.getString("app-dir", null);
        String urlRegexp = node.getString("url-regexp", null);
        if (urlRegexp == null) {
            urlRegexp = node.getString("regexp", null);
        }
        if (urlRegexp != null) {
            String flags = this.isCaseInsensitive() ? "i" : "";
            Regexp regexp = new Regexp(urlRegexp, flags);
            this._webAppMap.addRegexp(regexp, node);
        } else {
            String contextPath;
            if (url == null || url.equals("")) {
                url = "/";
            }
            if ((contextPath = Invocation.normalizeUri(url)).equals("/")) {
                contextPath = "";
            }
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            if (this.isCaseInsensitive()) {
                contextPath = contextPath.toLowerCase();
            }
            Path appPath = appDir != null ? VirtualHost.getAppDir(this.getDocPath(), this._warExpandDir, appDir) : VirtualHost.getAppDir(this.getDocPath(), this._warExpandDir, "./" + contextPath);
            WebAppMap.Entry entry = null;
            if (appPath.getParent().equals(this._warExpandDir) || appPath.getParent().equals(this._warDir)) {
                String webName;
                String tail = appPath.getTail();
                if (tail.endsWith(".war") || tail.endsWith(".jar")) {
                    webName = "/" + tail.substring(tail.length() - 4);
                    appPath = this._warExpandDir.lookup("." + webName);
                } else {
                    webName = "/" + tail;
                }
                if (this.isCaseInsensitive()) {
                    webName = webName.toLowerCase();
                }
                entry = this._webAppMap.add(webName);
                entry.setContextPath(contextPath);
            }
            if (entry == null) {
                entry = this._webAppMap.add(contextPath);
            }
            entry.setRegistryNode(node);
            entry.setCfgAppDir(appPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Invocation getInvocation(byte[] rawUri, int uriLength, boolean isDispatch, boolean isTop, boolean decodeUrl) throws Exception {
        WebAppMap.Entry entry;
        int p;
        Invocation invocation = this._server.getCache() != null ? new CacheInvocation(this, rawUri, uriLength, isDispatch, decodeUrl, !isTop) : new Invocation(this, rawUri, uriLength, isDispatch, decodeUrl, !isTop);
        String uri = invocation.getUri();
        Application application = null;
        Object initApplication = null;
        String sessionPrefix = this._server.getSessionPrefix();
        String altSessionPrefix = this._server.getAlternateSessionPrefix();
        ArrayList vars = new ArrayList();
        CharBuffer contextPath = new CharBuffer();
        CharBuffer appBuffer = new CharBuffer();
        if (altSessionPrefix != null && invocation._rawUri.startsWith(altSessionPrefix)) {
            p = invocation._rawUri.indexOf(47, 1);
            if (p < 0) {
                invocation._sessionId = invocation._rawUri.substring(altSessionPrefix.length());
                invocation._rawUri = "/";
            } else {
                invocation._sessionId = invocation._rawUri.substring(altSessionPrefix.length(), p);
                invocation._rawUri = invocation._rawUri.substring(p);
            }
            p = invocation._uri.indexOf(47, 1);
            uri = p < 0 ? "/" : uri.substring(p);
        } else if (altSessionPrefix == null && (p = uri.indexOf(sessionPrefix)) >= 0) {
            int p1 = invocation._rawUri.indexOf(sessionPrefix);
            if (p1 >= 0) {
                invocation._rawUri = invocation._rawUri.substring(0, p1);
            }
            String sessionParam = uri.substring(p + sessionPrefix.length());
            uri = uri.substring(0, p);
            int p2 = sessionParam.indexOf(59);
            invocation._sessionId = p2 >= 0 ? sessionParam.substring(0, p2) : sessionParam;
        }
        Object object = this._webAppMap;
        synchronized (object) {
            entry = this._webAppMap.findByURI(uri);
        }
        invocation._contextPath = entry.getContextPath();
        object = entry;
        synchronized (object) {
            application = entry.getApplication();
            if (application == null || isTop && application.isModified()) {
                invocation._application = application = this.startApplication(entry);
                invocation.setServletConfig(null);
                invocation._filterChain = null;
            }
        }
        if (application == null) {
            application = this.getDefaultApplication();
        }
        application.init();
        if (isTop && application.getConfigException() instanceof Exception) {
            throw (Exception)application.getConfigException();
        }
        if (isTop && application.getConfigException() instanceof Error) {
            throw (Error)application.getConfigException();
        }
        int index = invocation._contextPath.length();
        invocation._uri = uri;
        Object pathInfo = null;
        invocation._pathInfo = index >= 0 ? uri.substring(index) : uri;
        invocation._application = application;
        if (isDispatch) {
            application.getServlet(invocation);
        }
        return invocation;
    }

    private void addWarEar(WebAppMap.Entry entry) {
        String webName = entry.getWebName();
        int i = 0;
        if (i < this._earList.size()) {
            EarContext ear = (EarContext)this._earList.get(i);
            String contextPath = ear.mapContextPath(webName);
            if (contextPath != null) {
                entry.setParent(ear);
                entry.setContextPath(contextPath);
                return;
            }
            entry.setParent(this);
            return;
        }
    }

    static Path getAppDir(Path root, Path expandDir, String realPath) {
        if (!realPath.endsWith(".war") && !realPath.endsWith(".jar")) {
            return root.lookupNative(realPath);
        }
        if (expandDir == null) {
            return root.lookupNative(realPath);
        }
        Path war = root.lookupNative(realPath);
        String tail = war.getTail();
        int p = tail.lastIndexOf(46);
        if (p > 0) {
            tail = tail.substring(0, p);
        }
        try {
            WarExpansion.expandWar(war, expandDir, tail);
        }
        catch (IOException e) {
            dbg.log(e);
        }
        return expandDir.lookup(tail);
    }

    private static void removeAll(Path path) {
        try {
            if (path.isDirectory()) {
                if (path.getPath().endsWith("WEB-INF/sessions")) {
                    return;
                }
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    VirtualHost.removeAll(path.lookup(list[i]));
                }
            } else if (path.getPath().endsWith("WEB-INF/resin-web.xml")) {
                return;
            }
            path.remove();
        }
        catch (Throwable e) {
            dbg.log(e);
        }
    }

    private static void moveAll(Path source, Path target) {
        block6: {
            try {
                if (source.isDirectory()) {
                    try {
                        target.mkdirs();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    String[] list = source.list();
                    for (int i = 0; list != null && i < list.length; ++i) {
                        VirtualHost.moveAll(source.lookup(list[i]), target.lookup(list[i]));
                    }
                    break block6;
                }
                source.renameTo(target);
            }
            catch (IOException e) {
                dbg.log(e);
            }
        }
    }

    private Application startApplication(WebAppMap.Entry entry) {
        EarContext ear;
        Application app;
        Path war = entry.getWarPath();
        if (war != null) {
            String webName = entry.getWebName();
            int p = webName.lastIndexOf(47);
            String tail = webName.substring(p + 1);
            try {
                WarExpansion.expandWar(war, this._warExpandDir.lookup(tail), null);
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
        if (this._defaultApplication == (app = entry.getApplication())) {
            this._defaultApplication = null;
        }
        entry.closeApplication();
        if (app != null && app.getParent() instanceof EarContext && (ear = (EarContext)app.getParent()).isModified()) {
            String name = ear.getName();
            this._earList.remove(ear);
            ear.close();
            try {
                ear = this.loadEar(name);
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
        this.addWarEar(entry);
        try {
            app = entry.createApplication();
            app.init();
            return app;
        }
        catch (Throwable e) {
            dbg.log(e);
            return null;
        }
    }

    void log(Throwable e) {
        Application app = this.getDefaultApplication();
        if (app != null) {
            app.log(e.getMessage(), e);
        }
        dbg.log(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isModified() {
        if (this._isModified) {
            return true;
        }
        if (!this._isInitComplete) {
            return false;
        }
        long now = Alarm.getCurrentTime();
        if (now < this._lastUpdateTime + this._updateInterval) {
            return false;
        }
        ClassLoaderContext parent = this.getParent();
        if (parent != null && parent.isModified()) {
            this._isModified = true;
            return true;
        }
        VirtualHost virtualHost = this;
        synchronized (virtualHost) {
            now = Alarm.getCurrentTime();
            if (this._isModified) {
                return true;
            }
            if (now < this._lastUpdateTime + this._updateInterval) {
                return false;
            }
            if (this.isModifiedAsParent()) {
                _dbgLife.log("host is modified for " + this);
                this._isModified = true;
                return true;
            }
            if (this._warExpansion.isModified()) {
                return true;
            }
        }
        this._lastUpdateTime = Alarm.getCurrentTime();
        return false;
    }

    protected boolean isWarDirModified() {
        return this._warExpansion.isModified();
    }

    protected boolean isModifiedAsParent() {
        try {
            return super.isModified();
        }
        catch (Throwable e) {
            dbg.log(e);
            return true;
        }
    }

    void timeout(long now) {
        if (this._isClosed) {
            return;
        }
        ArrayList list = this._webAppMap.getWebAppList();
        for (int i = 0; i < list.size(); ++i) {
            WebAppMap.Entry entry = (WebAppMap.Entry)list.get(i);
            Application app = entry.getApplication();
            if (app == null) continue;
            app.timeout(now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cron(long now) {
        if (this._isClosed || this._isModified) {
            return;
        }
        if (this.isWarDirModified()) {
            try {
                this.restartWarDir();
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
        ArrayList appList = (ArrayList)this._webAppMap.getWebAppList().clone();
        for (int i = 0; i < appList.size(); ++i) {
            WebAppMap.Entry entry;
            WebAppMap.Entry entry2 = entry = (WebAppMap.Entry)appList.get(i);
            synchronized (entry2) {
                Application app = entry.getApplication();
                if (app == null) {
                    continue;
                }
                if (app.isModified()) {
                    app = this.startApplication(entry);
                    if (app != null) {
                        app.init();
                    }
                } else {
                    app.cron(now);
                }
                continue;
            }
        }
        super.cron(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        VirtualHost virtualHost = this;
        synchronized (virtualHost) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            this._isModified = true;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldLoader = null;
        currentThread.setContextClassLoader(this.getClassLoader());
        if (this._webAppMap != null) {
            WebAppMap webAppMap = this._webAppMap;
            synchronized (webAppMap) {
                ArrayList appList = this._webAppMap.getApplications();
                for (int i = 0; i < appList.size(); ++i) {
                    Application app = (Application)appList.get(i);
                    app.close();
                }
            }
        }
        super.close();
        currentThread.setContextClassLoader(oldLoader);
        this._defaultApplication = null;
    }

    void setDate(long date) {
        this._bogusDate = date;
    }

    long getTestDate() {
        return this._bogusDate;
    }

    public String toString() {
        if (this._port > 0) {
            return "VirtualHost[id=" + this._host + ", port=" + this._port + "]";
        }
        return "VirtualHost[id=" + this._host + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class HostVar {
        public String getUrl() {
            return VirtualHost.this.getURL();
        }

        public String getName() {
            return VirtualHost.this.getCanonicalName();
        }

        public Path getRootDir() {
            return VirtualHost.this.getRootPath();
        }

        public Path getDocDir() {
            return VirtualHost.this.getDocPath();
        }

        public Path getWarDir() {
            return VirtualHost.this.getWarDir();
        }

        public Path getWarExpandDir() {
            return VirtualHost.this.getWarExpandDir();
        }

        public ArrayList getRegexp() {
            return VirtualHost.this.getRegexp();
        }

        public String toString() {
            return VirtualHost.this.toString();
        }
    }
}

