/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.StatementOverflowException;
import com.caucho.sql.XAConnectionAdapter;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.transaction.xa.Xid;

public class UserConnectionAdapter
implements Connection {
    protected static WriteStream dbg = LogStream.open("/caucho.com/sql/pool");
    protected static L10N L = new L10N(class$com$caucho$sql$UserConnectionAdapter == null ? (class$com$caucho$sql$UserConnectionAdapter = UserConnectionAdapter.class$("com.caucho.sql.UserConnectionAdapter")) : class$com$caucho$sql$UserConnectionAdapter);
    private XAConnectionAdapter _xaConn;
    private boolean _isClosed;
    private int _maxCloseStatements = 20;
    private int _isolation = -1;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private String _catalog = null;
    private int _oldIsolation = -1;
    private Map _typeMap;
    private Xid _xid;
    private Statement _statement;
    private ArrayList _statements;
    static /* synthetic */ Class class$com$caucho$sql$UserConnectionAdapter;

    UserConnectionAdapter(XAConnectionAdapter xaConn) {
        if (xaConn == null) {
            throw new NullPointerException();
        }
        this._xaConn = xaConn;
        DBPool pool = xaConn.getDataSource().getPool();
        this._maxCloseStatements = pool.getMaxCloseStatements();
    }

    public Connection getConnection() throws SQLException {
        if (this._xaConn == null) {
            throw new IllegalStateException("connection is closed");
        }
        return this._xaConn.getDriverConnection();
    }

    public Statement createStatement() throws SQLException {
        Statement stmt;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public String getCatalog() throws SQLException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            if (this._catalog == null) {
                this._catalog = this.getConnection().getCatalog();
            }
            this.getConnection().setCatalog(catalog);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getConnection().getTypeMap();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            if (this._typeMap == null) {
                this._typeMap = this.getConnection().getTypeMap();
            }
            this.getConnection().setTypeMap(map);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.getConnection().nativeSQL(sql);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getConnection().getTransactionIsolation();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        try {
            this._xaConn.setIsolation(isolation);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getConnection().getWarnings();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.getConnection().clearWarnings();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this._readOnly = readOnly;
            this.getConnection().setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.getConnection().isReadOnly();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareCall(sql);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this._xid != null) {
            throw new SQLException(L.l("can't set auto-commit when using transactions"));
        }
        try {
            this.getConnection().setAutoCommit(autoCommit);
            this._autoCommit = autoCommit;
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void commit() throws SQLException {
        if (this._xid != null) {
            throw new SQLException(L.l("can't call commit() when using transactions"));
        }
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void rollback() throws SQLException {
        if (this._xid != null) {
            throw new SQLException(L.l("can't call rollback() when using transactions"));
        }
        try {
            this.getConnection().rollback();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            return this._isClosed || this._xaConn == null || this.getConnection() == null || this.getConnection().isClosed();
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
    }

    public void close() throws SQLException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        XAConnectionAdapter xaConn = this._xaConn;
        this._xaConn = null;
        if (xaConn == null) {
            return;
        }
        try {
            this.resetConnection(xaConn);
        }
        catch (Throwable e) {
            xaConn.fatalEvent();
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SQLExceptionWrapper(e);
        }
        finally {
            xaConn.closeEvent();
        }
    }

    private void addStatement(Statement stmt) {
        if (this._statements == null || this._statements.size() < this._maxCloseStatements) {
            if (this._statement == null) {
                this._statement = stmt;
            } else if (this._statements == null) {
                this._statements = new ArrayList();
                this._statements.add(stmt);
            } else {
                this._statements.add(stmt);
            }
        } else {
            this._xaConn.fatalEvent(new StatementOverflowException(L.l("too many statements {0} to automatically close.", new Integer(this._maxCloseStatements))));
        }
    }

    public void setHoldability(int hold) {
    }

    public int getHoldability() {
        return 0;
    }

    public Savepoint setSavepoint() {
        return null;
    }

    public Savepoint setSavepoint(String name) {
        return null;
    }

    public void releaseSavepoint(Savepoint savepoint) {
    }

    public void rollback(Savepoint savepoint) throws SQLException {
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, resultSetType);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt;
        if (this.getConnection() == null) {
            this._xaConn.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this._xaConn.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    private void resetConnection(XAConnectionAdapter xaConn) {
        if (xaConn == null) {
            return;
        }
        Connection conn = xaConn.getDriverConnection();
        if (conn == null) {
            return;
        }
        this.closeStatements(xaConn);
        try {
            if (!this._autoCommit) {
                conn.rollback();
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            xaConn.fatalEvent();
        }
        this._autoCommit = true;
        try {
            if (this._readOnly) {
                conn.setReadOnly(false);
            }
        }
        catch (SQLException e) {
            xaConn.fatalEvent();
        }
        this._readOnly = false;
        try {
            if (this._catalog != null) {
                conn.setCatalog(this._catalog);
            }
        }
        catch (SQLException e) {
            xaConn.fatalEvent();
        }
        this._catalog = null;
        try {
            if (this._typeMap != null) {
                conn.setTypeMap(this._typeMap);
            }
        }
        catch (SQLException e) {
            xaConn.fatalEvent();
        }
        this._typeMap = null;
        try {
            conn.clearWarnings();
        }
        catch (SQLException e) {
            xaConn.fatalEvent();
        }
    }

    private void closeStatements(XAConnectionAdapter xaConn) {
        ArrayList statements = this._statements;
        this._statements = null;
        Statement stmt = this._statement;
        this._statement = null;
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable e) {
            dbg.log(e);
        }
        for (int i = 0; statements != null && i < statements.size(); ++i) {
            try {
                stmt = (Statement)statements.get(i);
                stmt.close();
                continue;
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
    }

    public String toString() {
        if (this._xaConn != null) {
            return "UserConnectionAdapter[" + this._xaConn + "]";
        }
        return "UserConnectionAdapter[]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

