/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class ByteBuffer {
    byte[] buffer;
    int capacity;
    int length;

    public ByteBuffer(int minimumCapacity) {
        this.capacity = 32;
        if (minimumCapacity > 4096) {
            this.capacity = minimumCapacity + 4095 & 0xFFFFF000;
        } else {
            while (this.capacity < minimumCapacity) {
                this.capacity += this.capacity;
            }
        }
        this.buffer = new byte[minimumCapacity];
        this.length = 0;
    }

    public ByteBuffer() {
        this.buffer = new byte[32];
        this.capacity = this.buffer.length;
        this.length = 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public int hashCode() {
        int hash = 17;
        for (int i = this.length - 1; i >= 0; --i) {
            hash = 65537 * hash + this.buffer[i];
        }
        return hash;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity <= this.capacity) {
            return;
        }
        if (minimumCapacity > 4096) {
            this.capacity = minimumCapacity + 4095 & 0xFFFFF000;
        } else {
            while (this.capacity < minimumCapacity) {
                this.capacity += this.capacity;
            }
        }
        byte[] bytes = new byte[this.capacity];
        System.arraycopy(this.buffer, 0, bytes, 0, this.length);
        this.buffer = bytes;
    }

    public int length() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int len) {
        if (len < 0) {
            throw new RuntimeException("illegal argument");
        }
        if (len > this.capacity) {
            this.ensureCapacity(len);
        }
        this.length = len;
    }

    public void clear() {
        this.length = 0;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void append(int b) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = (byte)b;
    }

    public void add(int i, byte[] buffer, int offset, int length) {
        if (this.length + length > this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(this.buffer, i, this.buffer, i + length, this.length - i);
        System.arraycopy(buffer, offset, this.buffer, i, length);
        this.length += length;
    }

    public void add(byte[] buffer, int offset, int length) {
        if (this.length + length > this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(buffer, offset, this.buffer, this.length, length);
        this.length += length;
    }

    public void add(int i, int data) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        System.arraycopy(this.buffer, i, this.buffer, i + 1, this.length - i);
        this.buffer[i] = (byte)data;
        ++this.length;
    }

    public void add(int data) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = (byte)data;
    }

    public void set(int i, byte[] buffer, int offset, int length) {
        System.arraycopy(buffer, offset, this.buffer, i, length);
    }

    public void set(int i, int data) {
        this.buffer[i] = (byte)data;
    }

    public void insert(int i, byte[] buffer, int offset, int length) {
        if (this.length + length > this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(this.buffer, i, this.buffer, i + length, this.length - i);
        System.arraycopy(buffer, offset, this.buffer, i, length);
        this.length += length;
    }

    public void replace(int i, byte[] buffer, int offset, int length) {
        System.arraycopy(buffer, offset, this.buffer, i, length);
    }

    public void append(byte[] buffer, int offset, int length) {
        if (this.length + length >= this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(buffer, offset, this.buffer, this.length, length);
        this.length += length;
    }

    public void replaceShort(int i, int s) {
        this.buffer[i] = (byte)(s >> 8);
        this.buffer[i + 1] = (byte)s;
    }

    public void appendShort(int s) {
        if (this.length + 2 > this.capacity) {
            this.ensureCapacity(this.length + 2);
        }
        this.replaceShort(this.length, s);
        this.length += 2;
    }

    public void addShort(int s) {
        if (this.length + 2 > this.capacity) {
            this.ensureCapacity(this.length + 2);
        }
        this.buffer[this.length++] = (byte)(s >> 8);
        this.buffer[this.length++] = (byte)s;
    }

    public void addShort(int i, int s) {
        this.add(i, (byte)(s >> 8));
        this.add(i + 1, (byte)s);
    }

    public void setShort(int i, int s) {
        this.buffer[i] = (byte)(s >> 8);
        this.buffer[i + 1] = (byte)s;
    }

    public void replaceInt(int i, int v) {
        this.buffer[i] = (byte)(v >> 24);
        this.buffer[i + 1] = (byte)(v >> 16);
        this.buffer[i + 2] = (byte)(v >> 8);
        this.buffer[i + 3] = (byte)v;
    }

    public void appendInt(int s) {
        if (this.length + 4 > this.capacity) {
            this.ensureCapacity(this.length + 4);
        }
        this.buffer[this.length++] = (byte)(s >> 24);
        this.buffer[this.length++] = (byte)(s >> 16);
        this.buffer[this.length++] = (byte)(s >> 8);
        this.buffer[this.length++] = (byte)s;
    }

    public void addInt(int s) {
        if (this.length + 4 > this.capacity) {
            this.ensureCapacity(this.length + 4);
        }
        this.buffer[this.length++] = (byte)(s >> 24);
        this.buffer[this.length++] = (byte)(s >> 16);
        this.buffer[this.length++] = (byte)(s >> 8);
        this.buffer[this.length++] = (byte)s;
    }

    public void addInt(int i, int s) {
        this.add(i + 0, (byte)(s >> 24));
        this.add(i + 1, (byte)(s >> 16));
        this.add(i + 2, (byte)(s >> 8));
        this.add(i + 3, (byte)s);
    }

    public void setInt(int i, int v) {
        this.buffer[i] = (byte)(v >> 24);
        this.buffer[i + 1] = (byte)(v >> 16);
        this.buffer[i + 2] = (byte)(v >> 8);
        this.buffer[i + 3] = (byte)v;
    }

    public void addLong(long v) {
        if (this.length + 8 > this.capacity) {
            this.ensureCapacity(this.length + 8);
        }
        this.buffer[this.length++] = (byte)(v >> 56);
        this.buffer[this.length++] = (byte)(v >> 48);
        this.buffer[this.length++] = (byte)(v >> 40);
        this.buffer[this.length++] = (byte)(v >> 32);
        this.buffer[this.length++] = (byte)(v >> 24);
        this.buffer[this.length++] = (byte)(v >> 16);
        this.buffer[this.length++] = (byte)(v >> 8);
        this.buffer[this.length++] = (byte)v;
    }

    public void addFloat(float v) {
        if (this.length + 4 > this.capacity) {
            this.ensureCapacity(this.length + 4);
        }
        int bits = Float.floatToIntBits(v);
        this.buffer[this.length++] = (byte)(bits >> 24);
        this.buffer[this.length++] = (byte)(bits >> 16);
        this.buffer[this.length++] = (byte)(bits >> 8);
        this.buffer[this.length++] = (byte)bits;
    }

    public void addDouble(double v) {
        if (this.length + 8 > this.capacity) {
            this.ensureCapacity(this.length + 8);
        }
        long bits = Double.doubleToLongBits(v);
        this.buffer[this.length++] = (byte)(bits >> 56);
        this.buffer[this.length++] = (byte)(bits >> 48);
        this.buffer[this.length++] = (byte)(bits >> 40);
        this.buffer[this.length++] = (byte)(bits >> 32);
        this.buffer[this.length++] = (byte)(bits >> 24);
        this.buffer[this.length++] = (byte)(bits >> 16);
        this.buffer[this.length++] = (byte)(bits >> 8);
        this.buffer[this.length++] = (byte)bits;
    }

    public void addString(String s) {
        int len = s.length();
        if (len + this.length > this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[this.length++] = (byte)s.charAt(i);
        }
    }

    public void addString(String s, String encoding) {
        if (encoding == null || encoding.equals("ISO-8859-1")) {
            this.addString(s);
            return;
        }
        byte[] bytes = null;
        try {
            bytes = s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.addString(s);
            return;
        }
        int len = bytes.length;
        if (len + this.length > this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[this.length++] = bytes[i];
        }
    }

    public void add(String s) {
        int len = s.length();
        if (len + this.length > this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[this.length++] = (byte)s.charAt(i);
        }
    }

    public void add(char[] s, int offset, int len) {
        if (len + this.length > this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[this.length++] = (byte)s[offset + i];
        }
    }

    public void add(CharBuffer cb) {
        int len = cb.length();
        if (len + this.length > this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        char[] s = cb.getBuffer();
        for (int i = 0; i < len; ++i) {
            this.buffer[this.length++] = (byte)s[i];
        }
    }

    public void remove(int begin, int length) {
        System.arraycopy(this.buffer, begin + length, this.buffer, begin, this.capacity - length - begin);
        this.length -= length;
    }

    public void append(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.append(string.charAt(i));
        }
    }

    public byte byteAt(int i) {
        if (i < 0 || i > this.length) {
            throw new RuntimeException();
        }
        return this.buffer[i];
    }

    public void setByteAt(int i, int b) {
        this.buffer[i] = (byte)b;
    }

    public byte get(int i) {
        if (i < 0 || i >= this.length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this.length);
        }
        return this.buffer[i];
    }

    public short getShort(int i) {
        if (i < 0 || i + 1 >= this.length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this.length);
        }
        return (short)(((this.buffer[i] & 0xFF) << 8) + (this.buffer[i + 1] & 0xFF));
    }

    public int getInt(int i) {
        if (i < 0 || i + 3 >= this.length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this.length);
        }
        return ((this.buffer[i + 0] & 0xFF) << 24) + ((this.buffer[i + 1] & 0xFF) << 16) + ((this.buffer[i + 2] & 0xFF) << 8) + (this.buffer[i + 3] & 0xFF);
    }

    public void print(int i) {
        if (this.length + 16 >= this.capacity) {
            this.ensureCapacity(this.length + 16);
        }
        if (i < 0) {
            this.buffer[this.length++] = 45;
            i = -i;
        } else if (i == 0) {
            this.buffer[this.length++] = 48;
            return;
        }
        int start = this.length;
        while (i > 0) {
            this.buffer[this.length++] = (byte)(i % 10 + 48);
            i /= 10;
        }
        for (int j = (this.length - start) / 2; j > 0; --j) {
            byte temp = this.buffer[this.length - j];
            this.buffer[this.length - j] = this.buffer[start + j - 1];
            this.buffer[start + j - 1] = temp;
        }
    }

    public Object clone() {
        ByteBuffer newBuffer = new ByteBuffer(this.length);
        System.arraycopy(this.buffer, 0, newBuffer.buffer, 0, this.length);
        return newBuffer;
    }

    public boolean equals(Object b) {
        if (!(b instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer bb = (ByteBuffer)b;
        if (bb.length != this.length) {
            return false;
        }
        for (int i = this.length - 1; i >= 0; --i) {
            if (bb.buffer[i] == this.buffer[i]) continue;
            return false;
        }
        return true;
    }

    public InputStream createInputStream() {
        return new BBInputStream(this);
    }

    public OutputStream createOutputStream() {
        return new BBOutputStream(this);
    }

    public ReadStream createReadStream() {
        return VfsStream.openRead(new BBInputStream(this));
    }

    public byte[] getByteArray() {
        byte[] bytes = new byte[this.length];
        System.arraycopy(this.buffer, 0, bytes, 0, this.length);
        return bytes;
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public String toString(String encoding) {
        try {
            return new String(this.buffer, 0, this.length, encoding);
        }
        catch (Exception e) {
            return new String(this.buffer, 0, this.length);
        }
    }

    static class BBOutputStream
    extends OutputStream {
        ByteBuffer buf;

        public void write(int ch) throws IOException {
            this.buf.append(ch);
        }

        BBOutputStream(ByteBuffer buf) {
            this.buf = buf;
        }
    }

    static class BBInputStream
    extends InputStream {
        ByteBuffer buf;
        int index;

        public int available() {
            return this.buf.length - this.index;
        }

        public int read() throws IOException {
            if (this.index >= this.buf.length) {
                return -1;
            }
            return this.buf.buffer[this.index++] & 0xFF;
        }

        BBInputStream(ByteBuffer buf) {
            this.buf = buf;
        }
    }
}

