/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.el.ELException;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.el.VariableResolver;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RegistryNode {
    static L10N L = new L10N("com/caucho/server/util/messages");
    private static final long DAY = 86400000L;
    private static QDate calendar = new QDate();
    private Registry root;
    RegistryNode parent;
    private ArrayList children;
    String name;
    String id;
    String value;
    private String filename;
    private int line;

    public RegistryNode() {
    }

    RegistryNode(Registry root, String name, String value, String filename, int line) {
        this.root = root;
        this.name = name;
        this.value = value;
        this.filename = filename;
        this.line = line;
    }

    public boolean isModified() {
        return this.root.isModified();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public RegistryNode getParent() {
        return this.parent;
    }

    public RegistryNode getFirstChild() {
        if (this.children != null && this.children.size() > 0) {
            return (RegistryNode)this.children.get(0);
        }
        return null;
    }

    public Registry getRoot() {
        return this.root;
    }

    public void setRoot(Registry root) {
        this.root = root;
    }

    public void append(RegistryNode next) {
        if (next == null || next.children == null) {
            return;
        }
        for (int i = 0; i < next.children.size(); ++i) {
            RegistryNode child = (RegistryNode)next.children.get(i);
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }
    }

    public void addChild(RegistryNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public boolean getBoolean() throws RegistryException {
        String value = this.getValue();
        if (value == null || value.equals("") || value.equals(this.getName())) {
            return true;
        }
        if (value.equals("true") || value.equals("yes")) {
            return true;
        }
        if (value.equals("false") || value.equals("no")) {
            return false;
        }
        throw this.error(L.l("expected `true' or 'false' for boolean value"));
    }

    public boolean getBoolean(String path, boolean deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getBoolean();
    }

    public RegistryNode lookup(String path) {
        int tail;
        int head;
        if (path == null) {
            return this;
        }
        int length = path.length();
        for (head = 0; head < length && path.charAt(head) == '/'; ++head) {
        }
        for (tail = head; tail < length && path.charAt(tail) != '/'; ++tail) {
        }
        if (tail <= head) {
            return this;
        }
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        String seq = path.substring(head, tail);
        String end = tail < length ? path.substring(tail + 1) : "";
        for (int i = 0; i < this.children.size(); ++i) {
            RegistryNode match;
            RegistryNode child = (RegistryNode)this.children.get(i);
            if (!child.name.equals(seq) || (match = child.lookup(end)) == null) continue;
            return match;
        }
        return null;
    }

    private RegistryNode getLink(String name) {
        int length = this.children == null ? 0 : this.children.size();
        for (int i = 0; i < length; ++i) {
            RegistryNode child = (RegistryNode)this.children.get(i);
            if (!child.name.equals(name)) continue;
            return child;
        }
        return null;
    }

    public int getInt() throws RegistryException {
        String value = this.getValue();
        if (value == null || value.equals("") || value.equals(this.getName())) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public int getInt(String path, int deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getInt();
    }

    public double getDouble() throws RegistryException {
        String value = this.getValue();
        if (value == null || value.equals("") || value.equals(this.getName())) {
            return 0.0;
        }
        try {
            return Double.valueOf(value);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public double getDouble(String path, double deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getDouble();
    }

    public String getString() {
        String value = this.getValue();
        return value;
    }

    public String getString(String path, String deflt) {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getString();
    }

    public String getPath() {
        String value = this.getValue();
        if (value.startsWith("$")) {
            int p = value.indexOf(47);
            if (p > 0) {
                String name = value.substring(1, p);
                String property = System.getProperty(name);
                if (property != null) {
                    value = property + value.substring(p);
                }
            } else {
                String name = value.substring(1);
                String property = System.getProperty(name);
                if (property != null) {
                    value = property;
                }
            }
        }
        return value;
    }

    public String getPath(String path, String deflt) {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getPath();
    }

    public QDate getDate() throws RegistryException {
        String value = this.getValue();
        throw this.error("no date");
    }

    public QDate getDate(String path, QDate deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getDate();
    }

    public long getPeriod() throws RegistryException {
        try {
            return RegistryNode.calculatePeriod(this.getValue());
        }
        catch (RegistryException e) {
            throw this.error(e.getMessage());
        }
    }

    public static long calculatePeriod(String value) throws RegistryException {
        try {
            return Expr.toPeriod(value);
        }
        catch (ELException e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public long getPeriod(String path, long deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getPeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long periodEnd(long now, long period) {
        if (period < 0L) {
            return Long.MAX_VALUE;
        }
        if (period == 0L) {
            return now;
        }
        if (period < 2592000000L) {
            return now + (period - (now + 345600000L) % period);
        }
        if (period % 2592000000L == 0L) {
            int months = (int)(period / 2592000000L);
            QDate qDate = calendar;
            synchronized (qDate) {
                calendar.setTime(now);
                long year = calendar.getYear();
                int month = calendar.getMonth();
                calendar.setTime(0L);
                return calendar.setDate(year, month + months, 0L);
            }
        }
        if (period % 31536000000L == 0L) {
            long years = period / 31536000000L;
            QDate qDate = calendar;
            synchronized (qDate) {
                calendar.setTime(now);
                long year = calendar.getYear();
                calendar.setTime(0L);
                long newYear = year + (years - year % years);
                return calendar.setDate(newYear, 0L, 0L);
            }
        }
        return now + (period - (now + 345600000L) % period);
    }

    public InetNetwork getNetwork(String path, InetNetwork deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getNetwork();
    }

    public InetNetwork getNetwork() throws RegistryException {
        try {
            return RegistryNode.parseNetwork(this.getValue());
        }
        catch (RegistryException e) {
            throw this.error(e.getMessage());
        }
    }

    public static InetNetwork parseNetwork(String network) throws RegistryException {
        return InetNetwork.create(network);
    }

    public boolean getELBoolean(VariableResolver env) throws RegistryException {
        String value = this.getValue();
        if (value == null || value.equals("") || value.equals(this.getName())) {
            return true;
        }
        if (value.equals("true") || value.equals("yes")) {
            return true;
        }
        if (value.equals("false") || value.equals("no")) {
            return false;
        }
        try {
            Expr expr = new ELParser(value).parse();
            return expr.evalBoolean(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public String getELString(VariableResolver env) throws RegistryException {
        try {
            String value = this.getValue();
            if (value == null || value.equals("")) {
                return value;
            }
            Expr expr = new ELParser(value).parse();
            return expr.evalString(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public boolean getELBoolean(String path, boolean deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            return node.getELBoolean(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public String getELString(String path, String deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getELString(env);
    }

    public int getELInt(String path, int deflt, VariableResolver env) throws RegistryException {
        return (int)this.getELLong(path, deflt, env);
    }

    public long getELLong(String path, long deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            return expr.evalLong(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public double getELDouble(String path, double deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            return expr.evalDouble(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public Path getELPath(String path, Path deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            Object obj = expr.evalObject(env);
            if (obj instanceof Path) {
                return (Path)obj;
            }
            String value = Expr.toString(obj);
            Path pwd = (Path)env.get("resin:pwd");
            if (pwd != null) {
                return pwd.lookup(value);
            }
            return Vfs.lookup(value);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public long getELPeriod(String path, long deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            return expr.evalPeriod(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public long getELBytes(String path, long deflt, VariableResolver env) throws RegistryException {
        char ch;
        String bytes;
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            bytes = expr.evalString(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        long value = 0L;
        long sign = 1L;
        int i = 0;
        int length = bytes.length();
        if (length == 0) {
            return -1L;
        }
        if (bytes.charAt(i) == '-') {
            sign = -1L;
            ++i;
        } else if (bytes.charAt(i) == '+') {
            ++i;
        }
        if (length <= i) {
            return -1L;
        }
        while (i < length && (ch = bytes.charAt(i)) >= '0' && ch <= '9') {
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        value = sign * value;
        if ((bytes = bytes.toLowerCase()).endsWith("gb") || bytes.endsWith("g")) {
            return value * 1024L * 1024L * 1024L;
        }
        if (bytes.endsWith("mb") || bytes.endsWith("m")) {
            return value * 1024L * 1024L;
        }
        if (bytes.endsWith("kb") || bytes.endsWith("k")) {
            return value * 1024L;
        }
        if (bytes.endsWith("b")) {
            return value;
        }
        if (value < 0L) {
            return value;
        }
        throw node.error(L.l("byte-valued expression `{0}' must have units.  '16b' for bytes, '16kb' for kilobytes, '16mb' for megabytes, '16gb' for gigabytes.", bytes));
    }

    public Iterator iterator() {
        return new RegistryIterator();
    }

    public Iterator select(String key) {
        return new RegistryIterator(key);
    }

    public List getChildren() {
        return this.children;
    }

    RegistryNode add(String name, String value, String filename, int line) {
        RegistryNode child = new RegistryNode(this.root, name, value, filename, line);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.parent = this;
        return child;
    }

    RegistryNode add(RegistryNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.parent = this;
        return child;
    }

    private RegistryNode getLink(String name, String value) {
        int length = this.children == null ? 0 : this.children.size();
        for (int i = 0; i < length; ++i) {
            RegistryNode child = (RegistryNode)this.children.get(i);
            if (!child.name.equals(name) || child.value == null || !child.value.equals(value)) continue;
            return child;
        }
        return null;
    }

    public RegistryException error(String msg) {
        return new RegistryException(this.getErrorMessage(msg));
    }

    public RegistryException error(Exception e) {
        if (e instanceof RegistryException) {
            return (RegistryException)e;
        }
        return new RegistryException(this.getErrorMessage(e.toString()), e);
    }

    public String getErrorMessage(String message) {
        return this.filename + ":" + this.line + ": " + message;
    }

    public void print(WriteStream os) throws IOException {
        this.print(os, 0);
    }

    private void print(WriteStream os, int depth) throws IOException {
        this.printSpaces(os, depth);
        os.print("<" + this.getName());
        if (this.getValue() != null) {
            os.print(" id=\"" + this.getValue() + "\"");
        }
        int length = this.children == null ? 0 : this.children.size();
        boolean hasElementChildren = false;
        for (int i = 0; i < length; ++i) {
            RegistryNode child = (RegistryNode)this.children.get(i);
            if (child.children != null && child.children.size() != 0) {
                hasElementChildren = true;
                break;
            }
            os.print(" " + child.getName() + "=\"" + child.getValue() + "\"");
        }
        if (!hasElementChildren) {
            os.println("/>");
            return;
        }
        os.println(">");
        boolean printChild = false;
        for (int i = 0; i < length; ++i) {
            RegistryNode child = (RegistryNode)this.children.get(i);
            if (!printChild && (child.children == null || child.children.size() <= 0)) continue;
            printChild = true;
            child.print(os, depth + 2);
        }
        this.printSpaces(os, depth);
        os.println("</" + this.getName() + ">");
    }

    private void printSpaces(WriteStream os, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            os.print(' ');
        }
    }

    public Object clone() {
        RegistryNode clone = new RegistryNode(this.root, this.name, this.value, this.filename, this.line);
        clone.parent = this.parent;
        if (this.children != null) {
            clone.children = new ArrayList();
            for (int i = 0; i < this.children.size(); ++i) {
                clone.children.add(this.children.get(i));
            }
        }
        return clone;
    }

    public String toString() {
        return "[RegistryNode " + this.name + " " + this.value + "]";
    }

    class RegistryIterator
    implements Iterator {
        int i;
        String key;

        public RegistryIterator() {
        }

        public RegistryIterator(String key) {
            this.key = key;
            this.findNext();
        }

        private void findNext() {
            if (this.key == null || RegistryNode.this.children == null) {
                return;
            }
            while (this.i < RegistryNode.this.children.size()) {
                RegistryNode registry = (RegistryNode)RegistryNode.this.children.get(this.i);
                if (registry.name.equals(this.key)) {
                    return;
                }
                ++this.i;
            }
        }

        public boolean hasNext() {
            return RegistryNode.this.children != null && this.i < RegistryNode.this.children.size();
        }

        public Object next() {
            if (RegistryNode.this.children == null || this.i >= RegistryNode.this.children.size()) {
                return null;
            }
            Object next = RegistryNode.this.children.get(this.i);
            ++this.i;
            this.findNext();
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

