/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InterruptedIOException;

public class JniStream
extends StreamImpl {
    private static final int INTERRUPT_EXN = -2;
    private static final int DISCONNECT_EXN = -3;
    private static final int TIMEOUT_EXN = -4;
    private static NullPath NULL_PATH;
    private static boolean _hasInitJni;
    private int _fd;
    private boolean _flushOnNewline;
    private boolean _closeChildOnClose = true;

    public JniStream(int fd) {
        this.init(fd);
        if (NULL_PATH == null) {
            NULL_PATH = new NullPath("jni-stream");
        }
        this.setPath(NULL_PATH);
    }

    public JniStream() {
        if (NULL_PATH == null) {
            NULL_PATH = new NullPath("jni-stream");
        }
        this.setPath(NULL_PATH);
    }

    public void init(int fd) {
        this._fd = fd;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this.readNative(this._fd, buf, offset, length);
        if (result >= -1) {
            return result;
        }
        throw this.exception(result);
    }

    native int readNative(int var1, byte[] var2, int var3, int var4) throws IOException;

    public int getAvailable() throws IOException {
        return -1;
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this.writeNative(this._fd, buf, offset, length);
        if (result < -1) {
            throw this.exception(result);
        }
    }

    native int writeNative(int var1, byte[] var2, int var3, int var4) throws IOException;

    public void flush() throws IOException {
    }

    IOException exception(int result) throws IOException {
        switch (result) {
            case -2: {
                return new InterruptedIOException("interrupted i/o");
            }
            case -4: {
                return new ClientDisconnectException("client timeout");
            }
        }
        return new ClientDisconnectException("connection reset by peer");
    }

    native int flushNative(int var1) throws IOException;

    public void close() throws IOException {
        int fd = this._fd;
        this._fd = 0;
        if (fd != 0) {
            this.closeNative(fd);
        }
    }

    native int closeNative(int var1) throws IOException;
}

