/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.expr.NumberVar;
import com.caucho.xpath.expr.Var;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class NumericExpr
extends Expr {
    private int code;
    private Expr left;
    private Expr right;
    private double value;
    private ArrayList args;
    private AbstractPattern axis;
    private AbstractPattern pattern;

    public NumericExpr(int code, Expr left, Expr right) {
        this.code = code;
        this.left = left;
        this.right = right;
    }

    public NumericExpr(int code, Expr expr) {
        this.code = code;
        this.left = expr;
    }

    public NumericExpr(double value) {
        this.code = 0;
        this.value = value;
    }

    public NumericExpr(int code, ArrayList args) {
        this.code = code;
        this.args = args;
        if (args.size() > 0) {
            this.left = (Expr)args.get(0);
        }
        if (args.size() > 1) {
            this.right = (Expr)args.get(1);
        }
    }

    public NumericExpr(int code, AbstractPattern axis, AbstractPattern pattern) {
        this.code = code;
        this.axis = axis;
        this.pattern = pattern;
    }

    public NumericExpr(int code, AbstractPattern listPattern) {
        this.code = code;
        if ((code == 38 || code == 40) && listPattern != null) {
            this.axis = listPattern.copyAxis();
            this.pattern = listPattern.copyPosition();
        } else {
            this.pattern = listPattern;
        }
    }

    public AbstractPattern getListContext() {
        switch (this.code) {
            case 38: 
            case 40: {
                return this.pattern;
            }
        }
        return null;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isConstant() {
        return this.code == 0;
    }

    public double getValue() {
        return this.value;
    }

    public Var evalVar(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        return NumberVar.create(value);
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        switch (this.code) {
            case 0: {
                return this.value;
            }
            case 21: {
                return -this.left.evalNumber(node, env);
            }
            case 22: {
                return this.left.evalNumber(node, env) + this.right.evalNumber(node, env);
            }
            case 23: {
                return this.left.evalNumber(node, env) - this.right.evalNumber(node, env);
            }
            case 24: {
                return this.left.evalNumber(node, env) * this.right.evalNumber(node, env);
            }
            case 25: {
                return this.left.evalNumber(node, env) / this.right.evalNumber(node, env);
            }
            case 26: {
                return (int)(this.left.evalNumber(node, env) / this.right.evalNumber(node, env));
            }
            case 27: {
                return this.left.evalNumber(node, env) % this.right.evalNumber(node, env);
            }
            case 33: {
                if (this.left != null) {
                    return this.left.evalNumber(node, env);
                }
                return NumericExpr.toDouble(node);
            }
            case 35: {
                return Math.floor(this.left.evalNumber(node, env));
            }
            case 36: {
                return Math.ceil(this.left.evalNumber(node, env));
            }
            case 37: {
                return Math.rint(this.left.evalNumber(node, env));
            }
            case 34: {
                return this.sum(node, env);
            }
            case 38: {
                return this.position(node, env);
            }
            case 40: {
                return this.last(node, env);
            }
            case 39: {
                return this.count(node, env);
            }
            case 48: {
                String str = this.left.evalString(node, env);
                if (str == null) {
                    return 0.0;
                }
                return str.length();
            }
        }
        throw new RuntimeException("unknown code: " + (char)this.code);
    }

    private int position(Node node, ExprEnvironment env) throws XPathException {
        int position = env.getContextPosition();
        if (position > 0) {
            return position;
        }
        if (this.axis == null || !(env instanceof Env)) {
            throw new RuntimeException("position called with no context");
        }
        if (this.pattern == null) {
            return this.axis.position(node, (Env)env, null);
        }
        return this.axis.position(node, (Env)env, this.pattern.copyPosition());
    }

    private int last(Node node, ExprEnvironment env) throws XPathException {
        int size = env.getContextSize();
        if (size > 0) {
            return size;
        }
        if (this.axis == null || !(env instanceof Env)) {
            throw new RuntimeException("last called with no context");
        }
        if (this.pattern == null) {
            return this.axis.position(node, (Env)env, null);
        }
        return this.axis.count(node, (Env)env, this.pattern.copyPosition());
    }

    private int count(Node node, ExprEnvironment env) throws XPathException {
        int count = 0;
        NodeIterator iter = this.pattern.selectUnique(node, env);
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    private double sum(Node node, ExprEnvironment env) throws XPathException {
        double sum = 0.0;
        NodeIterator iter = this.pattern.selectUnique(node, env);
        while (iter.hasNext()) {
            Node subnode = (Node)iter.next();
            String textValue = XmlUtil.textValue(subnode);
            sum += NumericExpr.stringToNumber(textValue);
        }
        return sum;
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        return value != 0.0 && !Double.isNaN(value);
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        if ((double)((int)value) == value) {
            return String.valueOf((int)value);
        }
        return String.valueOf(value);
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        return new Double(this.evalNumber(node, env));
    }

    public String toString() {
        switch (this.code) {
            case 0: {
                return String.valueOf(this.value);
            }
            case 21: {
                return "-" + this.left;
            }
            case 22: {
                return "(" + this.left + " + " + this.right + ")";
            }
            case 23: {
                return "(" + this.left + " - " + this.right + ")";
            }
            case 24: {
                return "(" + this.left + " * " + this.right + ")";
            }
            case 25: {
                return "(" + this.left + " div " + this.right + ")";
            }
            case 26: {
                return "(" + this.left + " quo " + this.right + ")";
            }
            case 27: {
                return "(" + this.left + " mod " + this.right + ")";
            }
            case 33: {
                return "number(" + this.left + ")";
            }
            case 34: {
                return "sum(" + this.pattern + ")";
            }
            case 35: {
                return "floor(" + this.left + ")";
            }
            case 36: {
                return "ceiling(" + this.left + ")";
            }
            case 37: {
                return "round(" + this.left + ")";
            }
            case 38: {
                return "position()";
            }
            case 39: {
                return "count(" + this.pattern + ")";
            }
            case 40: {
                return "last()";
            }
            case 48: {
                return "string-length(" + this.left + ")";
            }
        }
        return super.toString();
    }
}

