/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromDescendants
extends Axis {
    private boolean self;

    public FromDescendants(AbstractPattern parent, boolean self) {
        super(parent);
        this.self = self;
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (!this.self) {
            node = node.getParentNode();
        }
        while (node != null) {
            if (this.parent.match(node, env)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int pos = 0;
        Node parentNode = node;
        Node ptr = node;
        for (int index = env.getPositionIndex(); index >= 0; --index) {
            while (parentNode != null && !this.parent.match(parentNode, env)) {
                parentNode = parentNode.getParentNode();
            }
            while (ptr != null && (ptr != parentNode || this.self)) {
                if (pattern.match(ptr, env)) {
                    ++pos;
                }
                if (ptr == parentNode) break;
                ptr = XmlUtil.getPrevious(ptr);
            }
            if (index <= 0 || parentNode == null) break;
            parentNode = parentNode.getParentNode();
            if (!this.self) continue;
            ptr = XmlUtil.getPrevious(ptr);
        }
        if (parentNode != null) {
            parentNode = parentNode.getParentNode();
        }
        while (parentNode != null) {
            if (this.parent.match(parentNode, env)) {
                env.setMorePositions(true);
                break;
            }
            parentNode = parentNode.getParentNode();
        }
        return pos;
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        Node axis = this.self ? this.getAxisContext(node, env) : this.getAxisContext(node.getParentNode(), env);
        for (int index = env.getPositionIndex(); index > 0; --index) {
            axis = this.getAxisContext(axis.getParentNode(), env);
        }
        if (this.getAxisContext(axis.getParentNode(), env) != null) {
            env.setMorePositions(true);
        }
        int count = 0;
        Node ptr = axis;
        while (ptr != null) {
            if (pattern.match(ptr, env)) {
                ++count;
            }
            ptr = XmlUtil.getNext(ptr);
        }
        return count;
    }

    private Node getAxisContext(Node node, ExprEnvironment env) throws XPathException {
        while (node != null) {
            if (this.parent.match(node, env)) {
                return node;
            }
            node = node.getParentNode();
        }
        return node;
    }

    public boolean isStrictlyAscending() {
        if (this.parent == null) {
            return true;
        }
        return this.parent.isSingleLevel();
    }

    public Node firstNode(Node node, ExprEnvironment env) {
        if (this.self) {
            return node;
        }
        return node.getFirstChild();
    }

    public Node nextNode(Node node, Node lastNode) {
        Node next = XmlUtil.getNext(node);
        return next == lastNode ? null : next;
    }

    public Node lastNode(Node node) {
        Node last;
        for (last = node; last != null && last.getNextSibling() == null; last = last.getParentNode()) {
        }
        return last != null ? last.getNextSibling() : null;
    }

    public String toString() {
        if (this.self) {
            return this.getPrefix() + "descendant-or-self::";
        }
        return this.getPrefix() + "descendant::";
    }
}

