/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromAny;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import org.w3c.dom.Node;

public class NodePattern
extends AbstractPattern {
    private NodePattern match;
    private String tag;
    private int nodeType;

    public NodePattern(AbstractPattern parent, String tag, int nodeType) {
        super(parent);
        this.tag = tag.intern();
        this.nodeType = nodeType;
    }

    public double getPriority() {
        if (this.parent == null || this.parent instanceof FromChildren && (this.parent.parent instanceof FromAny || this.parent.parent instanceof FromContext)) {
            return 0.0;
        }
        return 0.5;
    }

    public String getNodeName() {
        return this.tag;
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != this.nodeType) {
            return false;
        }
        if (node.getNodeName() != this.tag) {
            return false;
        }
        return this.parent == null || this.parent.match(node, env);
    }

    public AbstractPattern copyPosition() {
        if (this.match == null) {
            AbstractPattern parent = null;
            if (this.parent != null) {
                parent = this.parent.copyPosition();
            }
            this.match = new NodePattern(parent, this.tag, this.nodeType);
        }
        return this.match;
    }

    public boolean equals(Object b) {
        if (!(b instanceof NodePattern)) {
            return false;
        }
        NodePattern bPattern = (NodePattern)b;
        return this.nodeType == bPattern.nodeType && this.tag.equals(bPattern.tag) && (this.parent == bPattern.parent || this.parent != null && this.parent.equals(bPattern.parent));
    }

    public String toString() {
        String prefix = this.parent == null || this.parent instanceof FromAny ? "" : (this.parent instanceof FromChildren ? this.parent.getPrefix() : this.parent.toString());
        switch (this.nodeType) {
            case 7: {
                return prefix + "pi('" + this.tag + "')";
            }
            case 2: {
                return prefix + this.tag;
            }
            case 1: {
                return prefix + this.tag;
            }
        }
        return super.toString();
    }
}

