/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.LineMap;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QDocument;
import com.caucho.xml.SAXBuilder;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlParser;
import com.caucho.xml.XmlPrinter;
import com.caucho.xpath.XPathFun;
import com.caucho.xsl.StringSource;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class TransformerImpl
extends Transformer
implements com.caucho.transform.Transformer {
    protected static L10N L = new L10N("com/caucho/xsl/messages");
    public static final String LINE_MAP = "caucho.line-map";
    public static final String CACHE_DEPENDS = "caucho.cache.depends";
    public static final String GENERATE_LOCATION = "caucho.generate.location";
    protected StylesheetImpl stylesheet;
    protected HashMap properties = new HashMap();
    protected HashMap parameters;
    private URIResolver uriResolver;
    private ErrorListener errorListener;
    private Properties output;
    protected LineMap lineMap;
    protected ArrayList cacheDepends = new ArrayList();

    protected TransformerImpl(StylesheetImpl stylesheet) {
        this.stylesheet = stylesheet;
        this.uriResolver = stylesheet.getURIResolver();
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public boolean getFeature(String name) {
        if (name.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        return name.equals("http://javax.xml.transform.sax.SAXResult/feature");
    }

    public void setFeature(String name, boolean enable) {
        if (name.equals(GENERATE_LOCATION)) {
            this.stylesheet.setGenerateLocation(enable);
        }
    }

    public StylesheetImpl getStylesheet() {
        return this.stylesheet;
    }

    public Object getProperty(String name) {
        Object property = this.properties.get(name);
        if (property != null) {
            return property;
        }
        if (name.equals(CACHE_DEPENDS)) {
            return this.cacheDepends;
        }
        if (name.equals(LINE_MAP)) {
            return this.lineMap;
        }
        return this.stylesheet.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
    }

    public Properties getOutputProperties() {
        if (this.output == null) {
            this.output = (Properties)this.stylesheet.getOutputProperties().clone();
        }
        return (Properties)this.output.clone();
    }

    public void setOutputProperties(Properties properties) {
        this.output = properties;
    }

    public void setOutputProperty(String name, String value) {
        if (this.output == null) {
            this.output = (Properties)this.stylesheet.getOutputProperties().clone();
        }
        this.output.put(name, value);
    }

    public String getOutputProperty(String name) {
        if (this.output == null) {
            this.output = (Properties)this.stylesheet.getOutputProperties().clone();
        }
        return (String)this.output.get(name);
    }

    public Object getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    public void clearParameters() {
        if (this.parameters != null) {
            this.parameters.clear();
        }
        if (this.cacheDepends != null) {
            this.cacheDepends.clear();
        }
    }

    public void addFunction(String name, XPathFun fun) {
        this.stylesheet.addFunction(name, fun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Source source, Result result) throws TransformerException {
        block15: {
            try {
                Node node = this.parseDocument(source);
                if (result instanceof StreamResult) {
                    StreamResult stream = (StreamResult)result;
                    if (stream.getOutputStream() != null) {
                        this.transform(node, stream.getOutputStream());
                        break block15;
                    }
                    if (stream.getWriter() != null) {
                        Writer writer = stream.getWriter();
                        WriteStream os = Vfs.openWrite(writer);
                        if (writer instanceof OutputStreamWriter) {
                            String javaEncoding = ((OutputStreamWriter)writer).getEncoding();
                            if (javaEncoding != null) {
                                this.transform(node, os, Encoding.getMimeName(javaEncoding));
                            } else {
                                this.transform(node, os, null);
                            }
                        } else {
                            this.transform(node, os, null);
                        }
                        os.flush();
                        os.free();
                        break block15;
                    }
                    WriteStream os = Vfs.lookup(result.getSystemId()).openWrite();
                    try {
                        this.transform(node, os, null);
                        break block15;
                    }
                    finally {
                        os.close();
                    }
                }
                if (result instanceof DOMResult) {
                    Node resultNode = ((DOMResult)result).getNode();
                    this.transform(node, resultNode);
                    break block15;
                }
                if (result instanceof SAXResult) {
                    SAXResult sax = (SAXResult)result;
                    this.transform(node, sax.getHandler(), sax.getLexicalHandler());
                    break block15;
                }
                throw new TransformerException(String.valueOf(result));
            }
            catch (TransformerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransformerExceptionWrapper(e);
            }
        }
    }

    public void transform(Node node, OutputStream os) throws TransformerException {
        if (os instanceof WriteStream) {
            String encoding = ((WriteStream)os).getEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            this.transform(node, os, encoding);
        } else {
            this.transform(node, os, null);
        }
    }

    public void transform(Node node, OutputStream os, String encoding) throws TransformerException {
        if (node == null) {
            throw new IllegalArgumentException("can't transform null node");
        }
        try {
            String jsp;
            this.lineMap = null;
            Properties output = this.getOutputProperties();
            WriteStream ws = Vfs.openWrite(os);
            XmlPrinter out = new XmlPrinter(ws);
            String method = (String)output.get("method");
            out.setMethod(method);
            if (encoding == null) {
                encoding = (String)output.get("encoding");
            }
            if (encoding == null && !(os instanceof WriteStream) && !"html".equals(method)) {
                encoding = "UTF-8";
            }
            if (encoding != null) {
                out.setEncoding(encoding);
            }
            out.setMimeType((String)output.get("media-type"));
            String omit = (String)output.get("omit-xml-declaration");
            if (omit == null || omit.equals("false") || omit.equals("no")) {
                out.setPrintDeclaration(true);
            }
            out.setStandalone((String)output.get("standalone"));
            out.setSystemId((String)output.get("doctype-system"));
            out.setPublicId((String)output.get("doctype-public"));
            String indent = (String)output.get("indent");
            if (indent != null) {
                out.setPretty(indent.equals("true") || indent.equals("yes"));
            }
            if ((jsp = (String)output.get("caucho.jsp")) != null) {
                out.setJSP(jsp.equals("true") || jsp.equals("yes"));
            }
            out.setVersion((String)output.get("version"));
            String includeContentType = (String)output.get("include-content-type");
            if (includeContentType != null) {
                out.setIncludeContentType(includeContentType.equals("true") || includeContentType.equals("yes"));
            }
            if (this.stylesheet.getGenerateLocation()) {
                if (node instanceof CauchoNode) {
                    String filename = ((CauchoNode)node).getFilename();
                    if (filename != null) {
                        out.setLineMap(filename);
                    } else {
                        out.setLineMap("anonymous.xsl");
                    }
                } else {
                    out.setLineMap("anonymous.xsl");
                }
            }
            this.stylesheet.transform(node, out, this);
            this.lineMap = out.getLineMap();
            if (os != ws) {
                ws.flush();
                ws.free();
            }
        }
        catch (TransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformerExceptionWrapper(e);
        }
    }

    public Node transform(Node sourceNode, Node destNode) throws SAXException, IOException {
        this.lineMap = null;
        if (destNode == null) {
            destNode = Xml.createDocument();
        }
        DOMBuilder out = new DOMBuilder();
        out.init(destNode);
        try {
            out.startDocument();
            this.stylesheet.transform(sourceNode, out, this);
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
        return destNode;
    }

    public void transform(Node sourceNode, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, IOException, TransformerException {
        if (contentHandler == null) {
            throw new IllegalArgumentException(L.l("null content handler"));
        }
        this.lineMap = null;
        SAXBuilder out = new SAXBuilder();
        out.setContentHandler(contentHandler);
        out.startDocument();
        this.stylesheet.transform(sourceNode, out, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node parseDocument(Source source) throws IOException, SAXException, TransformerException {
        if (source instanceof StreamSource) {
            StreamSource stream = (StreamSource)source;
            InputStream is = stream.getInputStream();
            if (is != null) {
                return this.parseDocument(is, source.getSystemId());
            }
            Reader reader = stream.getReader();
            if (reader != null) {
                ReadStream rs = Vfs.openRead(reader);
                try {
                    Node node = this.parseDocument(rs, source.getSystemId());
                    return node;
                }
                finally {
                    rs.close();
                }
            }
            if (source.getSystemId() != null) {
                ReadStream rs = Vfs.lookup(source.getSystemId()).openRead();
                try {
                    Node node = this.parseDocument(rs, source.getSystemId());
                    return node;
                }
                finally {
                    rs.close();
                }
            }
            return new QDocument();
        }
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            return node != null ? node : new QDocument();
        }
        if (source instanceof StringSource) {
            return this.parseStringDocument(((StringSource)source).getString(), source.getSystemId());
        }
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            XMLReader reader = saxSource.getXMLReader();
            InputSource inputSource = saxSource.getInputSource();
            QDocument doc = new QDocument();
            DOMBuilder builder = new DOMBuilder();
            builder.init(doc);
            reader.setContentHandler(builder);
            reader.parse(inputSource);
            return doc;
        }
        throw new TransformerException(L.l("unknown source {0}", source));
    }

    protected Node parseDocument(InputStream is, String systemId) throws IOException, SAXException {
        Xml parser = Xml.create();
        Document node = parser.parseDocument(is);
        ((XmlParser)parser).free();
        return node;
    }

    protected Node parseDocument(String url) throws IOException, SAXException {
        Xml parser = Xml.create();
        Document node = parser.parseDocument(url);
        ((XmlParser)parser).free();
        return node;
    }

    protected Node parseStringDocument(String source, String systemId) throws IOException, SAXException {
        Xml parser = Xml.create();
        Document node = parser.parseDocumentString(source);
        ((XmlParser)parser).free();
        return node;
    }

    public void addCacheDepend(Path path) {
        this.cacheDepends.add(path);
    }

    protected void addCacheDepend(String path) {
        this.cacheDepends.add(path);
    }

    public ArrayList getCacheDepends() {
        return this.cacheDepends;
    }
}

