/*
 * Copyright (c) 2005 Jason Carreira. All Rights Reserved.
 */
package com.opensymphony.async;

import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.ActionInvocation;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.TransactionStatus;

/**
 * TransactionInterceptor
 *
 * @author Jason Carreira <jcarreira@eplus.com>
 */
public class TransactionInterceptor implements Interceptor {
    private TransactionTemplate transactionTemplate;

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void destroy() {

    }

    public void init() {

    }

    public String intercept(final ActionInvocation actionInvocation) throws Exception {
        return (String) transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionStatus) {
                try {
                    return actionInvocation.invoke();
                } catch (Exception e) {
                    transactionStatus.setRollbackOnly();
                }
                return "error";
            }
        });
    }
}
