/*
 * Copyright (c) 2005 Jason Carreira. All Rights Reserved.
 */
package com.opensymphony.async.web.actions;

import com.opensymphony.async.model.Experiment;
import com.opensymphony.async.model.Run;

import java.util.Date;

/**
 * RunExperiment
 *
 * @author Jason Carreira <jcarreira@eplus.com>
 */
public class RunExperiment extends AbstractExperimentAction {
    int numRuns = 10;
    protected Experiment experiment;

    public int getNumRuns() {
        return numRuns;
    }

    public void setNumRuns(int numRuns) {
        this.numRuns = numRuns;
    }

    public String execute() throws Exception {
        experiment = new Experiment();
        for (int i = 0; i < numRuns; i++) {
            Thread.sleep(1000);
            Run run = new Run();
            experiment.addRun(run);
        }
        experiment.setEndDate(new Date());
        experimentDao.save(experiment);
        return SUCCESS;
    }

    public Experiment getExperiment() {
        return experiment;
    }
}
