/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.wrapper;

import com.caucho.es.ESArrayWrapper;
import com.caucho.es.ESBase;
import com.caucho.es.ESBeanWrapper;
import com.caucho.es.ESJavaWrapper;
import com.caucho.es.Global;
import com.caucho.es.wrapper.ESBeanInfo;
import com.caucho.es.wrapper.ESIndexedPropertyDescriptor;
import com.caucho.es.wrapper.ESIntrospector;
import com.caucho.es.wrapper.ESMethodDescriptor;
import com.caucho.es.wrapper.ESPropertyDescriptor;
import com.caucho.es.wrapper.NamedPropertyDescriptor;
import com.caucho.java.JavaCompiler;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Wrapper {
    private static Integer LOCK = new Integer(0);
    private static WriteStream dbg = LogStream.open("/caucho.com/es/wrapper");
    private String name;
    private String javaClassName;
    private Class cl;
    private boolean isPublic;
    private Path dest;
    private WriteStream os;
    private ClassLoader loader;
    private JavaCompiler compiler;
    private ESBeanInfo beanInfo;
    private IntMap hasDispatch;
    private IntMap staticHasDispatch;
    private IntMap setDispatch;
    private IntMap staticSetDispatch;
    private IntMap methodDispatch;
    private IntMap staticMethodDispatch;
    private HashMap namedProperties;
    private ArrayList overloadDispatch;
    private int depth;
    private boolean isNewline;
    private Class esBase;
    static HashMap classNames = new HashMap();
    static IntMap classTypes;
    static final int T_V = 0;
    static final int T_Z = 1;
    static final int T_B = 2;
    static final int T_S = 3;
    static final int T_C = 4;
    static final int T_I = 5;
    static final int T_L = 6;
    static final int T_F = 7;
    static final int T_D = 8;
    static final int T_STRING = 9;
    static /* synthetic */ Class class$java$lang$Throwable;

    private Wrapper(Global resin, Class cl) {
        this.name = cl.getName().replace('/', '.');
        MergePath mergePath = new MergePath();
        mergePath.addClassPath(cl.getClassLoader());
        Path destClass = mergePath.lookup(this.name.replace('.', '/') + ".class");
        if (!destClass.exists() && cl.getInterfaces().length > 0) {
            cl = cl.getInterfaces()[0];
            this.name = cl.getName().replace('/', '.');
        }
        this.javaClassName = this.toJavaClassName(this.name);
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < this.name.length(); ++i) {
            char ch = this.name.charAt(i);
            if (ch == '$') {
                cb.append("_0");
                continue;
            }
            if (ch == '_') {
                cb.append("__");
                continue;
            }
            cb.append(ch);
        }
        this.name = "_jsbean." + cb.close() + "_es";
        this.cl = cl;
        this.isPublic = Modifier.isPublic(cl.getModifiers());
        this.loader = cl.getClassLoader();
        this.compiler = JavaCompiler.create(this.loader);
        Path workPath = CauchoSystem.getWorkPath();
        this.dest = workPath.lookup(this.name.replace('.', '/') + ".java");
        this.hasDispatch = new IntMap();
        this.staticHasDispatch = new IntMap();
        this.setDispatch = new IntMap();
        this.staticSetDispatch = new IntMap();
        this.methodDispatch = new IntMap();
        this.staticMethodDispatch = new IntMap();
        this.namedProperties = new HashMap();
        this.overloadDispatch = new ArrayList();
        try {
            this.esBase = Class.forName("com.caucho.es.ESBase");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ESBase[] bean(Global resin, Class cl) throws Throwable {
        Wrapper wrapper = null;
        if (cl.isArray()) {
            ESJavaWrapper arrayWrapper = ESArrayWrapper.wrapper(resin, cl);
            return new ESBase[]{arrayWrapper.getProperty("CONSTRUCTOR"), arrayWrapper};
        }
        Integer n = LOCK;
        synchronized (n) {
            wrapper = new Wrapper(resin, cl);
            ESBeanWrapper beanWrapper = wrapper.wrap();
            beanWrapper.n = 0;
            return new ESBase[]{beanWrapper.wrapStatic(), beanWrapper};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ESBeanWrapper wrap() throws Throwable {
        ESBeanWrapper wrapper;
        Class cl;
        this.dest.getParent().mkdirs();
        Path workPath = CauchoSystem.getWorkPath();
        Path destClass = workPath.lookup(this.name.replace('.', '/') + ".class");
        SimpleClassLoader beanLoader = SimpleClassLoader.create(this.loader, CauchoSystem.getWorkPath(), this.name);
        long lastModified = destClass.getLastModified();
        if (lastModified != 0L && lastModified > this.getSourceLastModified(this.cl)) {
            try {
                cl = CauchoSystem.loadClass(this.name, false, beanLoader);
                wrapper = (ESBeanWrapper)cl.newInstance();
                if (wrapper.getVersionId() == CauchoSystem.getVersionId()) {
                    return wrapper;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        destClass.remove();
        this.os = this.dest.openWrite();
        this.beanInfo = ESIntrospector.getBeanInfo(this.cl);
        try {
            this.printHeader();
            this.printConstructors();
            this.printHasProperty();
            this.printSetProperty();
            this.printKeys();
            this.printDeletes();
            this.printMethods();
            this.printInit();
            this.printFooter();
        }
        finally {
            this.os.close();
        }
        this.compiler.compile(this.name.replace('.', '/') + ".java", null);
        try {
            cl = CauchoSystem.loadClass(this.name, false, beanLoader);
            wrapper = (ESBeanWrapper)cl.newInstance();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw e;
        }
        return wrapper;
    }

    private long getSourceLastModified(Class cl) {
        String fileName;
        long lastModified = 0L;
        URL resource = null;
        String clName = cl.getName().replace('.', '/') + ".class";
        if (this.loader != null) {
            resource = this.loader.getResource(clName);
        }
        String string = fileName = resource != null ? resource.toExternalForm() : null;
        if (resource == null || fileName.startsWith("systemresource:") || fileName.startsWith("jar:")) {
            return this.getClassPathLastModified(cl);
        }
        Path path = Vfs.lookup(fileName);
        if (path != null && path.canRead()) {
            return path.getLastModified();
        }
        return 0L;
    }

    private long getClassPathLastModified(Class cl) {
        Path path;
        String name;
        int tail;
        String clName = cl.getName().replace('.', '/') + ".class";
        String classPath = System.getProperty("java.class.path");
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        while ((tail = classPath.indexOf(sep, head)) >= 0) {
            name = classPath.substring(head, tail);
            path = Vfs.lookupNative(name);
            if (name.endsWith(".jar") || name.endsWith(".zip")) {
                path = new JarPath(path);
            }
            if (path != null && path.lookup(clName).canRead()) {
                return path.lookup(clName).getLastModified();
            }
            head = tail + 1;
        }
        name = classPath.substring(head);
        path = Vfs.lookupNative(name);
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            path = new JarPath(path);
        }
        if (path != null && path.lookup(clName).canRead()) {
            return path.lookup(clName).getLastModified();
        }
        return 0L;
    }

    private void printHeader() throws IOException {
        int p = this.name.lastIndexOf(46);
        String pkg = this.name.substring(0, p);
        String clName = this.name.substring(p + 1);
        this.println("package " + pkg + ";");
        this.println("import com.caucho.es.*;");
        Iterator iter = this.beanInfo.getNonPkgClasses().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.println("import " + name + ";");
        }
        this.println();
        this.println("public class " + clName + " extends ESBeanWrapper {");
        this.pushDepth();
        if (this.isPublic) {
            this.println("private " + this.javaClassName + " _value;");
        }
        this.println();
        this.println("public int getVersionId() { return " + CauchoSystem.getVersionId() + "; }");
        this.println();
        this.println("protected ESBeanWrapper dup()");
        this.println("{");
        this.println("  return new " + clName + "();");
        this.println("}");
        this.println();
        this.println("public ESBeanWrapper wrap(Object value)");
        this.println("{");
        this.pushDepth();
        this.println("if (value == null) throw new NullPointerException();");
        this.println(this.name + " child = new " + this.name + "();");
        this.println("child.value = value;");
        if (this.isPublic) {
            this.println("child._value = (" + this.javaClassName + ") value;");
        }
        this.println("child.hasDispatch = instanceHasDispatch;");
        this.println("child.setDispatch = instanceSetDispatch;");
        this.println("child.methodDispatch = instanceMethodDispatch;");
        this.println("child.n = -1;");
        this.println("return child;");
        this.popDepth();
        this.println("}");
        this.println();
        this.println("public ESBeanWrapper wrapStatic()");
        this.println("{");
        this.pushDepth();
        this.println(this.name + " child = new " + this.name + "();");
        this.println("child.hasDispatch = staticHasDispatch;");
        this.println("child.setDispatch = staticSetDispatch;");
        this.println("child.methodDispatch = staticMethodDispatch;");
        this.println("child.n = -2;");
        this.println("child.name = \"" + this.javaClassName + "\";");
        this.println("try {");
        this.println("  child.value = Class.forName(child.name);");
        this.println("} catch (Exception e) {}");
        this.println("return child;");
        this.popDepth();
        this.println("}");
        this.println();
        this.println("public Class getJavaType()");
        this.println("{");
        this.pushDepth();
        this.println("return value.getClass();");
        this.popDepth();
        this.println("}");
    }

    private void printConstructors() throws IOException {
        this.println();
        this.println("public ESBase construct(Call call, int length)");
        this.println("  throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("if (n != -2)");
        this.println("  throw new ESException(\"can't create `" + this.javaClassName + "'\");");
        this.println();
        if (this.printMethodConstructor()) {
            this.popDepth();
            this.println("}");
            return;
        }
        ArrayList overload = this.beanInfo.getConstructors();
        if (Modifier.isAbstract(this.cl.getModifiers())) {
            overload = null;
        }
        if (overload == null || overload.size() == 0) {
            this.println("  throw new ESException(\"can't create `" + this.javaClassName + "'\");");
        } else {
            int i;
            Constructor last = null;
            for (i = 0; i < overload.size(); ++i) {
                if (!(overload.get(i) instanceof Constructor)) continue;
                last = (Constructor)overload.get(i);
            }
            for (i = 0; i < overload.size(); ++i) {
                Object o = overload.get(i);
                if (!(o instanceof Constructor)) continue;
                Constructor constructor = (Constructor)o;
                if (constructor != last) {
                    this.println("if (length <= " + i + ")");
                    this.print("  ");
                }
                this.print("return wrap(new " + this.javaClassName + "(");
                Class<?>[] param = constructor.getParameterTypes();
                for (int j = 0; j < param.length; ++j) {
                    if (j > 0) {
                        this.print(", ");
                    }
                    this.printArgToJava(param[j], j);
                }
                this.println("));");
            }
            if (last == null) {
                this.println("throw new ESException(\"can't create `" + this.javaClassName + "'\");");
            }
        }
        this.popDepth();
        this.println("}");
    }

    private boolean printMethodConstructor() throws IOException {
        ArrayList overload = (ArrayList)this.beanInfo.staticMethodMap.get("create");
        if (overload != null) {
            this.printMethod(Integer.MIN_VALUE, "create", overload, null);
            return true;
        }
        return false;
    }

    private void printHasProperty() throws IOException {
        this.println();
        this.println("public ESBase hasProperty(ESString name)");
        this.println("  throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("ESBase temp;");
        this.println("switch (hasDispatch.get(name)) {");
        PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
        int index = 1;
        for (int i = 0; i < props.length; ++i) {
            if (props[i] instanceof NamedPropertyDescriptor) {
                index = this.doHasNamedProperty(index, (NamedPropertyDescriptor)props[i]);
                continue;
            }
            if (props[i] instanceof ESIndexedPropertyDescriptor) {
                index = this.doHasIndexProperty(index, (ESIndexedPropertyDescriptor)props[i]);
                continue;
            }
            if (props[i] instanceof ESPropertyDescriptor) {
                index = this.doHasProperty(index, (ESPropertyDescriptor)props[i]);
                continue;
            }
            throw new RuntimeException();
        }
        this.println("default:");
        this.println("  return ESBase.esEmpty;");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private int doHasIndexProperty(int i, ESIndexedPropertyDescriptor prop) throws IOException {
        Class<?> resultClass;
        Method method;
        Named named = new Named(prop.getName(), this.namedProperties.size());
        int n = named.n;
        this.namedProperties.put(prop.getName(), named);
        this.hasDispatch.put(prop.getName(), i);
        this.println("case " + i + ":");
        this.pushDepth();
        this.println("if (name" + n + " == null) {");
        this.println("  name" + n + " = new " + this.name + "();");
        this.println("  name" + n + ".value = value;");
        if (this.isPublic) {
            this.println("  name" + n + "._value = _value;");
        }
        this.println("  name" + n + ".hasDispatch = has" + n + ";");
        this.println("  name" + n + ".setDispatch = set" + n + ";");
        this.println("  name" + n + ".delId = " + n + ";");
        this.println("}");
        this.println("return name" + n + ";");
        this.popDepth();
        ++i;
        ESMethodDescriptor md = prop.getESReadMethod();
        if (md == null) {
            return i;
        }
        this.println("case " + i + ":");
        this.pushDepth();
        named.get = i;
        ESMethodDescriptor size = prop.getESSizeMethod();
        if (size != null) {
            this.println("if (name.equals(LENGTH)) {");
            this.pushDepth();
            method = size.getMethod();
            resultClass = method.getReturnType();
            this.print("return ");
            this.startJavaToES(resultClass);
            this.startProp(size);
            this.print(")");
            this.endJavaToES(resultClass);
            this.println(";");
            this.popDepth();
            this.println("} else {");
            this.pushDepth();
        }
        method = md.getMethod();
        resultClass = method.getReturnType();
        this.print("return ");
        this.startJavaToES(resultClass);
        int p = this.startProp(md);
        if (p > 0) {
            this.print(", ");
        }
        this.print("name.toInt32())");
        this.endJavaToES(resultClass);
        this.println(";");
        if (size != null) {
            this.popDepth();
            this.println("}");
        }
        this.popDepth();
        return i + 1;
    }

    private int doHasNamedProperty(int i, NamedPropertyDescriptor prop) throws IOException {
        Named named = new Named(prop.getName(), this.namedProperties.size());
        int n = named.n;
        this.namedProperties.put(prop.getName(), named);
        this.hasDispatch.put(prop.getName(), i);
        this.println("case " + i + ":");
        this.pushDepth();
        this.println("if (name" + n + " == null) {");
        this.println("  name" + n + " = new " + this.name + "();");
        this.println("  name" + n + ".value = value;");
        if (this.isPublic) {
            this.println("  name" + n + "._value = _value;");
        }
        this.println("  name" + n + ".hasDispatch = has" + n + ";");
        this.println("  name" + n + ".setDispatch = set" + n + ";");
        this.println("  name" + n + ".delId = " + n + ";");
        this.println("}");
        this.println("return name" + n + ";");
        this.popDepth();
        ++i;
        ESMethodDescriptor md = prop.getNamedReadMethod();
        if (md == null) {
            return i;
        }
        this.println("case " + i + ":");
        this.pushDepth();
        named.get = i;
        Method method = md.getMethod();
        if (Modifier.isStatic(method.getModifiers()) && !md.isStaticVirtual()) {
            this.staticHasDispatch.put(prop.getName(), i - 1);
        }
        Class<?> resultClass = method.getReturnType();
        this.print("return ");
        this.startJavaToES(resultClass);
        int p = this.startProp(md);
        if (p > 0) {
            this.print(", ");
        }
        this.print("name.toJavaString())");
        this.endJavaToES(resultClass);
        this.println(";");
        this.popDepth();
        return i + 1;
    }

    private int doHasProperty(int i, ESPropertyDescriptor prop) throws IOException {
        Field field = prop.getESField();
        ESMethodDescriptor md = prop.getESReadMethod();
        if (field != null && !Modifier.isPublic(field.getModifiers())) {
            field = null;
        }
        if (md == null && field == null) {
            return i;
        }
        this.hasDispatch.put(prop.getName(), i);
        this.println("case " + i + ":");
        this.pushDepth();
        if (field != null) {
            Class<?> resultClass = field.getType();
            this.print("return ");
            this.startJavaToES(resultClass);
            if (this.isPublic && field.getDeclaringClass().getName().equals(this.cl.getName())) {
                this.print("_value.");
            } else {
                this.print("((" + this.toJavaClassName(field.getDeclaringClass().getName()) + ") value).");
            }
            this.print(field.getName());
            this.endJavaToES(resultClass);
            this.println(";");
            this.popDepth();
            if (Modifier.isStatic(field.getModifiers())) {
                this.staticHasDispatch.put(prop.getName(), i);
            }
            return i + 1;
        }
        Method method = md.getMethod();
        if (Modifier.isStatic(method.getModifiers()) && !md.isStaticVirtual()) {
            this.staticHasDispatch.put(prop.getName(), i);
        }
        this.print("return ");
        Class<?> resultClass = method.getReturnType();
        this.startJavaToES(resultClass);
        int p = this.startProp(md);
        this.print(")");
        this.endJavaToES(resultClass);
        this.println(";");
        this.popDepth();
        return i + 1;
    }

    private void printSetProperty() throws IOException {
        this.println();
        this.println("public void setProperty(ESString name, ESBase newValue)");
        this.println("  throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("ESBase temp;");
        this.println("switch (setDispatch.get(name)) {");
        PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
        int index = 0;
        for (int i = 0; i < props.length; ++i) {
            if (props[i] instanceof NamedPropertyDescriptor) {
                index = this.doSetNamedProperty(index, (NamedPropertyDescriptor)props[i]);
                continue;
            }
            if (props[i] instanceof ESIndexedPropertyDescriptor) {
                index = this.doSetIndexProperty(index, (ESIndexedPropertyDescriptor)props[i]);
                continue;
            }
            if (props[i] instanceof ESPropertyDescriptor) {
                index = this.doSetProperty(index, (ESPropertyDescriptor)props[i]);
                continue;
            }
            throw new RuntimeException();
        }
        this.println("default:");
        this.println("  return;");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private int doSetNamedProperty(int i, NamedPropertyDescriptor prop) throws IOException {
        Named named = (Named)this.namedProperties.get(prop.getName());
        if (named == null) {
            return i;
        }
        int n = named.n;
        ESMethodDescriptor md = prop.getNamedWriteMethod();
        if (md == null) {
            return i;
        }
        this.println("case " + i + ":");
        this.pushDepth();
        named.set = i;
        int p = this.startProp(md);
        Class[] param = md.getParameterTypes();
        if (p != 0) {
            this.print(", ");
        }
        this.print("name.toJavaString(), ");
        this.printValueToJava(param[1], "newValue");
        this.println(");");
        this.println("return;");
        this.popDepth();
        return i + 1;
    }

    private int doSetIndexProperty(int i, ESIndexedPropertyDescriptor prop) throws IOException {
        Named named = (Named)this.namedProperties.get(prop.getName());
        if (named == null) {
            return i;
        }
        int n = named.n;
        ESMethodDescriptor md = prop.getESWriteMethod();
        if (md == null) {
            return i;
        }
        this.println("case " + i + ":");
        this.pushDepth();
        named.set = i;
        int p = this.startProp(md);
        Class[] param = md.getParameterTypes();
        if (p != 0) {
            this.print(", ");
        }
        this.print("name.toInt32(), ");
        this.printValueToJava(param[1], "newValue");
        this.println(");");
        this.println("return;");
        this.popDepth();
        return i + 1;
    }

    private int doSetProperty(int i, ESPropertyDescriptor prop) throws IOException {
        ESMethodDescriptor md = prop.getESWriteMethod();
        Field field = prop.getESField();
        if (field != null && Modifier.isFinal(field.getModifiers())) {
            field = null;
        }
        if (md == null && field == null) {
            return i;
        }
        this.println("case " + i + ":");
        this.pushDepth();
        this.setDispatch.put(prop.getName(), i);
        if (field != null) {
            Class<?> resultClass = field.getType();
            if (this.isPublic) {
                this.print("_value.");
            } else {
                this.print("((" + field.getDeclaringClass().getName() + ") value).");
            }
            this.print(field.getName());
            this.print(" = ");
            this.printValueToJava(resultClass, "newValue");
            this.println(";");
            this.println("return;");
            this.popDepth();
            return i + 1;
        }
        Method method = md.getMethod();
        if (Modifier.isStatic(method.getModifiers()) && !md.isStaticVirtual()) {
            this.staticSetDispatch.put(prop.getName(), i);
        }
        Class[] param = md.getParameterTypes();
        int p = this.startProp(md);
        if (p != 0) {
            this.print(", ");
        }
        this.printValueToJava(param[0], "newValue");
        this.println(");");
        this.println("return;");
        this.popDepth();
        return i + 1;
    }

    private void printKeys() throws IOException {
        this.println();
        this.println("public java.util.Iterator keys()");
        this.println("  throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("switch (delId) {");
        ESMethodDescriptor md = this.beanInfo.iterator;
        if (md != null) {
            this.println("case -1:");
            this.print("  return Call.toESIterator(");
            this.startProp(md);
            this.println("));");
        }
        PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            if (!(props[i] instanceof NamedPropertyDescriptor)) continue;
            this.printNamedKey((NamedPropertyDescriptor)props[i]);
        }
        this.println("default:");
        this.println("  return super.keys();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printNamedKey(NamedPropertyDescriptor prop) throws IOException {
        ESMethodDescriptor md = prop.getNamedIteratorMethod();
        if (md == null) {
            return;
        }
        Named named = (Named)this.namedProperties.get(prop.getName());
        this.println("case " + named.n + ":");
        this.pushDepth();
        this.print("return Call.toESIterator(");
        int p = this.startProp(md);
        this.println("));");
        this.popDepth();
    }

    private void printDeletes() throws IOException {
        this.println();
        this.println("public ESBase delete(ESString key)");
        this.println("  throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("switch (delId) {");
        PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            if (!(props[i] instanceof NamedPropertyDescriptor)) continue;
            this.printNamedDelete((NamedPropertyDescriptor)props[i]);
        }
        this.println("default:");
        this.println("  return ESBoolean.FALSE;");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printNamedDelete(NamedPropertyDescriptor prop) throws IOException {
        ESMethodDescriptor md = prop.getNamedRemoveMethod();
        if (md == null) {
            return;
        }
        Named named = (Named)this.namedProperties.get(prop.getName());
        this.println("case " + named.n + ":");
        this.pushDepth();
        int p = this.startProp(md);
        if (p > 0) {
            this.print(", ");
        }
        this.println("key.toJavaString());");
        this.println("return ESBoolean.TRUE;");
        this.popDepth();
    }

    private void printMethods() throws IOException {
        String name;
        Map.Entry entry;
        this.println();
        this.println("public ESBase call(Call call, int length, int n)");
        this.println("  throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("ESBase temp;");
        this.println("switch (n) {");
        ArrayList overload = (ArrayList)this.beanInfo.methodMap.get("call");
        if (overload != null) {
            this.printMethod(-1, "call", overload, null);
        }
        ArrayList create = (ArrayList)this.beanInfo.staticMethodMap.get("create");
        ArrayList call = (ArrayList)this.beanInfo.staticMethodMap.get("call");
        if (create != null) {
            this.printMethod(-2, "create", create, null);
        } else if (call != null) {
            this.printMethod(-2, "call", create, null);
        } else {
            this.println("case -2:");
            this.println("  return construct(call, length);");
        }
        Iterator iter = this.beanInfo.methodMap.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            entry = iter.next();
            overload = (ArrayList)entry.getValue();
            name = (String)entry.getKey();
            i = this.printMethod(i, name, overload, this.methodDispatch);
        }
        iter = this.beanInfo.staticMethodMap.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            overload = (ArrayList)entry.getValue();
            name = (String)entry.getKey();
            i = this.printMethod(i, name, overload, this.staticMethodDispatch);
        }
        this.println("}");
        this.println("return ESBase.esUndefined;");
        this.popDepth();
        this.println("}");
    }

    private int printMethod(int i, String name, ArrayList overload, IntMap dispatch) throws IOException {
        int j;
        ESMethodDescriptor[] last = null;
        if (overload == null) {
            return i;
        }
        for (j = 0; j < overload.size(); ++j) {
            last = (ESMethodDescriptor[])overload.get(j);
        }
        if (last == null) {
            return i;
        }
        if (i > -100) {
            this.println("case " + i + ":");
            this.pushDepth();
            if (dispatch != null) {
                dispatch.put(name, i++);
            }
        }
        if (overload.size() > 2) {
            ESMethodDescriptor[] mds = (ESMethodDescriptor[])overload.get(2);
            for (int j2 = 0; mds != null && j2 < mds.length; ++j2) {
                Class[] cl = mds[j2].getParameterTypes();
                int p = cl.length - 2;
                if (!cl[0].getName().equals("com.caucho.es.Call") || !cl[1].getName().equals("int")) continue;
                this.printMethod(mds[j2], dispatch == null);
                this.popDepth();
                return i;
            }
        }
        for (j = 0; j < overload.size(); ++j) {
            Object o = overload.get(j);
            if (o == null) continue;
            ESMethodDescriptor[] mds = (ESMethodDescriptor[])o;
            if (mds != last) {
                this.println("if (length <= " + j + ") {");
                this.pushDepth();
            }
            if (mds.length == 1) {
                this.printMethod(mds[0], dispatch == null);
            } else {
                String var = "dispatch" + this.overloadDispatch.size();
                this.overloadDispatch.add(mds);
                this.println("switch (" + var + ".select(call, length)) {");
                for (int k = 0; k < mds.length; ++k) {
                    this.println("case " + k + ":");
                    this.pushDepth();
                    this.printMethod(mds[k], dispatch == null);
                    this.popDepth();
                }
                this.println("default:");
                this.println("  throw new ESException(\"no matching method " + mds[0].getName() + "\");");
                this.println("}");
            }
            if (mds == last) continue;
            this.popDepth();
            this.println("}");
        }
        if (i > -100) {
            this.popDepth();
        }
        return i;
    }

    private void printMethod(ESMethodDescriptor md, boolean isProp) throws IOException {
        boolean hasThrowable = this.hasException(md.getMethod().getExceptionTypes(), class$java$lang$Throwable == null ? (class$java$lang$Throwable = Wrapper.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        Class returnCl = md.getReturnType();
        if (!returnCl.getName().equals("void")) {
            this.print("return ");
            this.startJavaToES(returnCl);
        }
        Class[] param = md.getParameterTypes();
        int p = isProp ? this.startProp(md) : this.startCall(md);
        if (param.length == 2 && param[0].getName().equals("com.caucho.es.Call") && param[1].getName().equals("int")) {
            if (p > 0) {
                this.print(", ");
            }
            this.print("call, length");
        } else {
            for (int j = 0; j < param.length; ++j) {
                if (j + p > 0) {
                    this.print(", ");
                }
                this.printArgToJava(param[j], j);
            }
        }
        if (returnCl.getName().equals("void")) {
            this.println(");");
            this.println("return ESBase.esUndefined;");
        } else {
            this.print(")");
            this.endJavaToES(returnCl);
            this.println(";");
        }
    }

    private boolean hasException(Class[] exn, Class cl) {
        for (int i = 0; i < exn.length; ++i) {
            if (!exn[i].isAssignableFrom(cl)) continue;
            return true;
        }
        return false;
    }

    private int startProp(ESMethodDescriptor md) throws IOException {
        Method method = md.getMethod();
        int p = 0;
        if (md.isStaticVirtual()) {
            this.print(md.getMethodClassName());
            this.print(".");
            this.print(md.getMethod().getName());
            if (this.isPublic) {
                this.print("(_value");
            } else {
                this.print("((" + this.toJavaClassName(md.getObjectClassName()) + ") value");
            }
            p = 1;
        } else if (Modifier.isStatic(method.getModifiers())) {
            this.print(md.getMethodClassName());
            this.print(".");
            this.print(md.getMethod().getName());
            this.print("(");
        } else {
            if (this.isPublic) {
                this.print("_value.");
            } else {
                this.print("((" + this.toJavaClassName(md.getObjectClassName()) + ") value).");
            }
            this.print(md.getMethod().getName());
            this.print("(");
        }
        return p;
    }

    private int startCall(ESMethodDescriptor md) throws IOException {
        Method method = md.getMethod();
        int p = 0;
        if (md.isStaticVirtual()) {
            this.print(this.toJavaClassName(md.getMethodClassName()));
            this.print(".");
            this.print(md.getMethod().getName());
            this.print("((" + md.getObjectClassName() + ") call.getThisWrapper()");
            p = 1;
        } else if (Modifier.isStatic(method.getModifiers())) {
            this.print(this.toJavaClassName(md.getMethodClassName()));
            this.print(".");
            this.print(md.getMethod().getName());
            this.print("(");
        } else {
            this.print("((" + this.toJavaClassName(md.getObjectClassName()) + ") call.getThisWrapper()).");
            this.print(md.getMethod().getName());
            this.print("(");
        }
        return p;
    }

    private void startJavaToES(Class cl) throws IOException {
        String name = cl.getName();
        switch (classTypes.get(name)) {
            case 0: {
                break;
            }
            case 1: {
                this.print("ESBoolean.create(");
                break;
            }
            case 4: {
                this.print("ESString.createFromCharCode(");
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.print("ESNumber.create(");
                break;
            }
            case 9: {
                this.print("ESString.toStr(");
                break;
            }
            default: {
                if (this.esBase.isAssignableFrom(cl)) {
                    this.print("((temp = ");
                    break;
                }
                this.print("Global.wrap(");
            }
        }
    }

    private void endJavaToES(Class cl) throws IOException {
        String name = cl.getName();
        switch (classTypes.get(name)) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.print(")");
                break;
            }
            default: {
                if (this.esBase.isAssignableFrom(cl)) {
                    this.print(") == null ? ESBase.esNull : temp)");
                    break;
                }
                this.print(")");
            }
        }
    }

    private void printValueToJava(Class cl, String value) throws IOException {
        String name = cl.getName();
        switch (classTypes.get(name)) {
            case 0: {
                throw new RuntimeException();
            }
            case 1: {
                this.print(value + ".toBoolean()");
                break;
            }
            case 4: {
                this.print("(char) " + value + ".toStr().carefulCharAt(0)");
                break;
            }
            case 2: {
                this.print("(byte) " + value + ".toInt32()");
                break;
            }
            case 3: {
                this.print("(short) " + value + ".toInt32()");
                break;
            }
            case 5: {
                this.print(value + ".toInt32()");
                break;
            }
            case 6: {
                this.print("(long)" + value + ".toNum()");
                break;
            }
            case 7: {
                this.print("(float)" + value + ".toNum()");
                break;
            }
            case 8: {
                this.print(value + ".toNum()");
                break;
            }
            case 9: {
                this.print("(" + value + ").toJavaString()");
                break;
            }
            default: {
                if (cl.isAssignableFrom(this.esBase)) {
                    this.print(value);
                    break;
                }
                if (this.esBase.isAssignableFrom(cl)) {
                    this.print("(");
                    this.printClassType(cl);
                    this.print(") " + value);
                    break;
                }
                this.print("(");
                this.printClassType(cl);
                this.print(") " + value + ".toJavaObject()");
            }
        }
    }

    private void printArgToJava(Class cl, int i) throws IOException {
        String name = cl.getName();
        switch (classTypes.get(name)) {
            case 0: {
                throw new RuntimeException();
            }
            case 1: {
                this.print("call.getArg(" + i + ", length).toBoolean()");
                break;
            }
            case 4: {
                this.print("(char) call.getArg(" + i + ", length).toStr().carefulCharAt(0)");
                break;
            }
            case 2: {
                this.print("(byte) call.getArgInt32(" + i + ", length)");
                break;
            }
            case 3: {
                this.print("(short) call.getArgInt32(" + i + ", length)");
                break;
            }
            case 5: {
                this.print("call.getArgInt32(" + i + ", length)");
                break;
            }
            case 6: {
                this.print("(long) call.getArgNum(" + i + ", length)");
                break;
            }
            case 7: {
                this.print("(float)call.getArgNum(" + i + ", length)");
                break;
            }
            case 8: {
                this.print("call.getArgNum(" + i + ", length)");
                break;
            }
            case 9: {
                this.print("call.getArgString(" + i + ", length)");
                break;
            }
            default: {
                if (cl.isAssignableFrom(this.esBase) && !cl.getName().equals("java.lang.Object")) {
                    this.print("call.getArg(" + i + ", length)");
                    break;
                }
                if (this.esBase.isAssignableFrom(cl)) {
                    this.print("(");
                    this.printClassType(cl);
                    this.print(") ");
                    this.print("call.getArg(" + i + ", length)");
                    break;
                }
                this.print("(");
                this.printClassType(cl);
                this.print(") call.getArgObject(" + i + ", length)");
            }
        }
    }

    private void printClassType(Class cl) throws IOException {
        if (cl.isArray()) {
            this.printClassType(cl.getComponentType());
            this.print("[]");
        } else {
            this.print(cl.getName());
        }
    }

    private void printInit() throws IOException {
        this.println("private int delId = -1;");
        this.println();
        this.println("private static com.caucho.util.IntMap instanceHasDispatch;");
        this.println("private static com.caucho.util.IntMap instanceSetDispatch;");
        this.println("private static com.caucho.util.IntMap instanceMethodDispatch;");
        this.println("private static com.caucho.util.IntMap staticMethodDispatch;");
        this.println("private static com.caucho.util.IntMap staticHasDispatch;");
        this.println("private static com.caucho.util.IntMap staticSetDispatch;");
        Iterator iter = this.namedProperties.values().iterator();
        while (iter.hasNext()) {
            Named named = (Named)iter.next();
            this.println(this.name + " name" + named.n + ";");
            this.print("private static ConstIntMap has" + named.n);
            this.println(" = new ConstIntMap(" + named.get + ");");
            this.print("private static ConstIntMap set" + named.n);
            this.println(" = new ConstIntMap(" + named.set + ");");
        }
        for (int i = 0; i < this.overloadDispatch.size(); ++i) {
            this.print("private static com.caucho.es.wrapper.MethodDispatcher dispatch" + i);
            this.println(" = new com.caucho.es.wrapper.MethodDispatcher(new Class[][] {");
            this.pushDepth();
            ESMethodDescriptor[] mds = (ESMethodDescriptor[])this.overloadDispatch.get(i);
            for (int j = 0; j < mds.length; ++j) {
                this.print("new Class[] {");
                Class[] param = mds[j].getParameterTypes();
                for (int k = 0; k < param.length; ++k) {
                    this.printClass(param[k]);
                    this.print(", ");
                }
                this.println("},");
            }
            this.popDepth();
            this.println("});");
        }
        this.println();
        this.println("static { _init(); }");
        this.println();
        this.println("private static void _init()");
        this.println("{");
        this.pushDepth();
        this.println("instanceHasDispatch = new com.caucho.util.IntMap();");
        iter = this.hasDispatch.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.println("instanceHasDispatch.put(ESId.intern(\"" + key + "\"), " + this.hasDispatch.get(key) + ");");
        }
        this.println();
        this.println("staticHasDispatch = new com.caucho.util.IntMap();");
        iter = this.staticHasDispatch.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.println("staticHasDispatch.put(ESId.intern(\"" + key + "\"), " + this.staticHasDispatch.get(key) + ");");
        }
        this.println();
        this.println("instanceSetDispatch = new com.caucho.util.IntMap();");
        iter = this.setDispatch.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.println("instanceSetDispatch.put(ESId.intern(\"" + key + "\"), " + this.setDispatch.get(key) + ");");
        }
        this.println();
        this.println("staticSetDispatch = new com.caucho.util.IntMap();");
        iter = this.staticSetDispatch.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.println("staticSetDispatch.put(ESId.intern(\"" + key + "\"), " + this.staticSetDispatch.get(key) + ");");
        }
        this.println();
        this.println("instanceMethodDispatch = new com.caucho.util.IntMap();");
        iter = this.methodDispatch.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.println("instanceMethodDispatch.put(ESId.intern(\"" + key + "\"), " + this.methodDispatch.get(key) + ");");
        }
        this.println();
        this.println("staticMethodDispatch = new com.caucho.util.IntMap();");
        iter = this.staticMethodDispatch.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.println("staticMethodDispatch.put(ESId.intern(\"" + key + "\"), " + this.staticMethodDispatch.get(key) + ");");
        }
        this.popDepth();
        this.println("}");
    }

    private void printClass(Class cl) throws IOException {
        if (!cl.isArray()) {
            this.print(cl.getName() + ".class");
            return;
        }
        this.print("(new ");
        this.printArrayClass(cl.getComponentType());
        this.print("[0]).getClass()");
    }

    private void printArrayClass(Class cl) throws IOException {
        if (cl.isArray()) {
            this.printArrayClass(cl.getComponentType());
            this.print("[]");
        } else {
            this.print(cl.getName());
        }
    }

    private void printFooter() throws IOException {
        this.popDepth();
        this.println("}");
    }

    private void pushDepth() {
        this.depth += 2;
    }

    private void popDepth() {
        this.depth -= 2;
    }

    private void print(String s) throws IOException {
        if (this.isNewline) {
            this.printDepth();
        }
        this.os.print(s);
    }

    private void println(String s) throws IOException {
        if (this.isNewline) {
            this.printDepth();
        }
        this.os.println(s);
        this.isNewline = true;
    }

    private void println() throws IOException {
        if (this.isNewline) {
            this.printDepth();
        }
        this.os.println();
        this.isNewline = true;
    }

    private void printDepth() throws IOException {
        for (int i = 0; i < this.depth; ++i) {
            this.os.print(' ');
        }
        this.isNewline = false;
    }

    private String toJavaClassName(String name) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '$' && i > 0 && name.charAt(i - 1) != '.') {
                cb.append(".");
                continue;
            }
            cb.append(ch);
        }
        return cb.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classNames.put("void", "V");
        classNames.put("boolean", "Z");
        classNames.put("byte", "B");
        classNames.put("short", "S");
        classNames.put("char", "C");
        classNames.put("int", "I");
        classNames.put("long", "J");
        classNames.put("float", "F");
        classNames.put("double", "D");
        classTypes = new IntMap();
        classTypes.put("void", 0);
        classTypes.put("boolean", 1);
        classTypes.put("byte", 2);
        classTypes.put("short", 3);
        classTypes.put("char", 4);
        classTypes.put("int", 5);
        classTypes.put("long", 6);
        classTypes.put("float", 7);
        classTypes.put("double", 8);
        classTypes.put("java.lang.String", 9);
    }

    static class Named {
        String name;
        int n;
        int get = -1;
        int set = -1;
        int keys = -1;
        int remove = -1;

        Named(String name, int n) {
            this.name = name;
            this.n = n;
        }
    }
}

